/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.Msg;
import java.net.URL;
import java.util.List;

public enum DebuggerStaticMappingUtils {


    protected static <T> T noProject(Object originator) {
        Msg.warn((Object)originator, (Object)"The given program does not exist in any project");
        return null;
    }

    public static void addMapping(TraceLocation from, ProgramLocation to, long length, boolean truncateExisting) throws TraceConflictedMappingException {
        Program tp = to.getProgram();
        if (tp instanceof TraceProgramView) {
            throw new IllegalArgumentException("Mapping destination cannot be a " + TraceProgramView.class.getSimpleName());
        }
        TraceStaticMappingManager manager = from.getTrace().getStaticMappingManager();
        URL toURL = ProgramURLUtils.getUrlFromProgram(tp);
        if (toURL == null) {
            DebuggerStaticMappingUtils.noProject(DebuggerStaticMappingService.class);
        }
        try {
            Address start = from.getAddress();
            Address end = start.addNoWrap(length - 1L);
            Address toAddress = to.getAddress();
            toAddress.addNoWrap(length - 1L);
            AddressRangeImpl range = new AddressRangeImpl(start, end);
            if (truncateExisting) {
                long truncEnd = DBTraceUtils.lowerEndpoint((Range)from.getLifespan()) - 1L;
                for (TraceStaticMapping existing : List.copyOf(manager.findAllOverlapping((AddressRange)range, from.getLifespan()))) {
                    existing.delete();
                    if (Long.compareUnsigned(existing.getStartSnap(), truncEnd) >= 0) continue;
                    manager.add(existing.getTraceAddressRange(), Range.closed((Comparable)Long.valueOf(existing.getStartSnap()), (Comparable)Long.valueOf(truncEnd)), existing.getStaticProgramURL(), existing.getStaticAddress());
                }
            }
            manager.add((AddressRange)range, from.getLifespan(), toURL, toAddress.toString(true));
        }
        catch (AddressOverflowException e) {
            throw new IllegalArgumentException("Length would cause address overflow", e);
        }
    }

    public static void addModuleMapping(TraceModule from, long length, Program toProgram, boolean truncateExisting) throws TraceConflictedMappingException {
        DefaultTraceLocation fromLoc = new DefaultTraceLocation(from.getTrace(), null, from.getLifespan(), from.getBase());
        ProgramLocation toLoc = new ProgramLocation(toProgram, toProgram.getImageBase());
        DebuggerStaticMappingUtils.addMapping((TraceLocation)fromLoc, toLoc, length, truncateExisting);
    }

    public static void addSectionMapping(TraceSection from, Program toProgram, MemoryBlock to, boolean truncateExisting) throws TraceConflictedMappingException {
        DefaultTraceLocation fromLoc = new DefaultTraceLocation(from.getTrace(), null, from.getModule().getLifespan(), from.getStart());
        ProgramLocation toLoc = new ProgramLocation(toProgram, to.getStart());
        long length = Math.min(from.getRange().getLength(), to.getSize());
        DebuggerStaticMappingUtils.addMapping((TraceLocation)fromLoc, toLoc, length, truncateExisting);
    }
}

