/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DebuggerBreakpointDialog
extends DialogComponentProvider {
    protected DebuggerObjectsProvider provider;
    protected TargetBreakpointSpecContainer container;
    protected JTextField expressionField;
    protected JButton addButton;

    public DebuggerBreakpointDialog(DebuggerObjectsProvider provider) {
        super("Set Breakpoint", true, true, true, false);
        this.provider = provider;
        this.populateComponents();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel centerPanel = new JPanel(new FlowLayout(1));
        panel.add((Component)centerPanel, "Center");
        JPanel pairPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        centerPanel.add(pairPanel);
        JLabel expressionLabel = new JLabel("Expression");
        pairPanel.add(expressionLabel);
        this.expressionField = new JTextField();
        pairPanel.add(this.expressionField);
        this.addWorkPanel(panel);
        this.addButton = new JButton();
        DebuggerResources.AbstractSetBreakpointAction.styleButton(this.addButton);
        this.addButton(this.addButton);
        this.addCancelButton();
        this.addButton.addActionListener(this::addBreakpoint);
    }

    protected void addBreakpoint(ActionEvent evt) {
        String expression = this.expressionField.getText();
        this.setStatusText("Adding");
        HashSet<TargetBreakpointSpec.TargetBreakpointKind> kinds = new HashSet<TargetBreakpointSpec.TargetBreakpointKind>();
        kinds.add(TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE);
        this.container.placeBreakpoint(expression, kinds).exceptionally(e -> {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Could not set breakpoint", (Object)e);
            this.setStatusText("Could not set breakpoint: " + e.getMessage(), MessageType.ERROR);
            return null;
        });
        this.close();
    }

    public void setContainer(TargetBreakpointSpecContainer container) {
        this.container = container;
    }
}

