/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.widgets.table.CellEditorUtils;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableFilterPanel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.modules.AbstractDebuggerMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Swing;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DebuggerSectionMapProposalDialog
extends AbstractDebuggerMapProposalDialog<DebuggerStaticMappingService.SectionMapEntry> {
    static final int BUTTON_SIZE = 32;
    private final DebuggerModulesProvider provider;

    public DebuggerSectionMapProposalDialog(DebuggerModulesProvider provider) {
        super("Map Sections");
        this.provider = provider;
    }

    protected SectionMapPropsalTableModel createTableModel() {
        return new SectionMapPropsalTableModel();
    }

    @Override
    protected void populateComponents() {
        super.populateComponents();
        this.setPreferredSize(600, 300);
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn removeCol = columnModel.getColumn(SectionMapTableColumns.REMOVE.ordinal());
        CellEditorUtils.installButton((JTable)this.table, (GTableFilterPanel)this.filterPanel, (TableColumn)removeCol, (Icon)DebuggerResources.ICON_DELETE, (int)32, this::removeEntry);
        TableColumn dynBaseCol = columnModel.getColumn(SectionMapTableColumns.DYNAMIC_BASE.ordinal());
        dynBaseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn chooseCol = columnModel.getColumn(SectionMapTableColumns.CHOOSE.ordinal());
        CellEditorUtils.installButton((JTable)this.table, (GTableFilterPanel)this.filterPanel, (TableColumn)chooseCol, (Icon)DebuggerResources.ICON_PROGRAM, (int)32, this::chooseAndSetBlock);
        TableColumn stBaseCol = columnModel.getColumn(SectionMapTableColumns.STATIC_BASE.ordinal());
        stBaseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn sizeCol = columnModel.getColumn(SectionMapTableColumns.SIZE.ordinal());
        sizeCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
    }

    private void chooseAndSetBlock(DebuggerStaticMappingService.SectionMapEntry entry) {
        Map.Entry<Program, MemoryBlock> choice = this.provider.askBlock(entry.getSection(), entry.getProgram(), entry.getBlock());
        if (choice == null) {
            return;
        }
        Swing.runIfSwingOrRunLater(() -> {
            entry.setBlock((Program)choice.getKey(), (MemoryBlock)choice.getValue());
            this.tableModel.notifyUpdated((Object)entry);
        });
    }

    protected static class SectionMapPropsalTableModel
    extends DefaultEnumeratedColumnTableModel<SectionMapTableColumns, DebuggerStaticMappingService.SectionMapEntry> {
        public SectionMapPropsalTableModel() {
            super("Section Map", SectionMapTableColumns.class);
        }

        public List<SectionMapTableColumns> defaultSortOrder() {
            return List.of(SectionMapTableColumns.MODULE_NAME, SectionMapTableColumns.SECTION_NAME);
        }
    }

    protected static enum SectionMapTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<SectionMapTableColumns, DebuggerStaticMappingService.SectionMapEntry>
    {
        REMOVE("Remove", String.class, e -> "Remove Proposed Entry", (e, v) -> SectionMapTableColumns.nop()),
        MODULE_NAME("Module", String.class, e -> e.getModule().getName()),
        SECTION_NAME("Section", String.class, e -> e.getSection().getName()),
        DYNAMIC_BASE("Dynamic Base", Address.class, e -> e.getSection().getStart()),
        CHOOSE("Choose", String.class, e -> "Choose Block", (e, s) -> SectionMapTableColumns.nop()),
        PROGRAM_NAME("Program", String.class, e -> e.getProgram().getName()),
        BLOCK_NAME("Block", String.class, e -> e.getBlock().getName()),
        STATIC_BASE("Static Base", Address.class, e -> e.getBlock().getStart()),
        SIZE("Size", Long.class, e -> e.getLength());

        private final String header;
        private final Class<?> cls;
        private final Function<DebuggerStaticMappingService.SectionMapEntry, ?> getter;
        private final BiConsumer<DebuggerStaticMappingService.SectionMapEntry, Object> setter;

        private static void nop() {
        }

        private <T> SectionMapTableColumns(String header, Class<T> cls, Function<DebuggerStaticMappingService.SectionMapEntry, T> getter, BiConsumer<DebuggerStaticMappingService.SectionMapEntry, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> SectionMapTableColumns(String header, Class<T> cls, Function<DebuggerStaticMappingService.SectionMapEntry, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(DebuggerStaticMappingService.SectionMapEntry row) {
            return this.getter.apply(row);
        }

        public boolean isEditable(DebuggerStaticMappingService.SectionMapEntry row) {
            return this.setter != null;
        }

        public void setValueOf(DebuggerStaticMappingService.SectionMapEntry row, Object value) {
            this.setter.accept(row, value);
        }
    }
}

