/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class ClangTokenGroup
implements ClangNode,
Iterable<ClangNode> {
    private ClangNode parent;
    Address minaddress;
    Address maxaddress;
    private ArrayList<ClangNode> tokgroup;

    public ClangTokenGroup(ClangNode par) {
        this.parent = par;
        this.tokgroup = new ArrayList();
        this.minaddress = null;
        this.maxaddress = null;
    }

    @Override
    public Address getMinAddress() {
        return this.minaddress;
    }

    @Override
    public Address getMaxAddress() {
        return this.maxaddress;
    }

    public void AddTokenGroup(Object obj) {
        Address minaddr = ((ClangNode)obj).getMinAddress();
        Address maxaddr = ((ClangNode)obj).getMaxAddress();
        if (minaddr != null) {
            if (this.minaddress == null) {
                this.minaddress = minaddr;
            } else if (minaddr.compareTo((Object)this.minaddress) < 0) {
                this.minaddress = minaddr;
            }
        }
        if (maxaddr != null) {
            if (this.maxaddress == null) {
                this.maxaddress = maxaddr;
            } else if (this.maxaddress.compareTo((Object)maxaddr) < 0) {
                this.maxaddress = maxaddr;
            }
        }
        this.tokgroup.add((ClangNode)obj);
    }

    @Override
    public ClangNode Parent() {
        return this.parent;
    }

    @Override
    public int numChildren() {
        return this.tokgroup.size();
    }

    @Override
    public ClangNode Child(int i) {
        return this.tokgroup.get(i);
    }

    @Override
    public ClangFunction getClangFunction() {
        return this.parent.getClangFunction();
    }

    @Override
    public void setHighlight(Color val) {
        for (ClangNode element : this.tokgroup) {
            element.setHighlight(val);
        }
    }

    @Override
    public void flatten(List<ClangNode> list) {
        for (ClangNode element : this.tokgroup) {
            element.flatten(list);
        }
    }

    public void restoreFromXML(XmlPullParser parser, PcodeFactory pfactory) {
        XmlElement node = parser.start(new String[]{"function", "return_type", "vardecl", "statement", "funcproto", "block", "variable", "op", "syntax", "break", "funcname", "type", "comment", "label"});
        while (parser.peek().isStart()) {
            ClangTokenGroup child;
            XmlElement elem = parser.peek();
            if (elem.getName().equals("return_type")) {
                child = new ClangReturnType(this);
                ((ClangReturnType)child).restoreFromXML(parser, pfactory);
                this.AddTokenGroup(child);
                continue;
            }
            if (elem.getName().equals("vardecl")) {
                child = new ClangVariableDecl(this);
                ((ClangVariableDecl)child).restoreFromXML(parser, pfactory);
                this.AddTokenGroup(child);
                continue;
            }
            if (elem.getName().equals("statement")) {
                child = new ClangStatement(this);
                ((ClangStatement)child).restoreFromXML(parser, pfactory);
                this.AddTokenGroup(child);
                continue;
            }
            if (elem.getName().equals("funcproto")) {
                child = new ClangFuncProto(this);
                child.restoreFromXML(parser, pfactory);
                this.AddTokenGroup(child);
                continue;
            }
            if (elem.getName().equals("block")) {
                child = new ClangTokenGroup(this);
                child.restoreFromXML(parser, pfactory);
                this.AddTokenGroup(child);
                continue;
            }
            ClangToken tok = ClangToken.buildToken(this, parser, pfactory);
            this.AddTokenGroup(tok);
        }
        parser.end(node);
    }

    private boolean isLetterDigitOrUnderscore(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public String toString() {
        String lastTokenStr = null;
        StringBuffer buffer = new StringBuffer();
        for (ClangNode node : this.tokgroup) {
            String tokenStr = node.toString();
            if (tokenStr.length() == 0) continue;
            if (lastTokenStr != null && this.isLetterDigitOrUnderscore(tokenStr.charAt(0)) && this.isLetterDigitOrUnderscore(lastTokenStr.charAt(lastTokenStr.length() - 1))) {
                buffer.append(' ');
            }
            lastTokenStr = tokenStr;
            buffer.append(tokenStr);
        }
        return buffer.toString();
    }

    @Override
    public Iterator<ClangNode> iterator() {
        return this.tokgroup.iterator();
    }

    public Stream<ClangNode> stream() {
        return this.tokgroup.stream();
    }
}

