/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbThreadExitedEvent;
import agent.gdb.manager.evt.GdbThreadGroupExitedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;

public class GdbKillCommand
extends AbstractGdbCommandWithThreadId<Void> {
    public GdbKillCommand(GdbManagerImpl manager, Integer threadId) {
        super(manager, threadId);
    }

    @Override
    public String encode(String threadPart) {
        return "-interpreter-exec" + threadPart + " console kill";
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbThreadExitedEvent) {
            pending.claim(evt);
        } else if (evt instanceof GdbThreadGroupExitedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        return null;
    }
}

