/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial.rtree;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jungrapht.visualization.spatial.rtree.Bounded;
import org.jungrapht.visualization.spatial.rtree.LeafNode;
import org.jungrapht.visualization.spatial.rtree.SplitterContext;
import org.jungrapht.visualization.spatial.rtree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Node<T>
extends TreeNode,
Bounded {
    public static final Logger log = LoggerFactory.getLogger(Node.class);
    public static final int M = 10;
    public static final int m = 4;
    public static final String marginIncrement = "   ";

    public String asString(String var1);

    public T getPickedObject(Point2D var1);

    public int size();

    public void setParent(Node<T> var1);

    public Optional<Node<T>> getParent();

    public Node<T> add(SplitterContext<T> var1, T var2, Rectangle2D var3);

    public boolean isLeafChildren();

    public int count();

    public Point2D centerOfGravity();

    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> var1, double var2, double var4);

    public Set<LeafNode<T>> getContainingLeafs(Set<LeafNode<T>> var1, Point2D var2);

    public LeafNode<T> getContainingLeaf(T var1);

    public Node<T> remove(T var1);

    public Node<T> recalculateBounds();

    public Collection<Shape> collectGrids(Collection<Shape> var1);

    public Set<T> getVisibleElements(Set<T> var1, Shape var2);

    public static String asString(List<Shape> rectangles) {
        StringBuilder sb = new StringBuilder();
        for (Shape r : rectangles) {
            sb.append(Node.asString(r.getBounds()));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String asString(Rectangle2D r) {
        return "[" + (int)r.getX() + "," + (int)r.getY() + "," + (int)r.getWidth() + "," + (int)r.getHeight() + "]";
    }

    public static <T> String asString(Map.Entry<T, Rectangle2D> entry) {
        return entry.getKey() + "->" + Node.asString(entry.getValue());
    }

    public static <T> String asString(Node<T> node, String margin) {
        String s = margin + "bounds=" + Node.asString(node.getBounds()) + "\n" + node.asString(margin + marginIncrement);
        return s;
    }

    public static <T> Rectangle2D entryBoundingBox(Collection<Map.Entry<T, Rectangle2D>> entries) {
        Rectangle2D boundingBox = null;
        for (Map.Entry<T, Rectangle2D> entry : entries) {
            Rectangle2D rectangle = entry.getValue();
            if (boundingBox == null) {
                boundingBox = rectangle;
                continue;
            }
            boundingBox = boundingBox.createUnion(rectangle);
        }
        return boundingBox;
    }

    public static <T> Rectangle2D nodeBoundingBox(Collection<Node<T>> nodes) {
        Rectangle2D boundingBox = null;
        for (Node<T> node : nodes) {
            Rectangle2D rectangle = node.getBounds();
            if (boundingBox == null) {
                boundingBox = rectangle;
                continue;
            }
            boundingBox = boundingBox.createUnion(rectangle);
        }
        return boundingBox;
    }

    public static Rectangle2D boundingBox(Collection<Rectangle2D> rectangles) {
        Rectangle2D boundingBox = null;
        for (Rectangle2D rectangle : rectangles) {
            if (boundingBox == null) {
                boundingBox = rectangle;
                continue;
            }
            boundingBox = boundingBox.createUnion(rectangle);
        }
        return boundingBox;
    }

    public static double area(Collection<Rectangle2D> rectangles) {
        return Node.area(Node.boundingBox(rectangles));
    }

    public static <T> double nodeArea(Collection<Node<T>> nodes) {
        return Node.area(Node.nodeBoundingBox(nodes));
    }

    public static <T> double entryArea(Collection<Map.Entry<T, Rectangle2D>> entries) {
        return Node.area(Node.entryBoundingBox(entries));
    }

    public static <T> double entryArea(Collection<Map.Entry<T, Rectangle2D>> left, Collection<Map.Entry<T, Rectangle2D>> right) {
        return Node.entryArea(left) + Node.entryArea(right);
    }

    public static <T> double nodeArea(Collection<Node<T>> left, Collection<Node<T>> right) {
        return Node.nodeArea(left) + Node.nodeArea(right);
    }

    public static double area(Collection<Rectangle2D> left, Collection<Rectangle2D> right) {
        return Node.area(left) + Node.area(right);
    }

    public static double area(Rectangle2D r) {
        double area = r.getWidth() * r.getHeight();
        return area < 0.0 ? -area : area;
    }

    public static double area(Rectangle2D left, Rectangle2D right) {
        return Node.area(left) + Node.area(right);
    }

    public static double margin(Collection<Rectangle2D> rectangles) {
        return Node.margin(Node.boundingBox(rectangles));
    }

    public static double margin(Rectangle2D r) {
        double width = r.getMaxX() - r.getMinX();
        double height = r.getMaxY() - r.getMinY();
        return 2.0 * (width + height);
    }

    public static double margin(Rectangle2D left, Rectangle2D right) {
        return Node.margin(left) + Node.margin(right);
    }

    public static double margin(Collection<Rectangle2D> left, Collection<Rectangle2D> right) {
        return Node.margin(left) + Node.margin(right);
    }

    public static <T> double nodeMargin(Collection<Node<T>> left, Collection<Node<T>> right) {
        return Node.margin(Node.nodeBoundingBox(left)) + Node.margin(Node.nodeBoundingBox(right));
    }

    public static <T> double entryMargin(Collection<Map.Entry<T, Rectangle2D>> left, Collection<Map.Entry<T, Rectangle2D>> right) {
        return Node.margin(Node.entryBoundingBox(left)) + Node.margin(Node.entryBoundingBox(right));
    }

    public static <T> double entryOverlap(Collection<Map.Entry<T, Rectangle2D>> left, Collection<Map.Entry<T, Rectangle2D>> right) {
        return Node.overlap(Node.entryBoundingBox(left), Node.entryBoundingBox(right));
    }

    public static <T> double nodeOverlap(Collection<Node<T>> left, Collection<Node<T>> right) {
        return Node.overlap(Node.nodeBoundingBox(left), Node.nodeBoundingBox(right));
    }

    public static double overlap(Collection<Rectangle2D> left, Collection<Rectangle2D> right) {
        return Node.overlap(Node.boundingBox(left), Node.boundingBox(right));
    }

    public static double overlap(Rectangle2D left, Rectangle2D right) {
        return Node.area(left.createIntersection(right));
    }

    public static Rectangle2D union(Collection<? extends Bounded> boundedItems) {
        Rectangle2D union = null;
        for (Bounded bounded : boundedItems) {
            if (union == null) {
                union = bounded.getBounds();
                continue;
            }
            union = bounded.getBounds().createUnion(union);
        }
        return union;
    }

    public static double width(Collection<? extends Bounded> boundedItems) {
        double min = 600.0;
        double max = 0.0;
        for (Bounded bounded : boundedItems) {
            min = Math.min(bounded.getBounds().getMinX(), min);
            max = Math.max(bounded.getBounds().getMaxX(), max);
        }
        return max - min;
    }
}

