/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.renderers.HeavyweightEdgeRenderer;
import org.jungrapht.visualization.renderers.HeavyweightVertexLabelRenderer;
import org.jungrapht.visualization.renderers.HeavyweightVertexRenderer;
import org.jungrapht.visualization.renderers.HeayweightEdgeLabelRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.spatial.Spatial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeavyweightRenderer<V, E>
implements Renderer<V, E> {
    private static final Logger log = LoggerFactory.getLogger(HeavyweightRenderer.class);
    protected Renderer.Vertex<V, E> vertexRenderer = new HeavyweightVertexRenderer();
    protected Renderer.VertexLabel<V, E> vertexLabelRenderer = new HeavyweightVertexLabelRenderer();
    protected Renderer.Edge<V, E> edgeRenderer = new HeavyweightEdgeRenderer();
    protected Renderer.EdgeLabel<V, E> edgeLabelRenderer = new HeayweightEdgeLabelRenderer();

    HeavyweightRenderer() {
    }

    @Override
    public void render(RenderContext<V, E> renderContext, LayoutModel<V> visualizationModel, Spatial<V, V> vertexSpatial, Spatial<E, V> edgeSpatial) {
    }

    @Override
    public void render(RenderContext<V, E> renderContext, LayoutModel<V> visualizationModel) {
    }

    @Override
    public void renderVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        this.vertexRenderer.paintVertex(renderContext, layoutModel, v);
    }

    @Override
    public void renderVertexLabel(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        this.vertexLabelRenderer.labelVertex(renderContext, layoutModel, v, renderContext.getVertexLabelFunction().apply(v));
    }

    @Override
    public void renderEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        this.edgeRenderer.paintEdge(renderContext, layoutModel, e);
    }

    @Override
    public void renderEdgeLabel(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        this.edgeLabelRenderer.labelEdge(renderContext, layoutModel, e, renderContext.getEdgeLabelFunction().apply(e));
    }

    @Override
    public void setVertexRenderer(Renderer.Vertex<V, E> r) {
        this.vertexRenderer = r;
    }

    @Override
    public void setEdgeRenderer(Renderer.Edge<V, E> r) {
        this.edgeRenderer = r;
    }

    @Override
    public Renderer.EdgeLabel<V, E> getEdgeLabelRenderer() {
        return this.edgeLabelRenderer;
    }

    @Override
    public void setEdgeLabelRenderer(Renderer.EdgeLabel<V, E> edgeLabelRenderer) {
        this.edgeLabelRenderer = edgeLabelRenderer;
    }

    @Override
    public Renderer.VertexLabel<V, E> getVertexLabelRenderer() {
        return this.vertexLabelRenderer;
    }

    @Override
    public void setVertexLabelRenderer(Renderer.VertexLabel<V, E> vertexLabelRenderer) {
        this.vertexLabelRenderer = vertexLabelRenderer;
    }

    @Override
    public Renderer.Edge<V, E> getEdgeRenderer() {
        return this.edgeRenderer;
    }

    @Override
    public Renderer.Vertex<V, E> getVertexRenderer() {
        return this.vertexRenderer;
    }
}

