/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge;

import edu.uci.ics.jung.visualization.RenderContext;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class VisualEdgeArrowRenderingSupport<V extends VisualVertex, E extends VisualEdge<V>> {
    public AffineTransform createArrowTransform(RenderContext<V, E> rc, Shape edgeShape, Shape vertexShape) {
        return this.doCreateArrowTransform(rc.getArrowPlacementTolerance(), edgeShape, vertexShape);
    }

    AffineTransform doCreateArrowTransform(double arrowPlacementTolerance, Shape edgeShape, Shape vertexShape) {
        GeneralPath path = new GeneralPath(edgeShape);
        double[] seg = new double[6];
        Point2D.Double p1 = null;
        Point2D.Double p2 = null;
        AffineTransform at = new AffineTransform();
        PathIterator i = path.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int type = i.currentSegment(seg);
            if (type == 0) {
                p2 = new Point2D.Double(seg[0], seg[1]);
            } else if (type == 1) {
                p1 = p2;
                p2 = new Point2D.Double(seg[0], seg[1]);
                if (vertexShape.contains(p2)) {
                    Line2D.Double lineSegment = new Line2D.Double(p1, p2);
                    Line2D line = this.findClosestLineSegment(arrowPlacementTolerance, lineSegment, vertexShape);
                    return this.createArrowTransformFromLine(line);
                }
            }
            i.next();
        }
        return at;
    }

    Line2D findClosestLineSegment(double arrowPlacementTolerance, Line2D line, Shape vertexShape) {
        if (!vertexShape.contains(line.getP2())) {
            String errorString = "line end point: " + line.getP2() + " is not contained in shape: " + vertexShape.getBounds2D();
            throw new IllegalArgumentException(errorString);
        }
        Line2D.Double left = new Line2D.Double();
        Line2D.Double right = new Line2D.Double();
        int iterations = 0;
        while (this.lengthSquared(line) > arrowPlacementTolerance && iterations++ < 15) {
            this.bisect(line, left, right);
            line = vertexShape.contains(((Line2D)right).getP1()) ? left : right;
        }
        return line;
    }

    private double lengthSquared(Line2D line) {
        double dx = line.getX1() - line.getX2();
        double dy = line.getY1() - line.getY2();
        return dx * dx + dy * dy;
    }

    private void bisect(Line2D src, Line2D left, Line2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double mx = x1 + (x2 - x1) / 2.0;
        double my = y1 + (y2 - y1) / 2.0;
        left.setLine(x1, y1, mx, my);
        right.setLine(mx, my, x2, y2);
    }

    private AffineTransform createArrowTransformFromLine(Line2D line) {
        double x1 = line.getX1();
        double y1 = line.getY1();
        double dx = x1 - line.getX2();
        double dy = y1 - line.getY2();
        double atheta = Math.atan2(dx, dy) + 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.rotate(-atheta);
        return at;
    }
}

