/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb;

import ghidra.app.util.SymbolPath;
import ghidra.program.model.symbol.SymbolUtilities;
import java.util.ArrayList;

public class PdbNamespaceUtils {
    public static SymbolPath convertToGhidraPathName(SymbolPath symbolPath, int index) {
        symbolPath = symbolPath.replaceInvalidChars();
        return new SymbolPath(symbolPath.getParent(), PdbNamespaceUtils.fixUnnamed(symbolPath.getName(), index));
    }

    public static SymbolPath convertToGhidraPathName(SymbolPath symbolPath) {
        symbolPath = symbolPath.replaceInvalidChars();
        return symbolPath;
    }

    public static SymbolPath convertToGhidraPath(SymbolPath symbolPath, int index) {
        symbolPath = symbolPath.replaceInvalidChars();
        ArrayList<String> modList = new ArrayList<String>();
        for (String str : symbolPath.asList()) {
            modList.add(SymbolUtilities.replaceInvalidChars((String)PdbNamespaceUtils.fixUnnamed(str, index), (boolean)true));
        }
        return new SymbolPath(modList);
    }

    public static String fixUnnamed(String name, int index) {
        if ("<unnamed-tag>".equals(name)) {
            return String.format("<unnamed-tag_%08X>", index);
        }
        if ("<anonymous-tag>".equals(name)) {
            return String.format("<anonymous-tag_%08X>", index);
        }
        if ("<unnamed-type>".equals(name)) {
            return String.format("<unnamed-type_%08X>", index);
        }
        return name;
    }
}

