/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Pdb200;
import ghidra.app.util.bin.format.pdb2.pdbreader.Pdb400;
import ghidra.app.util.bin.format.pdb2.pdbreader.Pdb700;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfParser;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Objects;

public class PdbParser {
    public static final int VC2_ID = 19941610;
    public static final int VC4_ID = 19950623;
    public static final int VC41_ID = 19950814;
    public static final int VC50_ID = 19960307;
    public static final int VC98_ID = 19970604;
    public static final int VC70DEP_ID = 19990604;
    public static final int VC70_ID = 20000404;
    public static final int VC80_ID = 20030901;
    public static final int VC110_ID = 20091201;
    public static final int VC140_ID = 20140508;

    public static AbstractPdb parse(String filename, PdbReaderOptions pdbOptions, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        AbstractPdb pdb;
        Objects.requireNonNull(filename, "filename cannot be null");
        Objects.requireNonNull(pdbOptions, "pdbOptions cannot be null");
        Objects.requireNonNull(monitor, "monitor cannot be null");
        AbstractMsf msf = MsfParser.parse(filename, pdbOptions, monitor);
        int versionNumber = AbstractPdb.deserializeVersionNumber(msf, monitor);
        switch (versionNumber) {
            case 19941610: {
                pdb = new Pdb200(msf, pdbOptions);
                break;
            }
            case 19950623: 
            case 19950814: 
            case 19960307: 
            case 19970604: 
            case 19990604: {
                pdb = new Pdb400(msf, pdbOptions);
                break;
            }
            case 20000404: 
            case 20030901: 
            case 20091201: 
            case 20140508: {
                pdb = new Pdb700(msf, pdbOptions);
                break;
            }
            default: {
                msf.close();
                throw new PdbException("Unknown PDB Version: " + versionNumber);
            }
        }
        pdb.deserializeIdentifiersOnly(monitor);
        return pdb;
    }
}

