/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetModelRoot;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.manager.JdiManager;
import ghidra.dbg.jdi.model.JdiModelImpl;
import ghidra.dbg.jdi.model.JdiModelTargetAttributesContainer;
import ghidra.dbg.jdi.model.JdiModelTargetConnector;
import ghidra.dbg.jdi.model.JdiModelTargetConnectorContainer;
import ghidra.dbg.jdi.model.JdiModelTargetStackFrame;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.jdi.model.JdiModelTargetVMContainer;
import ghidra.dbg.jdi.model.iface1.JdiModelSelectableObject;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetAccessConditioned;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetEventScope;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetFocusScope;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetInterruptible;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetLauncher;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Debugger", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=JdiModelTargetAttributesContainer.class, required=true, fixed=true), @TargetAttributeType(name="Connectors", type=JdiModelTargetConnectorContainer.class, required=true, fixed=true), @TargetAttributeType(name="VirtualMachines", type=JdiModelTargetVMContainer.class, required=true, fixed=true), @TargetAttributeType(type=Void.class)})
public class JdiModelTargetRoot
extends DefaultTargetModelRoot
implements JdiModelTargetAccessConditioned,
JdiModelTargetFocusScope,
JdiModelTargetInterruptible,
JdiModelTargetLauncher,
JdiModelTargetEventScope,
JdiEventsListenerAdapter {
    protected static final String JDB_PROMPT = ">";
    protected final JdiModelImpl impl;
    protected String display = "JDI";
    protected final VirtualMachineManager vmm;
    protected final JdiModelTargetVMContainer vms;
    protected final JdiModelTargetConnectorContainer connectors;
    protected JdiModelTargetAttributesContainer addedAttributes;
    private boolean accessible = true;
    protected JdiModelSelectableObject focus;
    protected String debugger = "Jdi";

    public JdiModelTargetRoot(JdiModelImpl impl, TargetObjectSchema schema) {
        super((AbstractDebuggerObjectModel)impl, "VirtualMachineManager", schema);
        this.impl = impl;
        this.vmm = this.impl.getManager().getVirtualMachineManager();
        this.vms = new JdiModelTargetVMContainer(this);
        this.connectors = new JdiModelTargetConnectorContainer(this);
        this.populateAttributes();
        this.changeAttributes(List.of(), List.of(this.vms, this.connectors, this.addedAttributes), Map.of("_accessible", this.accessible, "_display", this.display, "_parameters", TargetLauncher.TargetCmdLineLauncher.PARAMETERS), "Initialized");
        impl.getManager().addEventsListener(null, this);
    }

    @Override
    public JdiModelImpl getModelImpl() {
        return this.impl;
    }

    private void populateAttributes() {
        this.addedAttributes = new JdiModelTargetAttributesContainer(this, "Attributes");
        HashMap<String, Integer> attrs = new HashMap<String, Integer>();
        attrs.put("Major Version", this.vmm.majorInterfaceVersion());
        attrs.put("Minor Version", this.vmm.minorInterfaceVersion());
        this.addedAttributes.addAttributes(attrs);
    }

    public String getDisplay() {
        return this.display;
    }

    @Override
    public void vmSelected(VirtualMachine vm, JdiCause cause) {
        if (vm.allThreads().isEmpty()) {
            JdiModelTargetVM targetVM = this.vms.getTargetVM(vm);
            this.setFocus(targetVM);
        }
    }

    @Override
    public void threadSelected(ThreadReference thread, StackFrame frame, JdiCause cause) {
        JdiModelTargetVM vm = this.vms.getTargetVM(thread.threadGroup().virtualMachine());
        JdiModelTargetThread t = vm.threads.getTargetThread(thread);
        if (frame == null) {
            this.setFocus(t);
            return;
        }
        JdiModelTargetStackFrame f = t.stack.getTargetFrame(frame);
        this.setFocus(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessible(boolean accessible) {
        Map map = this.attributes;
        synchronized (map) {
            if (this.accessible == accessible) {
                return;
            }
            this.accessible = accessible;
            this.changeAttributes(List.of(), List.of(), Map.of("_accessible", accessible), "Accessibility changed");
        }
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    public CompletableFuture<Void> launch(Map<String, ?> args) {
        JdiManager manager = this.impl.getManager();
        JdiModelTargetConnector targetConnector = this.connectors.getDefaultConnector();
        Connector cx = targetConnector != null ? targetConnector.cx : manager.getVirtualMachineManager().defaultConnector();
        Map<String, Connector.Argument> defaultArguments = cx.defaultArguments();
        Map<String, Connector.Argument> jdiArgs = JdiModelTargetLauncher.getArguments(defaultArguments, JdiModelTargetLauncher.getParameters(defaultArguments), args);
        return this.getManager().addVM(cx, jdiArgs).thenApply(__ -> null);
    }

    public TargetMethod.TargetParameterMap getParameters() {
        JdiManager manager = this.impl.getManager();
        JdiModelTargetConnector targetConnector = this.connectors.getDefaultConnector();
        Connector cx = targetConnector != null ? targetConnector.cx : manager.getVirtualMachineManager().defaultConnector();
        Map<String, Connector.Argument> defaultArguments = cx.defaultArguments();
        return TargetMethod.TargetParameterMap.copyOf(JdiModelTargetLauncher.getParameters(defaultArguments));
    }

    public CompletableFuture<Void> attach(long pid) {
        JdiManager manager = this.impl.getManager();
        JdiModelTargetConnector targetConnector = this.connectors.getTargetConnectorIfPresent("SocketAttach");
        if (targetConnector == null) {
            Msg.error((Object)this, (Object)"No match found in connectors for SocketAttach");
        } else {
            Connector cx = targetConnector.cx;
            manager.addVM(cx, List.of(Long.toString(pid)));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> interrupt() {
        try {
            this.impl.getManager().sendInterruptNow();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Could not interrupt", (Throwable)e);
        }
        return AsyncUtils.NIL;
    }

    protected void invalidateMemoryAndRegisterCaches() {
        this.vms.invalidateMemoryAndRegisterCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(JdiModelSelectableObject sel) {
        boolean doFire;
        JdiModelTargetRoot jdiModelTargetRoot = this;
        synchronized (jdiModelTargetRoot) {
            doFire = !Objects.equals(this.focus, sel);
            this.focus = sel;
        }
        if (doFire) {
            this.changeAttributes(List.of(), List.of(), Map.of("_focus", this.focus), "Focus changed");
            return true;
        }
        return false;
    }

    @Override
    public JdiModelSelectableObject getFocus() {
        return this.focus;
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public JdiModelTargetObject getTargetObject(Object object) {
        return null;
    }
}

