/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.RenderContext;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class BoundingRectangleCollector<V, E> {
    protected RenderContext<V, E> rc;
    protected Graph<V, E> graph;
    protected Layout<V, E> layout;
    protected List<Rectangle2D> rectangles = new ArrayList<Rectangle2D>();

    public BoundingRectangleCollector(RenderContext<V, E> rc, Layout<V, E> layout) {
        this.rc = rc;
        this.layout = layout;
        this.graph = layout.getGraph();
        this.compute();
    }

    public List<Rectangle2D> getRectangles() {
        return this.rectangles;
    }

    public void compute() {
        this.rectangles.clear();
        for (Object e : this.graph.getEdges()) {
            Pair<V> endpoints = this.graph.getEndpoints(e);
            V v1 = endpoints.getFirst();
            V v2 = endpoints.getSecond();
            Point2D p1 = (Point2D)this.layout.apply(v1);
            Point2D p2 = (Point2D)this.layout.apply(v2);
            float x1 = (float)p1.getX();
            float y1 = (float)p1.getY();
            float x2 = (float)p2.getX();
            float y2 = (float)p2.getY();
            boolean isLoop = v1.equals(v2);
            Shape s2 = (Shape)this.rc.getVertexShapeTransformer().apply(v2);
            Shape edgeShape = (Shape)this.rc.getEdgeShapeTransformer().apply(e);
            AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
            if (isLoop) {
                Rectangle2D s2Bounds = s2.getBounds2D();
                xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
                xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
            } else {
                float dx = x2 - x1;
                float dy = y2 - y1;
                float theta = (float)Math.atan2(dy, dx);
                xform.rotate(theta);
                float dist = (float)p1.distance(p2);
                xform.scale(dist, 1.0);
            }
            edgeShape = xform.createTransformedShape(edgeShape);
            this.rectangles.add(edgeShape.getBounds2D());
        }
        for (Object v : this.graph.getVertices()) {
            Shape shape = (Shape)this.rc.getVertexShapeTransformer().apply(v);
            Point2D p = (Point2D)this.layout.apply(v);
            float x = (float)p.getX();
            float y = (float)p.getY();
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            shape = xform.createTransformedShape(shape);
            this.rectangles.add(shape.getBounds2D());
        }
    }
}

