/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.plugintool.ToolEventName;

public abstract class PluginEvent {
    public static final String EXTERNAL_SOURCE_NAME = "External Tool";
    private String eventName;
    private String sourceName;
    private PluginEvent triggerEvent;

    public static String lookupToolEventName(Class<?> pluginEventClass) {
        ToolEventName eventNameAnnotation = pluginEventClass.getAnnotation(ToolEventName.class);
        if (eventNameAnnotation != null) {
            return eventNameAnnotation.value();
        }
        return null;
    }

    protected PluginEvent(String sourceName, String eventName) {
        this.eventName = eventName;
        this.sourceName = sourceName;
    }

    public boolean isToolEvent() {
        return this.getToolEventName() != null;
    }

    public final String getToolEventName() {
        return PluginEvent.lookupToolEventName(this.getClass());
    }

    public final String getEventName() {
        return this.eventName;
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String s) {
        this.sourceName = s;
    }

    public void setTriggerEvent(PluginEvent triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    public PluginEvent getTriggerEvent() {
        return this.triggerEvent;
    }

    public String toString() {
        String details = this.getDetails();
        StringBuilder builder = new StringBuilder();
        builder.append("Event: ");
        builder.append(this.eventName);
        builder.append("  Source: ");
        builder.append(this.sourceName);
        if (details != null) {
            builder.append("\n\tDetails: ");
            builder.append(details);
        }
        return builder.toString();
    }

    protected String getDetails() {
        return null;
    }
}

