/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.model;

import ghidra.framework.data.CheckinHandler;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public interface DomainFile
extends Comparable<DomainFile> {
    public static final int DEFAULT_VERSION = -1;
    public static final String READ_ONLY_PROPERTY = "READ_ONLY";

    public String getName();

    public boolean exists();

    public String getFileID();

    public DomainFile setName(String var1) throws InvalidNameException, IOException;

    public String getPathname();

    public ProjectLocator getProjectLocator();

    public String getContentType();

    public Class<? extends DomainObject> getDomainObjectClass();

    public DomainFolder getParent();

    public ChangeSet getChangesByOthersSinceCheckout() throws VersionException, IOException;

    public DomainObject getDomainObject(Object var1, boolean var2, boolean var3, TaskMonitor var4) throws VersionException, IOException, CancelledException;

    public DomainObject getOpenedDomainObject(Object var1);

    public DomainObject getReadOnlyDomainObject(Object var1, int var2, TaskMonitor var3) throws VersionException, IOException, CancelledException;

    public DomainObject getImmutableDomainObject(Object var1, int var2, TaskMonitor var3) throws VersionException, IOException, CancelledException;

    public void save(TaskMonitor var1) throws IOException, CancelledException;

    public boolean canSave();

    public boolean canRecover();

    public boolean takeRecoverySnapshot() throws IOException;

    public boolean isInWritableProject();

    public long getLastModifiedTime();

    public Icon getIcon(boolean var1);

    public boolean isCheckedOut();

    public boolean isCheckedOutExclusive();

    public boolean modifiedSinceCheckout();

    public boolean canCheckout();

    public boolean canCheckin();

    public boolean canMerge();

    public boolean canAddToRepository();

    public void setReadOnly(boolean var1) throws IOException;

    public boolean isReadOnly();

    public boolean isVersionControlSupported();

    public boolean isVersioned();

    public boolean isHijacked();

    public int getLatestVersion();

    public boolean isLatestVersion();

    public int getVersion();

    public Version[] getVersionHistory() throws IOException;

    public void addToVersionControl(String var1, boolean var2, TaskMonitor var3) throws IOException, CancelledException;

    public boolean checkout(boolean var1, TaskMonitor var2) throws IOException, CancelledException;

    public void checkin(CheckinHandler var1, boolean var2, TaskMonitor var3) throws IOException, VersionException, CancelledException;

    public void merge(boolean var1, TaskMonitor var2) throws IOException, VersionException, CancelledException;

    public void undoCheckout(boolean var1) throws IOException;

    public void terminateCheckout(long var1) throws IOException;

    public ItemCheckoutStatus[] getCheckouts() throws IOException;

    public ItemCheckoutStatus getCheckoutStatus() throws IOException;

    public void delete() throws IOException;

    public void delete(int var1) throws IOException;

    public DomainFile moveTo(DomainFolder var1) throws IOException;

    public DomainFile copyTo(DomainFolder var1, TaskMonitor var2) throws IOException, CancelledException;

    public DomainFile copyVersionTo(int var1, DomainFolder var2, TaskMonitor var3) throws IOException, CancelledException;

    public List<?> getConsumers();

    public boolean isChanged();

    public boolean isOpen();

    public boolean isBusy();

    public void packFile(File var1, TaskMonitor var2) throws IOException, CancelledException;

    public Map<String, String> getMetadata();

    public long length() throws IOException;
}

