/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.OptionDialog;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.wizard.PanelManager;
import docking.wizard.WizardManager;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.ConvertFileSystem;
import ghidra.framework.main.FileActionManager;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.SetupProjectPanelManager;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.remote.User;
import ghidra.framework.store.local.IndexedLocalFileSystem;
import ghidra.framework.store.local.IndexedV1LocalFileSystem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.MangledLocalFileSystem;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import resources.ResourceManager;

public class ProjectInfoDialog
extends DialogComponentProvider {
    private static final Icon CONVERT_ICON = ResourceManager.loadImage((String)"images/wand.png");
    public static final String CHANGE = "Change Shared Project Info...";
    static final String CONVERT = "Convert to Shared...";
    private FrontEndPlugin plugin;
    private Project project;
    private RepositoryAdapter repository;
    private JButton connectionButton;
    private JLabel userAccessLabel;
    private JButton changeConvertButton;
    private JButton convertStorageButton;
    private JLabel projectDirLabel;
    private JLabel serverLabel;
    private JLabel portLabel;
    private JLabel repNameLabel;

    ProjectInfoDialog(FrontEndPlugin plugin) {
        super("Project Information", false, true, true, false);
        this.plugin = plugin;
        this.project = plugin.getActiveProject();
        this.repository = this.project.getRepository();
        this.addWorkPanel(this.buildMainPanel());
        this.addDismissButton();
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", this.repository != null ? "View_Project_Info" : "Convert_to_Shared"));
        this.setFocusComponent(this.dismissButton);
        this.setRememberSize(false);
    }

    void updateConnectionStatus() {
        boolean isConnected = this.repository.isConnected();
        this.connectionButton.setIcon(isConnected ? FrontEndPlugin.CONNECTED_ICON : FrontEndPlugin.DISCONNECTED_ICON);
        this.connectionButton.setContentAreaFilled(false);
        this.connectionButton.setSelected(isConnected);
        this.connectionButton.setBorder(isConnected ? BorderFactory.createBevelBorder(1) : BorderFactory.createBevelBorder(0));
        this.updateConnectButtonToolTip();
        if (isConnected) {
            try {
                User user = this.repository.getUser();
                this.userAccessLabel.setText(this.getAccessString(user));
            }
            catch (IOException e) {
                Msg.error((Object)((Object)this), (Object)"Exception obtaining user", (Throwable)e);
            }
        }
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel((LayoutManager)new VerticalLayout(20));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        mainPanel.add(this.buildInfoPanel());
        mainPanel.add(this.buildRepositoryInfoPanel());
        mainPanel.add(this.buildButtonPanel());
        return mainPanel;
    }

    private JPanel buildInfoPanel() {
        File dir = this.project.getProjectLocator().getProjectDir();
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.setBorder(BorderFactory.createTitledBorder("Project Location"));
        JPanel infoPanel = new JPanel((LayoutManager)new PairLayout(5, 10));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GLabel dirLabel = new GLabel("Directory Location:", 4);
        dirLabel.setToolTipText("Directory where your project files reside.");
        infoPanel.add((Component)dirLabel);
        this.projectDirLabel = new GDLabel(dir.getAbsolutePath());
        infoPanel.add(this.projectDirLabel);
        infoPanel.add((Component)new GLabel("Project Storage Type:", 4));
        Class<? extends LocalFileSystem> fsClass = this.project.getProjectData().getLocalStorageClass();
        String fsClassName = "<UNKNOWN>";
        if (IndexedV1LocalFileSystem.class.equals(fsClass)) {
            fsClassName = "Indexed Filesystem (V1)";
        } else if (IndexedLocalFileSystem.class.equals(fsClass)) {
            fsClassName = "Indexed Filesystem (V0)";
        } else if (MangledLocalFileSystem.class.equals(fsClass)) {
            fsClassName = "Mangled Filesystem";
        }
        GLabel label = new GLabel(fsClassName);
        label.setName("Project Storage Type");
        infoPanel.add((Component)label);
        infoPanel.add((Component)new GLabel("Project Name:", 4));
        label = new GLabel(this.project.getName());
        label.setName("Project Name");
        infoPanel.add((Component)label);
        outerPanel.add(infoPanel);
        return outerPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.changeConvertButton = new JButton(this.repository != null ? CHANGE : CONVERT);
        this.changeConvertButton.addActionListener(e -> {
            if (this.changeConvertButton.getText().equals(CONVERT)) {
                this.convertToShared();
            } else {
                this.updateSharedProjectInfo();
            }
        });
        HelpService help = Help.getHelpService();
        String tag = this.repository != null ? "Change_Shared_Project_Info" : "Convert_to_Shared";
        help.registerHelp((Object)this.changeConvertButton, new HelpLocation("FrontEndPlugin", tag));
        String toolTipForChange = "Change server information or specify another repository.";
        String toolTipForConvert = "Convert project to be a shared project.";
        this.changeConvertButton.setToolTipText(this.repository != null ? toolTipForChange : toolTipForConvert);
        Class<? extends LocalFileSystem> fsClass = this.project.getProjectData().getLocalStorageClass();
        String convertStorageButtonLabel = null;
        if (IndexedLocalFileSystem.class.equals(fsClass)) {
            convertStorageButtonLabel = "Upgrade Project Storage Index...";
        } else if (MangledLocalFileSystem.class.equals(fsClass)) {
            convertStorageButtonLabel = "Convert Project Storage to Indexed...";
        }
        if (convertStorageButtonLabel != null) {
            this.convertStorageButton = new JButton(convertStorageButtonLabel);
            this.convertStorageButton.addActionListener(e -> this.convertToIndexedFilesystem());
            help.registerHelp((Object)this.changeConvertButton, new HelpLocation("FrontEndPlugin", "Convert_Project_Storage"));
            this.convertStorageButton.setToolTipText("Convert/Upgrade project storage to latest Indexed Filesystem");
        }
        JPanel p = new JPanel(new FlowLayout());
        p.add(this.changeConvertButton);
        if (this.convertStorageButton != null) {
            p.add(this.convertStorageButton);
        }
        buttonPanel.add(p);
        return buttonPanel;
    }

    private JPanel buildRepositoryInfoPanel() {
        String serverName = "";
        ServerInfo info = null;
        String repositoryName = "";
        String portNumberStr = "";
        boolean isConnected = false;
        if (this.repository != null) {
            info = this.repository.getServerInfo();
            serverName = info.getServerName();
            repositoryName = this.repository.getName();
            portNumberStr = Integer.toString(info.getPortNumber());
            isConnected = this.repository.isConnected();
        }
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.setBorder(BorderFactory.createTitledBorder("Repository Info"));
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GDLabel sLabel = new GDLabel("Server Name:", 4);
        panel.add((Component)sLabel);
        this.serverLabel = new GDLabel(serverName);
        this.serverLabel.setName("Server Name");
        panel.add(this.serverLabel);
        GDLabel pLabel = new GDLabel("Port Number:", 4);
        panel.add((Component)pLabel);
        this.portLabel = new GDLabel(portNumberStr);
        this.portLabel.setName("Port Number");
        panel.add(this.portLabel);
        GDLabel repLabel = new GDLabel("Repository Name:", 4);
        panel.add((Component)repLabel);
        this.repNameLabel = new GDLabel(repositoryName);
        this.repNameLabel.setName("Repository Name");
        panel.add(this.repNameLabel);
        GDLabel connectLabel = new GDLabel("Connection Status:", 4);
        panel.add((Component)connectLabel);
        this.connectionButton = new JButton(isConnected ? FrontEndPlugin.CONNECTED_ICON : FrontEndPlugin.DISCONNECTED_ICON);
        this.connectionButton.addActionListener(e -> this.connect());
        this.connectionButton.setName("Connect Button");
        this.connectionButton.setContentAreaFilled(false);
        this.connectionButton.setSelected(isConnected);
        this.connectionButton.setBorder(isConnected ? BorderFactory.createBevelBorder(1) : BorderFactory.createBevelBorder(0));
        this.updateConnectButtonToolTip();
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.connectionButton, new HelpLocation("FrontEndPlugin", "ConnectToServer"));
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        buttonPanel.add(this.connectionButton);
        panel.add(buttonPanel);
        GDLabel userLabel = new GDLabel("User Access Level:", 4);
        userLabel.setToolTipText("Indicates your privileges in the shared repository");
        panel.add((Component)userLabel);
        User user = null;
        if (isConnected) {
            try {
                user = this.repository.getUser();
            }
            catch (IOException e2) {
                Msg.error((Object)((Object)this), (Object)"Unable to get the current user", (Throwable)e2);
            }
        }
        this.userAccessLabel = new GDLabel(this.getAccessString(user));
        this.userAccessLabel.setName("User Access Level");
        panel.add((Component)userLabel);
        panel.add(this.userAccessLabel);
        outerPanel.add(panel);
        if (this.repository == null) {
            sLabel.setEnabled(false);
            pLabel.setEnabled(false);
            repLabel.setEnabled(false);
            connectLabel.setEnabled(false);
            this.connectionButton.setEnabled(false);
            userLabel.setEnabled(false);
        }
        return outerPanel;
    }

    private void updateConnectButtonToolTip() {
        if (this.repository != null) {
            ServerInfo info = this.repository.getServerInfo();
            String serverName = info.getServerName();
            String notConnectedToolTip = HTMLUtilities.toHTML((String)("Disconnected from " + serverName + ".\nActivate this button to connect."));
            this.connectionButton.setToolTipText((String)(this.repository.isConnected() ? "Connected to " + serverName : notConnectedToolTip));
        }
    }

    private void connect() {
        try {
            this.repository.connect();
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Repository Connection", (Component)this.rootPanel);
        }
    }

    private String getAccessString(User user) {
        if (user == null) {
            return "";
        }
        if (user.isAdmin()) {
            return "Administrator";
        }
        if (user.isReadOnly()) {
            return "Read Only";
        }
        return "Read/Write";
    }

    private void updateSharedProjectInfo() {
        if (this.filesAreOpen()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Cannot Change Project Info with Open Files", (Object)"Before your project info can be updated, you must close\nfiles in running tools and make sure you have no files\nchecked out.");
            return;
        }
        SetupProjectPanelManager panelManager = new SetupProjectPanelManager(this.plugin.getTool(), this.project.getRepository().getServerInfo());
        WizardManager wm = new WizardManager("Change Shared Project Information", true, (PanelManager)panelManager, CONVERT_ICON);
        wm.showWizard((Component)this.getComponent());
        RepositoryAdapter rep = panelManager.getProjectRepository();
        if (rep != null) {
            RepositoryAdapter currentRepository = this.project.getRepository();
            if (currentRepository.getServerInfo().equals((Object)rep.getServerInfo()) && currentRepository.getName().equals(rep.getName())) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"No Changes Made", (Object)"No changes were made to the shared project information.");
            } else if (OptionDialog.showOptionDialog((Component)this.getComponent(), (String)"Update Shared Project Info", (String)"Are you sure you want to update your shared project information?", (String)"Update", (int)3) == 1) {
                UpdateInfoTask task = new UpdateInfoTask(rep);
                new TaskLauncher((Task)task, (Component)this.getComponent(), 500);
                if (task.getStatus()) {
                    FileActionManager actionMgr = this.plugin.getFileActionManager();
                    this.close();
                    actionMgr.closeProject(false);
                    actionMgr.openProject(this.project.getProjectLocator());
                    this.plugin.getProjectActionManager().showProjectInfo();
                }
            }
        }
    }

    private void convertToIndexedFilesystem() {
        if (this.filesAreOpen()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Cannot Convert/Upgrade Project Storage with Open Files", (Object)"Before your project can be converted, you must close\nfiles in running tools.");
            return;
        }
        RepositoryAdapter rep = this.project.getRepository();
        if (rep != null) {
            rep.disconnect();
        }
        if (OptionDialog.showOptionDialog((Component)this.getComponent(), (String)"Confirm Convert/Upgrade Project Storage", (String)"Convert/Upgrade Project Storage to latest Indexed Filesystem ?\n \nWARNING!  Once converted a project may no longer be opened by\nany version of Ghidra older than version 6.1.", (String)"Convert", (int)2) == 1) {
            ProjectLocator projectLocator = this.project.getProjectLocator();
            FileActionManager actionMgr = this.plugin.getFileActionManager();
            actionMgr.closeProject(false);
            ConvertProjectStorageTask task = new ConvertProjectStorageTask(projectLocator);
            new TaskLauncher((Task)task, (Component)this.getComponent(), 500);
            if (task.getStatus()) {
                this.close();
                actionMgr.openProject(projectLocator);
                this.plugin.getProjectActionManager().showProjectInfo();
            }
        }
    }

    private void convertToShared() {
        if (this.filesAreOpen()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Cannot Convert Project with Open Files", (Object)"Before your project can be converted, you must close\nfiles in running tools and make sure you have no files\nchecked out.");
            return;
        }
        SetupProjectPanelManager panelManager = new SetupProjectPanelManager(this.plugin.getTool(), null);
        WizardManager wm = new WizardManager("Convert Project", true, (PanelManager)panelManager, CONVERT_ICON);
        wm.showWizard((Component)this.getComponent());
        RepositoryAdapter rep = panelManager.getProjectRepository();
        if (rep != null) {
            StringBuffer confirmMsg = new StringBuffer();
            confirmMsg.append("All version history on your files will be\nlost after your project is converted.\nDo you want to convert your project?\n");
            confirmMsg.append(" \n");
            confirmMsg.append("WARNING: Convert CANNOT be undone!");
            if (OptionDialog.showOptionDialog((Component)this.getComponent(), (String)"Confirm Convert Project", (String)confirmMsg.toString(), (String)"Convert", (int)2) == 1) {
                ConvertProjectTask task = new ConvertProjectTask(rep);
                new TaskLauncher((Task)task, (Component)this.getComponent(), 500);
                if (task.getStatus()) {
                    this.close();
                    FileActionManager actionMgr = this.plugin.getFileActionManager();
                    actionMgr.closeProject(false);
                    actionMgr.openProject(this.project.getProjectLocator());
                    this.plugin.getProjectActionManager().showProjectInfo();
                } else {
                    Msg.trace((Object)((Object)this), (Object)"Convert project task failed");
                }
            }
        }
    }

    private boolean filesAreOpen() {
        PluginTool[] tools = this.project.getToolManager().getRunningTools();
        if (tools.length > 0) {
            for (PluginTool tool : tools) {
                if (tool.getDomainFiles().length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private class UpdateInfoTask
    extends Task {
        private RepositoryAdapter taskRepository;
        private boolean status;

        UpdateInfoTask(RepositoryAdapter repository) {
            super("Update Shared Project Info", true, false, true);
            this.taskRepository = repository;
        }

        public void run(TaskMonitor monitor) {
            try {
                ProjectInfoDialog.this.project.getProjectData().updateRepositoryInfo(this.taskRepository, monitor);
                this.status = true;
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                Msg.showError((Object)((Object)this), (Component)ProjectInfoDialog.this.getComponent(), (String)"Failed to Update Shared Project Info", (Object)("Conversion to shared project failed:\n" + msg));
            }
            catch (CancelledException e) {
                Msg.info((Object)((Object)this), (Object)"Convert project was canceled.");
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }

    private class ConvertProjectStorageTask
    extends Task {
        private ProjectLocator projectLocator;
        private boolean status;

        ConvertProjectStorageTask(ProjectLocator projectLocator) {
            super("Convert Project Storage", false, false, true);
            this.projectLocator = projectLocator;
        }

        public void run(TaskMonitor monitor) {
            try {
                monitor.setMessage("Converting storage...");
                File projectDir = this.projectLocator.getProjectDir();
                ConvertFileSystem.convertProject(projectDir, new ConvertFileSystem.MessageListener(){

                    @Override
                    public void println(String string) {
                        Msg.info((Object)this, (Object)string);
                    }
                });
                this.status = true;
            }
            catch (ConvertFileSystem.ConvertFileSystemException e) {
                Msg.showError((Object)((Object)this), (Component)ProjectInfoDialog.this.getComponent(), (String)"Failed to Convert Project Storage", (Object)e.getMessage());
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }

    private class ConvertProjectTask
    extends Task {
        private RepositoryAdapter taskRepository;
        private boolean status;

        ConvertProjectTask(RepositoryAdapter repository) {
            super("Convert Project to Shared", true, false, true);
            this.taskRepository = repository;
        }

        public void run(TaskMonitor monitor) {
            try {
                ProjectInfoDialog.this.project.getProjectData().convertProjectToShared(this.taskRepository, monitor);
                this.status = true;
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                Msg.showError((Object)((Object)this), (Component)ProjectInfoDialog.this.getComponent(), (String)"Failed to Convert Project", (Object)("Update to shared project info failed:\n" + msg));
            }
            catch (CancelledException e) {
                Msg.info((Object)((Object)this), (Object)"Update shared project info was canceled.");
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }
}

