/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBHandle;
import ghidra.framework.data.CheckinHandler;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.TransientDataManager;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.util.InvalidNameException;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.FileInUseException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class DomainFileProxy
implements DomainFile {
    private DomainObjectAdapter domainObj;
    private ProjectLocator projectLocation;
    private String name;
    private int version;
    private String parentPath;
    private long lastModified = 0L;
    private String fileID;

    public DomainFileProxy(String name, DomainObjectAdapter doa) {
        this.domainObj = doa;
        this.name = name;
        doa.setDomainFile(this);
        TransientDataManager.addTransient(this);
        this.version = -1;
    }

    DomainFileProxy(String name, String parentPath, DomainObjectAdapter doa, int version, String fileID, ProjectLocator projectLocation) {
        this(name, doa);
        this.parentPath = parentPath;
        this.version = version;
        this.fileID = fileID;
        this.projectLocation = projectLocation;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public synchronized DomainFile setName(String newName) {
        this.name = newName;
        return this;
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.projectLocation;
    }

    @Override
    public long length() throws IOException {
        return 0L;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean state) {
        throw new UnsupportedOperationException("setReadOnly() not suppported on DomainFileProxy");
    }

    @Override
    public boolean isInWritableProject() {
        return false;
    }

    @Override
    public String getPathname() {
        if (this.parentPath == null || this.parentPath.equals("/")) {
            return "/" + this.getName();
        }
        return this.parentPath + "/" + this.getName();
    }

    @Override
    public int compareTo(DomainFile df) {
        return this.getName().compareToIgnoreCase(df.getName());
    }

    public String toString() {
        Object s = this.getPathname();
        if (this.projectLocation != null) {
            s = this.projectLocation.getName() + ":" + (String)s;
        }
        if (this.version != -1) {
            s = (String)s + "@" + this.version;
        }
        return s;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    @Override
    public String getFileID() {
        return this.fileID;
    }

    @Override
    public String getContentType() {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj != null) {
            try {
                ContentHandler ch = DomainObjectAdapter.getContentHandler(dobj);
                return ch.getContentType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown File";
    }

    @Override
    public Class<? extends DomainObject> getDomainObjectClass() {
        DomainObjectAdapter dobj = this.getDomainObject();
        return dobj != null ? dobj.getClass() : null;
    }

    @Override
    public DomainFolder getParent() {
        return null;
    }

    synchronized void setLastModified(long time) {
        this.lastModified = time;
    }

    @Override
    public synchronized long getLastModifiedTime() {
        return this.lastModified;
    }

    @Override
    public void save(TaskMonitor monitor) throws IOException {
        throw new ReadOnlyException("Location does not exist for a save operation!");
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public boolean canRecover() {
        return false;
    }

    @Override
    public boolean takeRecoverySnapshot() {
        throw new UnsupportedOperationException("Recovery snapshot not supported for proxy file");
    }

    public boolean isInUse() {
        return true;
    }

    public boolean isUsedExclusivelyBy(Object consumer) {
        DomainObjectAdapter dobj = this.getDomainObject();
        return dobj != null ? dobj.isUsedExclusivelyBy(consumer) : false;
    }

    public ArrayList<?> getConsumers() {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj != null) {
            return dobj.getConsumerList();
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDomainObj() {
        DomainFileProxy domainFileProxy = this;
        synchronized (domainFileProxy) {
            this.domainObj = null;
        }
        TransientDataManager.removeTransient(this);
    }

    void release(Object consumer) {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj != null) {
            try {
                dobj.release(consumer);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public boolean isUsedBy(Object consumer) {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj != null) {
            return dobj.isUsedBy(consumer);
        }
        return false;
    }

    @Override
    public void addToVersionControl(String comment, boolean keepCheckedOut, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException("Repository operations not supported");
    }

    @Override
    public boolean isVersionControlSupported() {
        return false;
    }

    @Override
    public boolean canAddToRepository() {
        return false;
    }

    @Override
    public boolean isBusy() {
        DomainObjectAdapter dobj = this.getDomainObject();
        return dobj != null && !dobj.canLock();
    }

    @Override
    public boolean canCheckout() {
        return false;
    }

    @Override
    public boolean canCheckin() {
        return false;
    }

    @Override
    public boolean canMerge() {
        return false;
    }

    @Override
    public boolean checkout(boolean exclusive, TaskMonitor monitor) {
        throw new UnsupportedOperationException("Repository operations not supported");
    }

    @Override
    public void checkin(CheckinHandler checkinHandler, boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        throw new UnsupportedOperationException("Repository operations not supported");
    }

    @Override
    public void merge(boolean okToUpgrade, TaskMonitor monitor) {
        throw new UnsupportedOperationException("Repository operations not supported");
    }

    @Override
    public DomainFile copyTo(DomainFolder newParent, TaskMonitor monitor) throws IOException, CancelledException {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj == null) {
            throw new ClosedException();
        }
        try {
            return newParent.createFile(this.getName(), dobj, monitor);
        }
        catch (InvalidNameException e) {
            throw new AssertException("Unexpected error", (Throwable)e);
        }
    }

    @Override
    public DomainFile copyVersionTo(int version, DomainFolder destFolder, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException("copyVersionTo unsupported for DomainFileProxy");
    }

    @Override
    public synchronized void delete() throws IOException {
        if (this.domainObj != null) {
            throw new FileInUseException("Proxy file for " + this.name + " is in use");
        }
    }

    @Override
    public void delete(int fileVersion) throws IOException {
        throw new UnsupportedOperationException("delete(version) unsupported for DomainFileProxy");
    }

    @Override
    public int getLatestVersion() {
        return 0;
    }

    @Override
    public boolean isLatestVersion() {
        return this.version == -1;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Version[] getVersionHistory() throws IOException {
        return new Version[0];
    }

    @Override
    public boolean isCheckedOut() {
        return false;
    }

    @Override
    public boolean isCheckedOutExclusive() {
        return false;
    }

    @Override
    public DomainFile moveTo(DomainFolder newParent) throws IOException {
        throw new UnsupportedOperationException("Cannot move a proxy file - must call copyTo()");
    }

    @Override
    public void undoCheckout(boolean keep) throws IOException {
        throw new UnsupportedOperationException("undoCheckout() unsupported for DomainFileProxy");
    }

    @Override
    public ChangeSet getChangesByOthersSinceCheckout() throws IOException {
        return null;
    }

    private synchronized DomainObjectAdapter getDomainObject() {
        return this.domainObj;
    }

    @Override
    public DomainObject getDomainObject(Object consumer, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, IOException {
        return this.getOpenedDomainObject(consumer);
    }

    @Override
    public DomainObject getOpenedDomainObject(Object consumer) {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj != null) {
            dobj.addConsumer(consumer);
        }
        return dobj;
    }

    @Override
    public boolean isVersioned() {
        return false;
    }

    @Override
    public synchronized void packFile(File file, TaskMonitor monitor) throws IOException, CancelledException {
        if (!(this.domainObj instanceof DomainObjectAdapterDB)) {
            throw new UnsupportedOperationException("packFile() only valid for Database files");
        }
        DomainObjectAdapterDB dbObj = (DomainObjectAdapterDB)this.domainObj;
        ContentHandler ch = DomainObjectAdapter.getContentHandler(this.domainObj);
        PackedDatabase.packDatabase((DBHandle)dbObj.getDBHandle(), (String)dbObj.getName(), (String)ch.getContentType(), (File)file, (TaskMonitor)monitor);
    }

    @Override
    public Icon getIcon(boolean disabled) {
        return null;
    }

    @Override
    public DomainObject getImmutableDomainObject(Object consumer, int fileVersion, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        throw new UnsupportedOperationException("getImmutableDomainObject unsupported for DomainFileProxy");
    }

    @Override
    public DomainObject getReadOnlyDomainObject(Object consumer, int fileVersion, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (fileVersion != -1 && fileVersion != this.version) {
            throw new AssertException("Version mismatch on DomainFileProxy");
        }
        return this.getOpenedDomainObject(consumer);
    }

    @Override
    public boolean isHijacked() {
        return false;
    }

    @Override
    public boolean modifiedSinceCheckout() {
        return false;
    }

    @Override
    public boolean isChanged() {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj != null) {
            return dobj.isChanged();
        }
        return false;
    }

    @Override
    public boolean isOpen() {
        DomainObjectAdapter dobj = this.getDomainObject();
        return dobj != null && !dobj.isClosed();
    }

    @Override
    public void terminateCheckout(long checkoutId) throws IOException {
        throw new UnsupportedOperationException("terminateCheckout() unsupported for DomainFileProxy");
    }

    @Override
    public ItemCheckoutStatus[] getCheckouts() throws IOException {
        throw new UnsupportedOperationException("getCheckouts() unsupported for DomainFileProxy");
    }

    @Override
    public ItemCheckoutStatus getCheckoutStatus() throws IOException {
        throw new UnsupportedOperationException("getCheckoutStatus() unsupported for DomainFileProxy");
    }

    @Override
    public Map<String, String> getMetadata() {
        DomainObjectAdapter dobj = this.getDomainObject();
        if (dobj != null) {
            dobj.getMetadata();
        }
        return new HashMap<String, String>();
    }
}

