/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RegisterFieldLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RegisterFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Register";
    public static final String REGISTER_GROUP_NAME = "Register Field";
    public static final String DISPLAY_HIDDEN_REGISTERS_OPTION_NAME = "Register Field.Display Hidden Registers";
    public static final String DISPLAY_DEFAULT_REGISTER_VALUES_OPTION_NAME = "Register Field.Display Default Register Values";
    private RegComparator regComp;
    private Color regColor;
    private boolean showHiddenRegisters;
    private boolean showDefaultValues;

    public RegisterFieldFactory() {
        super(FIELD_NAME);
    }

    private RegisterFieldFactory(FieldFormatModel model, HighlightProvider highlightProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, highlightProvider, displayOptions, fieldOptions);
        this.regComp = new RegComparator();
        this.initDisplayOptions();
        fieldOptions.registerOption(DISPLAY_HIDDEN_REGISTERS_OPTION_NAME, (Object)false, null, "Shows/hides context registers");
        fieldOptions.registerOption(DISPLAY_DEFAULT_REGISTER_VALUES_OPTION_NAME, (Object)false, null, "Shows/hides default register values");
        this.regColor = displayOptions.getColor(OptionsGui.REGISTERS.getColorOptionName(), this.getDefaultColor());
        this.showHiddenRegisters = fieldOptions.getBoolean(DISPLAY_HIDDEN_REGISTERS_OPTION_NAME, false);
        this.showDefaultValues = fieldOptions.getBoolean(DISPLAY_DEFAULT_REGISTER_VALUES_OPTION_NAME, false);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider highlightProvider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new RegisterFieldFactory(formatModel, highlightProvider, (Options)toolOptions, (Options)fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Function)) {
            return null;
        }
        int x = this.startX + varWidth;
        Function function = (Function)obj;
        List<Register> setRegisters = this.getSetRegisters(function);
        if (setRegisters.isEmpty()) {
            return null;
        }
        String[] registerStrings = this.getRegisterStrings(function, setRegisters);
        return this.getTextField(registerStrings, proxy, x);
    }

    private String[] getRegisterStrings(Function function, List<Register> setRegisters) {
        Program program = function.getProgram();
        ProgramContext programContext = program.getProgramContext();
        Address address = function.getEntryPoint();
        String[] strings = new String[setRegisters.size()];
        for (int i = 0; i < strings.length; ++i) {
            Register register = setRegisters.get(i);
            BigInteger value = programContext.getValue(register, address, false);
            strings[i] = "assume " + register.getName() + " = 0x" + value.toString(16);
        }
        return strings;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Function && loc.getClass() == RegisterFieldLocation.class) {
            RegisterFieldLocation regLoc = (RegisterFieldLocation)loc;
            return new FieldLocation(index, fieldNum, regLoc.getRow(), regLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Function) {
            Function function = (Function)obj;
            List<Register> setRegisters = this.getSetRegisters(function);
            String[] registerStrings = this.getRegisterStrings(function, setRegisters);
            String[] registerNames = this.getRegisterNames(setRegisters);
            return new RegisterFieldLocation(function.getProgram(), function.getEntryPoint(), registerNames, registerStrings, row, col);
        }
        return null;
    }

    private String[] getRegisterNames(List<Register> setRegisters) {
        String[] names = new String[setRegisters.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = setRegisters.get(i).getName();
        }
        return names;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Function.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 2;
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.REGISTERS.getDefaultColor();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.fieldOptionsChanged(options, optionName, oldValue, newValue);
        if (optionName.equals(DISPLAY_HIDDEN_REGISTERS_OPTION_NAME)) {
            this.showHiddenRegisters = (Boolean)newValue;
            this.model.update();
        }
        if (optionName.equals(DISPLAY_DEFAULT_REGISTER_VALUES_OPTION_NAME)) {
            this.showDefaultValues = (Boolean)newValue;
            this.model.update();
        }
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
        if (optionName.equals(OptionsGui.REGISTERS.getColorOptionName())) {
            this.regColor = (Color)newValue;
            this.model.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<Register> getSetRegisters(Function function) {
        void var9_11;
        Program program = function.getProgram();
        ProgramContext programContext = program.getProgramContext();
        Register[] registers = programContext.getRegistersWithValues();
        Address address = function.getEntryPoint();
        ArrayList<Object> setRegisters = new ArrayList<Register>();
        Register[] registerArray = registers;
        int n = registerArray.length;
        boolean bl = false;
        while (var9_11 < n) {
            Register register = registerArray[var9_11];
            if (!register.isHidden() || this.showHiddenRegisters) {
                RegisterValue regVal;
                RegisterValue registerValue = regVal = this.showDefaultValues ? programContext.getRegisterValue(register, address) : programContext.getNonDefaultValue(register, address);
                if (regVal != null && regVal.hasValue()) {
                    setRegisters.add(register);
                }
            }
            ++var9_11;
        }
        if (setRegisters.size() > 1) {
            ArrayList<Register> dedupedRegisters = new ArrayList<Register>();
            for (Register register : setRegisters) {
                Register parent = register.getParentRegister();
                if (parent != null && setRegisters.contains(parent)) continue;
                dedupedRegisters.add(register);
            }
            setRegisters = dedupedRegisters;
        }
        Collections.sort(setRegisters, this.regComp);
        return setRegisters;
    }

    private FieldElement[] getFieldElements(String[] registerStrings) {
        FieldElement[] fieldElements = new FieldElement[registerStrings.length];
        for (int i = 0; i < registerStrings.length; ++i) {
            AttributedString str = new AttributedString(registerStrings[i], this.regColor, this.getMetrics());
            fieldElements[i] = new TextFieldElement(str, i, 0);
        }
        return fieldElements;
    }

    private ListingTextField getTextField(String[] registerStrings, ProxyObj<?> proxy, int xStart) {
        if (registerStrings.length <= 0) {
            return null;
        }
        FieldElement[] fieldElements = this.getFieldElements(registerStrings);
        return ListingTextField.createMultilineTextField(this, proxy, fieldElements, xStart, this.width, Integer.MAX_VALUE, this.hlProvider);
    }

    private class RegComparator
    implements Comparator<Register> {
        private RegComparator() {
        }

        @Override
        public int compare(Register r1, Register r2) {
            return r1.getName().compareToIgnoreCase(r2.getName());
        }
    }
}

