/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.awt.Color;

public class AddressAnnotatedStringHandler
implements AnnotatedStringHandler {
    private static final String INVALID_SYMBOL_TEXT = "@address annotation must have an addressstring";
    private static final String[] SUPPORTED_ANNOTATIONS = new String[]{"address", "addr"};

    @Override
    public AttributedString createAnnotatedString(AttributedString prototypeString, String[] text, Program program) throws AnnotationException {
        if (text.length <= 1) {
            throw new AnnotationException(INVALID_SYMBOL_TEXT);
        }
        if (program == null) {
            return this.createUndecoratedString(prototypeString, text);
        }
        Address address = program.getAddressFactory().getAddress(text[1]);
        if (address == null) {
            return new AttributedString("No address: " + text[1], Color.RED, prototypeString.getFontMetrics(0), false, null);
        }
        String addressText = address.toString();
        if (text.length > 2) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 2; i < text.length; ++i) {
                buffer.append(text[i]).append(" ");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            addressText = buffer.toString();
        }
        return new AttributedString(addressText, prototypeString.getColor(0), prototypeString.getFontMetrics(0), true, prototypeString.getColor(0));
    }

    private AttributedString createUndecoratedString(AttributedString prototypeString, String[] text) {
        StringBuilder buffer = new StringBuilder();
        for (String string : text) {
            buffer.append(string).append(" ");
        }
        return new AttributedString(buffer.toString(), Color.LIGHT_GRAY, prototypeString.getFontMetrics(0));
    }

    @Override
    public String[] getSupportedAnnotations() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public boolean handleMouseClick(String[] annotationParts, Navigatable sourceNavigatable, ServiceProvider serviceProvider) {
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        Program program = sourceNavigatable.getProgram();
        String addressText = annotationParts[1];
        Address address = program.getAddressFactory().getAddress(addressText);
        if (address != null) {
            return goToService.goTo(sourceNavigatable, address);
        }
        Msg.showInfo(this.getClass(), null, (String)("No address: " + addressText), (Object)("Unable to locate address \"" + addressText + "\""));
        return false;
    }

    @Override
    public String getDisplayString() {
        return "Address";
    }

    @Override
    public String getPrototypeString() {
        return "{@address 0x00}";
    }
}

