/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class MapLoader
extends AbstractLibrarySupportLoader {
    public static final String MAP_NAME = "Program Mapfile (MAP)";
    public static final String NO_MAGIC = "0";

    private List<MapExport> parseExports(ByteProvider provider, MessageLog log) throws IOException {
        ArrayList<MapExport> list = new ArrayList<MapExport>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(provider.getInputStream(0L)));){
            String line;
            boolean hasExports = false;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).startsWith(";")) continue;
                if (hasExports) {
                    if (!line.isEmpty()) {
                        try {
                            list.add(MapExport.parse(line, lineNumber));
                        }
                        catch (ParseException e) {
                            if (log == null) continue;
                            log.appendMsg(e.getMessage());
                        }
                        continue;
                    }
                    if (list.isEmpty()) continue;
                    break;
                }
                if (line.indexOf("Publics by Value") == -1) continue;
                hasExports = true;
            }
        }
        return list;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.getName() != null && provider.getName().toLowerCase().endsWith(".map") && !this.parseExports(provider, null).isEmpty()) {
            List<QueryResult> results = QueryOpinionService.query(this.getName(), NO_MAGIC, null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, TaskMonitor monitor, MessageLog log) throws IOException {
        if (!prog.getExecutableFormat().equals("Portable Executable (PE)")) {
            throw new IOException("Program must be a Portable Executable (PE)");
        }
        SymbolTable symtab = prog.getSymbolTable();
        AddressSpace space = prog.getAddressFactory().getDefaultAddressSpace();
        List<MapExport> exports = this.parseExports(provider, log);
        int successCount = 0;
        for (MapExport exp : exports) {
            try {
                symtab.createLabel(space.getAddress(exp.addr), exp.name, SourceType.IMPORTED).setPrimary();
                ++successCount;
            }
            catch (InvalidInputException e) {
                log.appendMsg(e.getMessage());
            }
        }
        log.appendMsg("Added " + successCount + " symbols.");
    }

    @Override
    public String getName() {
        return MAP_NAME;
    }

    @Override
    public boolean supportsLoadIntoProgram() {
        return true;
    }

    private static class MapExport {
        private String name;
        private long addr;

        private MapExport(String name, long addr) {
            this.name = name;
            this.addr = addr;
        }

        public static MapExport parse(String exportLine, int lineNumber) throws ParseException {
            long addr;
            StringTokenizer st = new StringTokenizer(exportLine);
            if (!st.hasMoreTokens()) {
                throw new ParseException("Line " + lineNumber + ": Failed to parse first field", lineNumber);
            }
            st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new ParseException("Line " + lineNumber + ": Failed to parse second (name) field", lineNumber);
            }
            String name = st.nextToken();
            if (st.hasMoreTokens()) {
                try {
                    addr = Long.parseLong(st.nextToken(), 16);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Line " + lineNumber + ": Failed to parse third (addr) field", lineNumber);
                }
            } else {
                throw new ParseException("Line " + lineNumber + ": Failed to parse third (addr) field", lineNumber);
            }
            return new MapExport(name, addr);
        }
    }
}

