/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.DyldChainedImport;
import ghidra.app.util.bin.format.macho.commands.DyldChainedImports;
import ghidra.app.util.bin.format.macho.commands.DyldChainedStartsInImage;
import ghidra.app.util.bin.format.macho.commands.DyldChainedStartsInSegment;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.bin.format.macho.prelink.PrelinkMap;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.BidiMap;

public class MachoPrelinkProgramBuilder
extends MachoProgramBuilder {
    private List<PrelinkMap> prelinkList;
    private boolean shouldAddRelocationEntries;

    protected MachoPrelinkProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, List<PrelinkMap> prelinkList, boolean shouldAddRelocationEntries, MessageLog log, TaskMonitor monitor) {
        super(program, provider, fileBytes, log, monitor);
        this.prelinkList = prelinkList;
        this.shouldAddRelocationEntries = shouldAddRelocationEntries;
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, List<PrelinkMap> prelinkList, boolean addRelocationEntries, MessageLog log, TaskMonitor monitor) throws Exception {
        MachoPrelinkProgramBuilder machoPrelinkProgramBuilder = new MachoPrelinkProgramBuilder(program, provider, fileBytes, prelinkList, addRelocationEntries, log, monitor);
        machoPrelinkProgramBuilder.build();
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this.fixPreLinkAddresses();
        this.doRelocations();
    }

    @Override
    protected void doRelocations() throws Exception {
        this.processDyldInfo(false);
        this.markupHeaders(this.machoHeader, this.setupHeaderAddr(this.machoHeader.getAllSegments()));
        this.markupSections();
        this.processProgramVars();
        this.loadSectionRelocations();
        this.loadExternalRelocations();
        this.loadLocalRelocations();
    }

    protected void fixPreLinkAddresses() throws MemoryAccessException, CancelledException, Exception, IOException, MachException {
        List<Address> fixedAddresses = this.fixupChainedPointers();
        this.processPreLinkMachoInfo();
        for (Address addr : fixedAddresses) {
            this.monitor.checkCanceled();
            try {
                this.program.getListing().createData(addr, (DataType)Pointer64DataType.dataType);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {}
        }
    }

    protected void processPreLinkMachoInfo() throws Exception, IOException, MachException {
        ArrayList<PrelinkMachoInfo> prelinkMachoInfoList = new ArrayList<PrelinkMachoInfo>();
        List<FileSetEntryCommand> fileSetEntries = this.machoHeader.getLoadCommands(FileSetEntryCommand.class);
        if (fileSetEntries != null && fileSetEntries.size() > 0) {
            for (FileSetEntryCommand fileSetEntryCommand : fileSetEntries) {
                prelinkMachoInfoList.add(new PrelinkMachoInfo(this.provider, fileSetEntryCommand.getFileOffset(), this.space.getAddress(fileSetEntryCommand.getVMaddress()), fileSetEntryCommand.getFileSetEntryName()));
            }
        } else {
            List<Long> machoHeaderOffsets = MachoPrelinkUtils.findPrelinkMachoHeaderOffsets(this.provider, this.monitor);
            if (machoHeaderOffsets.isEmpty()) {
                return;
            }
            BidiMap<PrelinkMap, Long> map = MachoPrelinkUtils.matchPrelinkToMachoHeaderOffsets(this.provider, this.prelinkList, machoHeaderOffsets, this.monitor);
            long prelinkStart = MachoPrelinkUtils.getPrelinkStartAddr(this.machoHeader);
            Address prelinkStartAddr = null;
            prelinkStartAddr = prelinkStart == 0L ? this.program.getImageBase().add(machoHeaderOffsets.get(0).longValue()) : this.space.getAddress(prelinkStart);
            for (Long machoHeaderOffset : machoHeaderOffsets) {
                prelinkMachoInfoList.add(new PrelinkMachoInfo(this.provider, (long)machoHeaderOffset, prelinkStartAddr.add(machoHeaderOffset - machoHeaderOffsets.get(0)), (PrelinkMap)map.getKey((Object)machoHeaderOffset)));
            }
        }
        Collections.sort(prelinkMachoInfoList);
        this.monitor.initialize((long)prelinkMachoInfoList.size());
        for (int i = 0; i < prelinkMachoInfoList.size(); ++i) {
            PrelinkMachoInfo info = (PrelinkMachoInfo)prelinkMachoInfoList.get(i);
            PrelinkMachoInfo next = null;
            if (i < prelinkMachoInfoList.size() - 1) {
                next = (PrelinkMachoInfo)prelinkMachoInfoList.get(i + 1);
            }
            info.processMemoryBlocks();
            info.markupHeaders();
            info.addToProgramTree(next);
            this.monitor.incrementProgress(1L);
        }
    }

    @Override
    protected void renameObjMsgSendRtpSymbol() throws DuplicateNameException, InvalidInputException {
    }

    private List<Address> fixupChainedPointers() throws MemoryAccessException, CancelledException {
        int headStartOffset;
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        List<DyldChainedFixupsCommand> loadCommands = this.machoHeader.getLoadCommands(DyldChainedFixupsCommand.class);
        for (LoadCommand loadCommand : loadCommands) {
            DyldChainedStartsInSegment[] chainedStarts;
            DyldChainedFixupsCommand linkCmd = (DyldChainedFixupsCommand)loadCommand;
            DyldChainedFixupHeader chainHeader = linkCmd.getChainHeader();
            DyldChainedStartsInImage chainedStartsInImage = chainHeader.getChainedStartsInImage();
            for (DyldChainedStartsInSegment chainStart : chainedStarts = chainedStartsInImage.getChainedStarts()) {
                fixedAddresses.addAll(this.processSegmentPointerChain(chainHeader, chainStart));
            }
            this.log.appendMsg("Fixed up " + fixedAddresses.size() + " chained pointers.");
        }
        if (loadCommands.size() > 0) {
            return fixedAddresses;
        }
        Section threadStarts = this.machoHeader.getSection("__TEXT", "__thread_starts");
        if (threadStarts == null) {
            return Collections.emptyList();
        }
        Object var4_5 = null;
        Address threadSectionEnd = null;
        Address address = this.space.getAddress(threadStarts.getAddress());
        threadSectionEnd = address.add(threadStarts.getSize() - 1L);
        this.monitor.setMessage("Fixing up chained pointers...");
        long nextOffSize = (this.memory.getInt(address) & 1) * 4 + 4;
        Address chainHead = address.add(4L);
        while (chainHead.compareTo((Object)threadSectionEnd) < 0 && !this.monitor.isCancelled() && (headStartOffset = this.memory.getInt(chainHead)) != -1 && headStartOffset != 0) {
            Address chainStart = this.program.getImageBase().add((long)headStartOffset & 0xFFFFFFFFL);
            fixedAddresses.addAll(this.processPointerChain(chainStart, nextOffSize));
            chainHead = chainHead.add(4L);
        }
        this.log.appendMsg("Fixed up " + fixedAddresses.size() + " chained pointers.");
        return fixedAddresses;
    }

    private List<Address> processSegmentPointerChain(DyldChainedFixupHeader chainHeader, DyldChainedStartsInSegment chainStart) throws MemoryAccessException, CancelledException {
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        long fixedAddressCount = 0L;
        if (chainStart.getPointerFormat() == 0) {
            return fixedAddresses;
        }
        long dataPageStart = chainStart.getSegmentOffset();
        dataPageStart += this.program.getImageBase().getOffset();
        long pageSize = chainStart.getPageSize();
        long pageStartsCount = chainStart.getPageCount();
        long authValueAdd = 0L;
        short[] pageStarts = chainStart.getPage_starts();
        short ptrFormatValue = chainStart.getPointerFormat();
        DyldChainedPtr.DyldChainType ptrFormat = DyldChainedPtr.DyldChainType.lookupChainPtr(ptrFormatValue);
        this.monitor.setMessage("Fixing " + ptrFormat.getName() + " chained pointers...");
        this.monitor.setMaximum(pageStartsCount);
        int index = 0;
        while ((long)index < pageStartsCount) {
            this.monitor.checkCanceled();
            long page = dataPageStart + pageSize * (long)index;
            this.monitor.setProgress((long)index);
            int pageEntry = pageStarts[index] & 0xFFFF;
            if (pageEntry != 65535) {
                ArrayList<Address> unchainedLocList = new ArrayList<Address>(1024);
                long pageOffset = pageEntry;
                switch (ptrFormat) {
                    case DYLD_CHAINED_PTR_ARM64E: 
                    case DYLD_CHAINED_PTR_ARM64E_KERNEL: 
                    case DYLD_CHAINED_PTR_ARM64E_USERLAND: 
                    case DYLD_CHAINED_PTR_ARM64E_USERLAND24: {
                        this.processPointerChain(chainHeader, unchainedLocList, ptrFormat, page, pageOffset, authValueAdd);
                        break;
                    }
                    case DYLD_CHAINED_PTR_64: 
                    case DYLD_CHAINED_PTR_64_OFFSET: 
                    case DYLD_CHAINED_PTR_64_KERNEL_CACHE: 
                    case DYLD_CHAINED_PTR_32: 
                    case DYLD_CHAINED_PTR_32_CACHE: 
                    case DYLD_CHAINED_PTR_32_FIRMWARE: 
                    case DYLD_CHAINED_PTR_X86_64_KERNEL_CACHE: {
                        this.processPointerChain(chainHeader, unchainedLocList, ptrFormat, page, pageOffset, authValueAdd);
                        break;
                    }
                    default: {
                        this.log.appendMsg("WARNING: Pointer Chain format " + ptrFormat + " not processed yet!");
                    }
                }
                fixedAddressCount += (long)unchainedLocList.size();
                fixedAddresses.addAll(unchainedLocList);
            }
            ++index;
        }
        this.log.appendMsg("Fixed " + fixedAddressCount + " " + ptrFormat.getName() + " chained pointers.");
        return fixedAddresses;
    }

    private void processPointerChain(DyldChainedFixupHeader chainHeader, List<Address> unchainedLocList, DyldChainedPtr.DyldChainType pointerFormat, long page, long nextOff, long auth_value_add) throws MemoryAccessException, CancelledException {
        long imageBaseOffset = this.program.getImageBase().getOffset();
        Address chainStart = this.memory.getProgram().getLanguage().getDefaultSpace().getAddress(page);
        byte[] origBytes = new byte[8];
        long next = -1L;
        boolean start = true;
        while (next != 0L) {
            long chainValue;
            this.monitor.checkCanceled();
            Address chainLoc = chainStart.add(nextOff);
            long newChainValue = chainValue = DyldChainedPtr.getChainValue(this.memory, chainLoc, pointerFormat);
            boolean isAuthenticated = DyldChainedPtr.isAuthenticated(pointerFormat, chainValue);
            boolean isBound = DyldChainedPtr.isBound(pointerFormat, chainValue);
            String symName = null;
            if (isAuthenticated && !isBound) {
                long offsetFromSharedCacheBase = DyldChainedPtr.getTarget(pointerFormat, chainValue);
                newChainValue = imageBaseOffset + offsetFromSharedCacheBase + auth_value_add;
            } else if (!isAuthenticated && isBound) {
                int chainOrdinal = (int)DyldChainedPtr.getOrdinal(pointerFormat, chainValue);
                long addend = DyldChainedPtr.getAddend(pointerFormat, chainValue);
                DyldChainedImports chainedImports = chainHeader.getChainedImports();
                DyldChainedImport chainedImport = chainedImports.getChainedImport(chainOrdinal);
                symName = chainedImport.getName();
                List globalSymbols = this.program.getSymbolTable().getGlobalSymbols(symName);
                if (globalSymbols.size() == 1) {
                    newChainValue = ((Symbol)globalSymbols.get(0)).getAddress().getOffset();
                }
                newChainValue += addend;
            } else if (isAuthenticated && isBound) {
                int chainOrdinal = (int)DyldChainedPtr.getOrdinal(pointerFormat, chainValue);
                DyldChainedImports chainedImports = chainHeader.getChainedImports();
                DyldChainedImport chainedImport = chainedImports.getChainedImport(chainOrdinal);
                symName = chainedImport.getName();
                List globalSymbols = this.program.getSymbolTable().getGlobalSymbols(symName);
                if (globalSymbols.size() == 1) {
                    newChainValue = ((Symbol)globalSymbols.get(0)).getAddress().getOffset();
                }
                newChainValue += auth_value_add;
            } else {
                newChainValue = DyldChainedPtr.getTarget(pointerFormat, chainValue);
                newChainValue += imageBaseOffset;
            }
            if (!start || this.program.getRelocationTable().getRelocation(chainLoc) == null) {
                this.addRelocationTableEntry(chainLoc, (start ? 32768 : 16384) | (isAuthenticated ? 4 : 0) | (isBound ? 2 : 0) | 1, newChainValue, origBytes, symName);
                DyldChainedPtr.setChainValue(this.memory, chainLoc, pointerFormat, newChainValue);
            }
            unchainedLocList.add(chainLoc);
            start = false;
            next = DyldChainedPtr.getNext(pointerFormat, chainValue);
            nextOff += next * DyldChainedPtr.getStride(pointerFormat);
        }
    }

    private void addRelocationTableEntry(Address chainLoc, int type, long chainValue, byte[] origBytes, String name) throws MemoryAccessException {
        if (this.shouldAddRelocationEntries) {
            this.memory.getBytes(chainLoc, origBytes);
            this.program.getRelocationTable().add(chainLoc, type, new long[]{chainValue}, origBytes, name);
        }
    }

    private List<Address> processPointerChain(Address chainStart, long nextOffSize) throws MemoryAccessException {
        ArrayList<Address> fixedAddresses = new ArrayList<Address>();
        while (!this.monitor.isCancelled()) {
            long chainValue = this.memory.getLong(chainStart);
            this.fixupPointer(chainStart, chainValue);
            fixedAddresses.add(chainStart);
            long nextValueOff = (chainValue >> 51 & 0x7FFL) * nextOffSize;
            if (nextValueOff == 0L) break;
            chainStart = chainStart.add(nextValueOff);
        }
        return fixedAddresses;
    }

    private void fixupPointer(Address pointerAddr, long pointerValue) throws MemoryAccessException {
        long BIT63 = Long.MIN_VALUE;
        long BIT62 = 0x4000000000000000L;
        if ((pointerValue & 0x4000000000000000L) != 0L) {
            // empty if block
        }
        long fixedPointerValue = 0L;
        long fixedPointerType = 0L;
        if ((pointerValue & Long.MIN_VALUE) != 0L) {
            long pacMod;
            fixedPointerType = pacMod = pointerValue >> 32 & 0xFFFFL;
            fixedPointerValue = this.program.getImageBase().getOffset() + (pointerValue & 0xFFFFFFFFL);
        } else {
            fixedPointerValue = pointerValue << 13 & 0xFF00000000000000L | pointerValue & 0x7FFFFFFFFFFL;
            if ((pointerValue & 0x40000000000L) != 0L) {
                fixedPointerValue |= 0xFFFC0000000000L;
            }
        }
        byte[] origBytes = new byte[8];
        this.memory.getBytes(pointerAddr, origBytes);
        this.program.getRelocationTable().add(pointerAddr, (int)fixedPointerType, new long[]{fixedPointerValue}, origBytes, null);
        this.memory.setLong(pointerAddr, fixedPointerValue);
    }

    private class PrelinkMachoInfo
    implements Comparable<PrelinkMachoInfo> {
        private Address headerAddr;
        private MachHeader header;
        private String name;

        public PrelinkMachoInfo(ByteProvider provider, long offset, Address headerAddr, PrelinkMap prelink) throws Exception {
            this(provider, offset, headerAddr, "");
            String path;
            if (prelink != null && (path = prelink.getPrelinkBundlePath()) != null) {
                this.name = new File(path).getName();
            }
        }

        public PrelinkMachoInfo(ByteProvider provider, long fileOffset, Address headerAddr, String kextName) throws Exception {
            this.headerAddr = headerAddr;
            this.header = MachHeader.createMachHeader((GenericFactory)MessageLogContinuesFactory.create((MessageLog)MachoPrelinkProgramBuilder.this.log), provider, fileOffset, false);
            this.header.parse();
            this.headerAddr = headerAddr;
            this.name = kextName;
        }

        public void processMemoryBlocks() throws Exception {
            MachoPrelinkProgramBuilder.this.processMemoryBlocks(this.header, this.name, true, false);
        }

        public void markupHeaders() throws Exception {
            MachoPrelinkProgramBuilder.this.markupHeaders(this.header, this.headerAddr);
            if (!this.name.isEmpty()) {
                MachoPrelinkProgramBuilder.this.listing.setComment(this.headerAddr, 3, this.name);
            }
        }

        public void addToProgramTree(PrelinkMachoInfo next) throws Exception {
            if (!this.name.isEmpty()) {
                ProgramFragment fragment = MachoPrelinkProgramBuilder.this.listing.getDefaultRootModule().createFragment(this.name);
                if (next != null) {
                    fragment.move(this.headerAddr, next.headerAddr.subtract(1L));
                } else {
                    for (Section section : MachoPrelinkProgramBuilder.this.machoHeader.getAllSections()) {
                        Address sectionAddr = MachoPrelinkProgramBuilder.this.space.getAddress(section.getAddress());
                        if (this.headerAddr.compareTo((Object)sectionAddr) < 0 || this.headerAddr.compareTo((Object)sectionAddr.add(section.getSize() - 1L)) > 0) continue;
                        fragment.move(this.headerAddr, sectionAddr.add(section.getSize() - 1L));
                    }
                }
            }
        }

        @Override
        public int compareTo(PrelinkMachoInfo o) {
            return this.headerAddr.compareTo((Object)o.headerAddr);
        }
    }
}

