/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_SymbolTable;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_Module
implements StructConverter {
    private ObjectiveC1_State _state;
    private long _index;
    private int version;
    private int size;
    private String name;
    private ObjectiveC1_SymbolTable symbolTable;

    public ObjectiveC1_Module(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.version = reader.readNextInt();
        this.size = reader.readNextInt();
        this.name = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        int symbolTableIndex = reader.readNextInt();
        if (symbolTableIndex != 0) {
            this.symbolTable = new ObjectiveC1_SymbolTable(state, reader.clone(symbolTableIndex));
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public ObjectiveC1_SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void applyTo() throws Exception {
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        try {
            DataUtilities.createData((Program)this._state.program, (Address)address, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
        }
        catch (Exception e) {
            Msg.warn((Object)this, (Object)("Could not create " + dt.getName() + " @" + address));
        }
        if (this.symbolTable != null) {
            this.symbolTable.applyTo();
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_module", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "size", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ObjectiveC1_SymbolTable.toGenericDataType(), (int)this._state.pointerSize), "symtab", null);
        return struct;
    }
}

