/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Class;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_PropertyList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_ProtocolList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Category
implements StructConverter {
    public static final String NAME = "category_t";
    private ObjectiveC2_State _state;
    private long _index;
    private String name;
    private ObjectiveC2_Class cls;
    private ObjectiveC2_MethodList instanceMethods;
    private ObjectiveC2_MethodList classMethods;
    private ObjectiveC2_ProtocolList protocols;
    private ObjectiveC2_PropertyList instanceProperties;

    public ObjectiveC2_Category(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.readName(reader);
        this.readClass(reader);
        if (this.cls != null && this.cls.getISA() != null) {
            this.readInstanceMethods(reader);
            this.readClassMethods(reader);
            this.readProtocols(reader);
            this.readInstanceProperties(reader);
        }
    }

    public long getIndex() {
        return this._index;
    }

    public String getName() {
        return this.name;
    }

    public ObjectiveC2_Class getCls() {
        return this.cls;
    }

    public ObjectiveC2_MethodList getInstanceMethods() {
        return this.instanceMethods;
    }

    public ObjectiveC2_MethodList getClassMethods() {
        return this.classMethods;
    }

    public ObjectiveC2_ProtocolList getProtocols() {
        return this.protocols;
    }

    public ObjectiveC2_PropertyList getInstanceProperties() {
        return this.instanceProperties;
    }

    private void readName(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            this.name = reader.readAsciiString(index);
        }
    }

    private void readClass(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (this._state.classIndexMap.containsKey(index)) {
            this.cls = this._state.classIndexMap.get(index);
            return;
        }
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.cls = new ObjectiveC2_Class(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceMethods(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceMethods = new ObjectiveC2_MethodList(this._state, reader, ObjectiveC_MethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readClassMethods(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.classMethods = new ObjectiveC2_MethodList(this._state, reader, ObjectiveC_MethodType.CLASS);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readProtocols(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.protocols = new ObjectiveC2_ProtocolList(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceProperties(BinaryReader reader) throws IOException {
        long index = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceProperties = new ObjectiveC2_PropertyList(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NAME);
        if (this.cls == null) {
            buffer.append("<no_class>");
        }
        StructureDataType struct = new StructureDataType(buffer.toString(), 0);
        struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "name", null);
        if (this.cls == null) {
            struct.add((DataType)new PointerDataType(VOID), this._state.pointerSize, "cls", null);
        } else {
            struct.add((DataType)new PointerDataType(this.cls.toDataType()), this._state.pointerSize, "cls", null);
        }
        struct.add((DataType)new PointerDataType(ObjectiveC2_MethodList.toGenericDataType()), this._state.pointerSize, "instanceMethods", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_MethodList.toGenericDataType()), this._state.pointerSize, "classMethods", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_ProtocolList.toGenericDataType(this._state)), this._state.pointerSize, "protocols", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_PropertyList.toGenericDataType()), this._state.pointerSize, "instanceProperties", null);
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo() throws Exception {
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this.getIndex());
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace categoryNamespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", NAME);
            ObjectiveC1_Utilities.createSymbol(this._state.program, categoryNamespace, this.getName(), address);
        }
        catch (Exception categoryNamespace) {
            // empty catch block
        }
        Object string = null;
        try {
            string = this.cls.getData().getName() + "_" + this.name + "_";
        }
        catch (Exception e) {
            string = this.name;
        }
        Namespace namespace = ObjectiveC1_Utilities.createNamespace(this._state.program, new String[]{"objc", "Categories", string});
        if (this.cls != null) {
            this.cls.applyTo();
        }
        if (this.instanceMethods != null) {
            this.instanceMethods.applyTo(namespace);
        }
        if (this.classMethods != null) {
            this.classMethods.applyTo(namespace);
        }
        if (this.protocols != null) {
            this.protocols.applyTo(namespace);
        }
        if (this.instanceProperties != null) {
            this.instanceProperties.applyTo(namespace);
        }
    }
}

