/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class FixedVirtualMemoryFileCommand
extends LoadCommand {
    private LoadCommandString name;
    private int header_addr;

    public static FixedVirtualMemoryFileCommand createFixedVirtualMemoryFileCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        FixedVirtualMemoryFileCommand command = (FixedVirtualMemoryFileCommand)reader.getFactory().create(FixedVirtualMemoryFileCommand.class, new Object[0]);
        command.initFixedVirtualMemoryFileCommand(reader);
        return command;
    }

    private void initFixedVirtualMemoryFileCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.initLoadCommand(reader);
    }

    public String getPathname() {
        return this.name.getString();
    }

    public int getHeaderAddress() {
        return this.header_addr;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.name.toDataType(), "name", null);
        struct.add(DWORD, "header_addr", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "fvmfile_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        if (isBinary) {
            try {
                this.createFragment(api, baseAddress, parentModule);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
            Address addr = baseAddress.getNewAddress(this.getStartIndex());
            try {
                api.createData(addr, this.toDataType());
            }
            catch (Exception e) {
                log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
            }
            try {
                int strLen = this.getCommandSize() - this.name.getOffset();
                Address strAddr = addr.add((long)this.name.getOffset());
                api.createAsciiString(strAddr, strLen);
            }
            catch (Exception e) {
                log.appendMsg("Unable to create load command string for " + this.getCommandName() + " - " + e.getMessage());
            }
        }
    }
}

