/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupHeader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldChainedImport
implements StructConverter {
    private static final int DYLD_CHAINED_IMPORT = 1;
    private static final int DYLD_CHAINED_IMPORT_ADDEND = 2;
    private static final int DYLD_CHAINED_IMPORT_ADDEND64 = 3;
    private int imports_format;
    private int lib_ordinal;
    private boolean weak_import;
    private long name_offset;
    private long addend;
    private String symbolName;

    static DyldChainedImport createDyldChainedImport(FactoryBundledWithBinaryReader reader, DyldChainedFixupHeader cfh, int imports_format) throws IOException {
        DyldChainedImport dyldChainedImport = (DyldChainedImport)reader.getFactory().create(DyldChainedImport.class, new Object[0]);
        dyldChainedImport.initDyldChainedImport(reader, cfh, imports_format);
        return dyldChainedImport;
    }

    private void initDyldChainedImport(FactoryBundledWithBinaryReader reader, DyldChainedFixupHeader cfh, int format) throws IOException {
        this.imports_format = format;
        switch (format) {
            case 1: {
                int ival = reader.readNextInt();
                this.lib_ordinal = ival & 0xFF;
                this.weak_import = (ival >> 8 & 1) == 1;
                this.name_offset = ival >> 9 & 0x7FFFFF;
                break;
            }
            case 2: {
                int ival = reader.readNextInt();
                this.lib_ordinal = ival & 0xFF;
                this.weak_import = (ival >> 8 & 1) == 1;
                this.name_offset = ival >> 9 & 0x7FFFFF;
                this.addend = reader.readNextInt();
                break;
            }
            case 3: {
                long ival = reader.readNextLong();
                this.lib_ordinal = (int)(ival & 0xFFFFL);
                this.weak_import = (ival >> 8 & 1L) == 1L;
                this.name_offset = ival >> 32 & 0xFFFFFFFFFFFFFFFFL;
                this.addend = reader.readNextLong();
                break;
            }
            default: {
                throw new IOException("Bad Chained import format: " + format);
            }
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType dt = new StructureDataType("dyld_chained_import", 0);
        try {
            switch (this.imports_format) {
                case 1: {
                    dt.addBitField(DWORD, 8, "lib_ordinal", "ordinal in imports");
                    dt.addBitField(DWORD, 1, "weak_import", null);
                    dt.addBitField(DWORD, 23, "name_offset", null);
                    break;
                }
                case 2: {
                    dt.addBitField(DWORD, 8, "lib_ordinal", "ordinal in imports");
                    dt.addBitField(DWORD, 1, "weak_import", null);
                    dt.addBitField(DWORD, 23, "name_offset", null);
                    dt.add(DWORD, "addend", null);
                    break;
                }
                case 3: {
                    dt.addBitField(QWORD, 16, "lib_ordinal", "ordinal in imports");
                    dt.addBitField(QWORD, 1, "weak_import", null);
                    dt.addBitField(QWORD, 15, "reserved", null);
                    dt.addBitField(QWORD, 32, "name_offset", null);
                    dt.add(QWORD, "addend", null);
                    break;
                }
                default: {
                    throw new IOException("Bad Chained import format: " + this.imports_format);
                }
            }
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            // empty catch block
        }
        dt.setCategoryPath(new CategoryPath("/MachO"));
        return dt;
    }

    public int getLibOrdinal() {
        return this.lib_ordinal;
    }

    public boolean isWeakImport() {
        return this.weak_import;
    }

    public long getNameOffset() {
        return this.name_offset;
    }

    public long getAddend() {
        return this.addend;
    }

    public String getName() {
        return this.symbolName;
    }

    public void initString(FactoryBundledWithBinaryReader reader) throws IOException {
        this.symbolName = reader.readNextNullTerminatedAsciiString();
    }
}

