/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FactoryStructureDataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GnuDebugLinkSection
extends FactoryStructureDataType {
    public static final String DEBUG_LINK_SECTION_NAME = ".gnu_debuglink";
    private long sectionSize;

    public static GnuDebugLinkSectionValues fromProgram(Program program) {
        GnuDebugLinkSectionValues gnuDebugLinkSectionValues;
        block9: {
            MemoryBlock debugLinkSection = program.getMemory().getBlock(DEBUG_LINK_SECTION_NAME);
            if (debugLinkSection == null) {
                return null;
            }
            ByteProvider bp = MemoryByteProvider.createMemoryBlockByteProvider(program.getMemory(), debugLinkSection);
            try {
                BinaryReader br = new BinaryReader(bp, !program.getMemory().isBigEndian());
                String filename = br.readNextAsciiString();
                br.setPointerIndex(NumericUtilities.getUnsignedAlignedValue((long)br.getPointerIndex(), (long)4L));
                int crc = br.readNextInt();
                gnuDebugLinkSectionValues = new GnuDebugLinkSectionValues(filename, crc);
                if (bp == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (bp != null) {
                        try {
                            bp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            bp.close();
        }
        return gnuDebugLinkSectionValues;
    }

    public GnuDebugLinkSection(DataTypeManager dtm, long sectionSize) {
        super("Gnu_DebugLink", dtm);
        this.sectionSize = sectionSize;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.dataMgr) {
            return this;
        }
        return new GnuDebugLinkSection(dtm, this.sectionSize);
    }

    protected void populateDynamicStructure(MemBuffer buf, Structure es) {
        StringDataInstance filenameStr = StringDataInstance.getStringDataInstance((DataType)StringDataType.dataType, (MemBuffer)buf, (Settings)SettingsImpl.NO_SETTINGS, (int)-1);
        int filenameLen = filenameStr.getStringLength();
        if (filenameLen <= 0 || (long)(filenameLen + 4) > this.sectionSize) {
            return;
        }
        filenameLen = (int)NumericUtilities.getUnsignedAlignedValue((long)filenameLen, (long)4L);
        es.add((DataType)StringDataType.dataType, filenameLen, "filename", "Debug file name");
        es.add(StructConverter.DWORD, "crc", null);
    }

    protected Structure setCategoryPath(Structure struct, MemBuffer buf) {
        try {
            struct.setCategoryPath(new CategoryPath("/ELF"));
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        return struct;
    }

    public static class GnuDebugLinkSectionValues {
        private String filename;
        private int crc;

        public GnuDebugLinkSectionValues(String filename, int crc) {
            this.filename = filename;
            this.crc = crc;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getCrc() {
            return this.crc;
        }
    }
}

