/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.framework.model.DomainObjectException;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

class SearchTask
extends Task {
    private Searcher textSearcher;
    private Navigatable navigatable;
    private ProgramLocation loc = null;
    private boolean isCanceled;
    private TaskMonitor taskMonitor;
    private Program program;

    SearchTask(Navigatable navigatable, Program program, Searcher textSearcher) {
        super("Searching Program Text", true, true, false);
        this.navigatable = navigatable;
        this.textSearcher = textSearcher;
        this.program = program;
    }

    public void run(TaskMonitor monitor) {
        block4: {
            try {
                monitor.setMessage("Searching...");
                this.textSearcher.setMonitor(monitor);
                this.taskMonitor = monitor;
                if (this.isCanceled) {
                    monitor.cancel();
                } else {
                    this.loc = this.textSearcher.search();
                }
            }
            catch (Exception e) {
                if (e instanceof DomainObjectException) break block4;
                Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Error searching", (Throwable)e);
            }
        }
    }

    Searcher getTextSearcher() {
        return this.textSearcher;
    }

    Navigatable getNavigatable() {
        return this.navigatable;
    }

    ProgramLocation getSearchLocation() {
        return this.loc;
    }

    public void cancel() {
        super.cancel();
        this.isCanceled = true;
    }

    public Program getProgram() {
        return this.program;
    }
}

