/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GComboBox;
import docking.widgets.dialogs.StringChoices;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DataSettingsDialog
extends DialogComponentProvider {
    private static final int WIDTH = 350;
    private static final int HEIGHT = 150;
    private static String[] BOOLEAN_CHOICES = new String[]{"yes", "no"};
    private static String NO_CHOICE = "";
    private String name;
    private Data data;
    private ProgramSelection selection;
    private DataType dataType;
    private DataTypeComponent dtc;
    private SettingsDefinition[] settingsDefs;
    private Settings defaultSettings;
    private SettingsImpl settings;
    private boolean editingDefaults;
    private SettingsTableModel settingsTableModel;
    private GTable settingsTable;
    private boolean appliedSettings;
    private Program program;

    public DataSettingsDialog(Program program, ProgramSelection sel) throws CancelledException {
        super("Data Settings", true, false, true, false);
        this.program = program;
        this.selection = sel;
        this.settingsDefs = this.getCommonSettings();
        this.settings = new SettingsImpl();
        this.setHelpLocation(new HelpLocation("DataPlugin", "Data_Settings_OnSelection"));
        this.buildPanel();
    }

    public DataSettingsDialog(Program program, Data data) {
        super("Data Settings", true, false, true, false);
        DataType pdt;
        this.data = data;
        this.program = program;
        this.dataType = data.getDataType();
        this.settingsDefs = this.dataType.getSettingsDefinitions();
        Data pdata = data.getParent();
        if (pdata != null && (pdt = pdata.getBaseDataType()) instanceof Composite) {
            Composite comp = (Composite)pdt;
            this.dtc = comp.getComponent(data.getComponentIndex());
            this.setHelpLocation(new HelpLocation("DataPlugin", "SettingsOnStructureComponents"));
        }
        if (this.dtc == null) {
            this.setHelpLocation(new HelpLocation("DataPlugin", "Data_Settings"));
        }
        this.settings = new SettingsImpl((Settings)data);
        this.defaultSettings = data.getDefaultSettings();
        this.settings.setDefaultSettings(this.defaultSettings);
        this.buildPanel();
    }

    public DataSettingsDialog(Program program, DataType dataType) {
        super("Data Settings", true, false, true, false);
        this.dataType = dataType;
        this.program = program;
        this.editingDefaults = true;
        this.settingsDefs = dataType.getSettingsDefinitions();
        this.settings = new SettingsImpl(dataType.getDefaultSettings());
        this.defaultSettings = dataType.getDefaultSettings();
        this.buildPanel();
        this.setHelpLocation(new HelpLocation("DataPlugin", "Default_Data_Settings"));
    }

    DataSettingsDialog(Program program, DataTypeComponent dtc) {
        super("Data Settings", true, false, true, false);
        this.dtc = dtc;
        this.program = program;
        this.editingDefaults = true;
        this.settingsDefs = dtc.getDataType().getSettingsDefinitions();
        this.settings = new SettingsImpl(dtc.getDefaultSettings());
        this.defaultSettings = dtc.getDefaultSettings();
        this.buildPanel();
        this.setHelpLocation(new HelpLocation("DataPlugin", "SettingsOnStructureComponents"));
    }

    GTable getSettingsTable() {
        return this.settingsTable;
    }

    SettingsTableModel getSettingsTableModel() {
        return this.settingsTableModel;
    }

    public void dispose() {
        this.close();
        this.program = null;
        this.data = null;
        this.dataType = null;
        this.dtc = null;
        this.settingsDefs = null;
        this.defaultSettings = null;
        this.settings = null;
    }

    boolean hasSettings() {
        return this.settingsDefs.length != 0;
    }

    private String constructTitle() {
        if (this.selection != null) {
            return "Common Settings for Selected Data";
        }
        StringBuffer nameBuf = new StringBuffer();
        if (this.data == null) {
            nameBuf.append("Default ");
        }
        if (this.dtc != null) {
            nameBuf.append(this.dtc.getDataType().getDisplayName());
            nameBuf.append(" Settings (");
            nameBuf.append(this.dtc.getParent().getDisplayName());
            nameBuf.append('.');
            String fname = this.dtc.getFieldName();
            if (fname == null) {
                fname = this.dtc.getDefaultFieldName();
            }
            nameBuf.append(fname);
            nameBuf.append(')');
        } else {
            nameBuf.append(this.dataType.getDisplayName());
            nameBuf.append(" Settings");
        }
        if (this.data != null) {
            nameBuf.append(" at ");
            nameBuf.append(this.data.getMinAddress().toString());
        }
        return nameBuf.toString();
    }

    private void buildPanel() {
        this.name = this.constructTitle();
        this.setTitle(this.name);
        this.addWorkPanel(this.buildWorkPanel());
        this.addButtons();
    }

    private void addButtons() {
        this.addOKButton();
        JButton newApplyButton = new JButton("Apply");
        newApplyButton.addActionListener(e -> this.applySettings());
        this.addButton(newApplyButton);
        this.addCancelButton();
    }

    private JPanel buildWorkPanel() {
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.settingsTableModel = new SettingsTableModel(this.settingsDefs);
        this.settingsTableModel.addTableModelListener(e -> {
            this.appliedSettings = false;
        });
        this.settingsTable = new GhidraTable((TableModel)((Object)this.settingsTableModel));
        this.settingsTable.setAutoscrolls(true);
        this.settingsTable.setRowSelectionAllowed(false);
        this.settingsTable.setColumnSelectionAllowed(false);
        this.settingsTable.getTableHeader().setReorderingAllowed(false);
        this.settingsTable.setColumnHeaderPopupEnabled(false);
        this.settingsTable.setUserSortingEnabled(false);
        this.settingsTable.setDefaultRenderer(Settings.class, (TableCellRenderer)new DefaultTableCellRenderer());
        this.settingsTable.setDefaultEditor(Settings.class, (TableCellEditor)new SettingsEditor());
        JScrollPane scrollpane = new JScrollPane((Component)this.settingsTable);
        scrollpane.setPreferredSize(new Dimension(350, 150));
        workPanel.add((Component)scrollpane, "Center");
        return workPanel;
    }

    protected void cancelCallback() {
        this.close();
        this.dispose();
    }

    protected void okCallback() {
        this.applySettings();
        this.close();
        this.dispose();
    }

    private SettingsDefinition[] getCommonSettings() throws CancelledException {
        CommonSettingsAccumulator myTask = new CommonSettingsAccumulator();
        new TaskLauncher((Task)myTask, (Component)this.getComponent());
        if (myTask.cancelled) {
            throw new CancelledException();
        }
        return myTask.defsArray;
    }

    private static void removeMissingDefinitions(List<Class<? extends SettingsDefinition>> defClasses, List<SettingsDefinition> defs, SettingsDefinition[] checkDefs) {
        for (int i = defClasses.size() - 1; i >= 0; --i) {
            Class<? extends SettingsDefinition> c = defClasses.get(i);
            boolean found = false;
            for (SettingsDefinition checkDef : checkDefs) {
                if (!c.isAssignableFrom(checkDef.getClass())) continue;
                found = true;
                break;
            }
            if (found) continue;
            defClasses.remove(i);
            defs.remove(i);
        }
    }

    private void applyCommonSettings() {
        InteriorSelection interiorSelection = this.selection.getInteriorSelection();
        if (interiorSelection == null) {
            CodeUnitIterator codeUnits = this.program.getListing().getCodeUnits((AddressSetView)this.selection, true);
            while (codeUnits.hasNext()) {
                CodeUnit cu = codeUnits.next();
                if (!(cu instanceof Data) || !((Data)cu).isDefined()) continue;
                this.applySettingsToData((Data)cu);
            }
            return;
        }
        int[] from = interiorSelection.getFrom().getComponentPath();
        int[] to = interiorSelection.getTo().getComponentPath();
        Data dataComp = DataPlugin.getDataUnit(this.program, this.selection.getMinAddress(), from);
        if (dataComp == null) {
            return;
        }
        Data parent = dataComp.getParent();
        int fromIndex = from[from.length - 1];
        int toIndex = to[to.length - 1];
        for (int i = fromIndex; i <= toIndex && (dataComp = parent.getComponent(i)) != null; ++i) {
            DataType dt = dataComp.getDataType();
            if (dt == DataType.DEFAULT) continue;
            this.applySettingsToData(dataComp);
        }
    }

    private void applySettingsToData(Data dataTarget) {
        if (this.appliedSettings) {
            return;
        }
        for (SettingsDefinition settingsDef : this.settingsDefs) {
            int s;
            EnumSettingsDefinition def;
            if (this.selection != null && this.settings.getValue(settingsDef.getName()) == null) continue;
            if (settingsDef instanceof EnumSettingsDefinition) {
                def = (EnumSettingsDefinition)settingsDef;
                s = def.getChoice((Settings)this.settings);
                if (this.defaultSettings != null && s == def.getChoice(this.defaultSettings)) {
                    def.clear((Settings)dataTarget);
                    continue;
                }
                def.setChoice((Settings)dataTarget, s);
                continue;
            }
            if (settingsDef instanceof BooleanSettingsDefinition) {
                def = (BooleanSettingsDefinition)settingsDef;
                s = def.getValue((Settings)this.settings) ? 1 : 0;
                if (this.defaultSettings != null && s == def.getValue(this.defaultSettings)) {
                    def.clear((Settings)dataTarget);
                    continue;
                }
                def.setValue((Settings)dataTarget, s != 0);
                continue;
            }
            throw new AssertException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySettings() {
        int txId = this.program.startTransaction(this.name);
        boolean success = true;
        try {
            if (this.selection != null) {
                this.applyCommonSettings();
                this.appliedSettings = true;
            } else if (this.data != null) {
                this.applySettingsToData(this.data);
                this.appliedSettings = true;
            } else {
                Settings origDefSettings = null;
                origDefSettings = this.dataType != null ? this.dataType.getDefaultSettings() : this.dtc.getDefaultSettings();
                for (SettingsDefinition settingsDef : this.settingsDefs) {
                    settingsDef.copySetting((Settings)this.settings, origDefSettings);
                }
            }
            success = true;
        }
        finally {
            this.program.endTransaction(txId, success);
        }
    }

    private StringChoices getChoices(EnumSettingsDefinition def) {
        String[] choices = def.getDisplayChoices((Settings)this.settings);
        int currentChoice = def.getChoice((Settings)this.settings);
        if (this.selection != null) {
            choices = this.addNoChoice(choices);
            currentChoice = this.settings.getValue(def.getName()) == null ? 0 : ++currentChoice;
        }
        StringChoices choicesEnum = new StringChoices(choices);
        choicesEnum.setSelectedValue(currentChoice);
        return choicesEnum;
    }

    private StringChoices getChoices(BooleanSettingsDefinition def) {
        int currentChoice;
        String[] choices = BOOLEAN_CHOICES;
        int n = currentChoice = def.getValue((Settings)this.settings) ? 0 : 1;
        if (this.selection != null) {
            choices = this.addNoChoice(choices);
            currentChoice = this.settings.getValue(def.getName()) == null ? 0 : ++currentChoice;
        }
        StringChoices choicesEnum = new StringChoices(choices);
        choicesEnum.setSelectedValue(currentChoice);
        return choicesEnum;
    }

    private void setChoice(Object value, EnumSettingsDefinition def) {
        StringChoices choices = (StringChoices)value;
        int selectedChoice = choices.getSelectedValueIndex();
        if (this.selection != null) {
            if (selectedChoice == 0) {
                this.settings.clearSetting(def.getName());
                return;
            }
            --selectedChoice;
        }
        def.setChoice((Settings)this.settings, selectedChoice);
        if (this.selection != null && this.settings.getValue(def.getName()) == null) {
            this.settings.setValue(def.getName(), (Object)def.getChoice((Settings)this.settings));
        }
    }

    private void setChoice(Object value, BooleanSettingsDefinition def) {
        StringChoices choices = (StringChoices)value;
        int selectedChoice = choices.getSelectedValueIndex();
        if (this.selection != null) {
            if (selectedChoice == 0) {
                this.settings.clearSetting(def.getName());
                return;
            }
            --selectedChoice;
        }
        def.setValue((Settings)this.settings, selectedChoice == 0);
        if (this.selection != null && this.settings.getValue(def.getName()) == null) {
            this.settings.setValue(def.getName(), (Object)def.getValue((Settings)this.settings));
        }
    }

    private String[] addNoChoice(String[] choices) {
        String[] newChoices = new String[choices.length + 1];
        newChoices[0] = NO_CHOICE;
        System.arraycopy(choices, 0, newChoices, 1, choices.length);
        return newChoices;
    }

    class SettingsEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static final int ENUM = 0;
        static final int BOOLEAN = 1;
        private int mode;
        private GComboBox<String> comboBox = new GComboBox();

        SettingsEditor() {
            this.comboBox.addItemListener(e -> this.fireEditingStopped());
        }

        GComboBox<String> getComboBox() {
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            switch (this.mode) {
                case 0: {
                    return this.getComboBoxEnum();
                }
                case 1: {
                    return this.getComboBoxEnum();
                }
            }
            throw new AssertException();
        }

        private StringChoices getComboBoxEnum() {
            String[] items = new String[this.comboBox.getItemCount()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (String)this.comboBox.getItemAt(i);
            }
            StringChoices enuum = new StringChoices(items);
            enuum.setSelectedValue(this.comboBox.getSelectedIndex());
            return enuum;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof StringChoices || value instanceof Boolean) {
                this.initComboBox((StringChoices)value);
                return this.comboBox;
            }
            throw new AssertException("SettingsEditor: " + value.getClass().getName() + " not supported");
        }

        private void initComboBox(StringChoices enuum) {
            String[] items;
            this.mode = 0;
            this.comboBox.removeAllItems();
            for (String item : items = enuum.getValues()) {
                this.comboBox.addItem((Object)item);
            }
            this.comboBox.setSelectedIndex(enuum.getSelectedValueIndex());
        }
    }

    private class SettingsTableModel
    extends AbstractSortedTableModel<SettingsRowObject> {
        private List<SettingsRowObject> rows = new ArrayList<SettingsRowObject>();

        SettingsTableModel(SettingsDefinition[] settingsDefs) {
            for (SettingsDefinition sd : settingsDefs) {
                this.rows.add(new SettingsRowObject(sd));
            }
        }

        public List<SettingsRowObject> getModelData() {
            return this.rows;
        }

        public String getName() {
            return "Settings Definition Model";
        }

        public boolean isSortable(int columnIndex) {
            return columnIndex == 0;
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public int getColumnCount() {
            return DataSettingsDialog.this.selection != null || DataSettingsDialog.this.editingDefaults ? 2 : 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Settings";
                }
                case 2: {
                    return "Use Default";
                }
            }
            return null;
        }

        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Settings.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        public Object getColumnValueForRow(SettingsRowObject t, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return t.getName();
                }
                case 1: {
                    return t.getSettingsChoices();
                }
                case 2: {
                    return t.useDefault();
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            SettingsRowObject rowObject = this.rows.get(row);
            switch (col) {
                case 1: {
                    if (!rowObject.setSettingsChoice(value)) break;
                    this.fireTableDataChanged();
                    break;
                }
                case 2: {
                    if (!((Boolean)value).booleanValue()) break;
                    rowObject.clear(DataSettingsDialog.this.settings);
                    this.fireTableDataChanged();
                }
            }
        }
    }

    class SettingsRowObject {
        private SettingsDefinition definition;

        SettingsRowObject(SettingsDefinition definition) {
            this.definition = definition;
        }

        public String getName() {
            return this.definition.getName();
        }

        Object getSettingsChoices() {
            if (this.definition instanceof EnumSettingsDefinition) {
                StringChoices choices = DataSettingsDialog.this.getChoices((EnumSettingsDefinition)this.definition);
                return choices;
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                StringChoices choices = DataSettingsDialog.this.getChoices((BooleanSettingsDefinition)this.definition);
                return choices;
            }
            return "<Unsupported>";
        }

        boolean useDefault() {
            if (this.definition instanceof EnumSettingsDefinition) {
                EnumSettingsDefinition def = (EnumSettingsDefinition)this.definition;
                return def.getChoice((Settings)DataSettingsDialog.this.settings) == def.getChoice(DataSettingsDialog.this.defaultSettings);
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                BooleanSettingsDefinition def = (BooleanSettingsDefinition)this.definition;
                return def.getValue((Settings)DataSettingsDialog.this.settings) == def.getValue(DataSettingsDialog.this.defaultSettings);
            }
            return false;
        }

        boolean setSettingsChoice(Object value) {
            if (this.definition instanceof EnumSettingsDefinition) {
                DataSettingsDialog.this.setChoice(value, (EnumSettingsDefinition)this.definition);
                return true;
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                DataSettingsDialog.this.setChoice(value, (BooleanSettingsDefinition)this.definition);
                return true;
            }
            return false;
        }

        void clear(SettingsImpl s) {
            this.definition.clear((Settings)s);
        }
    }

    private class CommonSettingsAccumulator
    extends Task {
        boolean cancelled;
        SettingsDefinition[] defsArray;

        CommonSettingsAccumulator() {
            super("Accumulating Data Settings", true, false, true);
            this.cancelled = false;
            this.defsArray = new SettingsDefinition[0];
        }

        public void run(TaskMonitor monitor) {
            InteriorSelection interiorSelection = DataSettingsDialog.this.selection.getInteriorSelection();
            if (interiorSelection != null) {
                this.accumulateInteriorSettingsDefinitions(interiorSelection, monitor);
            } else {
                this.accumulateDataSettingsDefinitions(monitor);
            }
        }

        private void accumulateDataSettingsDefinitions(TaskMonitor monitor) {
            ArrayList<Class<? extends SettingsDefinition>> defClasses = new ArrayList<Class<? extends SettingsDefinition>>();
            ArrayList<SettingsDefinition> defs = new ArrayList<SettingsDefinition>();
            Listing listing = DataSettingsDialog.this.program.getListing();
            DataIterator definedData = listing.getDefinedData((AddressSetView)DataSettingsDialog.this.selection, true);
            if (!definedData.hasNext()) {
                return;
            }
            Data d = definedData.next();
            for (SettingsDefinition def : d.getDataType().getSettingsDefinitions()) {
                defs.add(def);
                defClasses.add(def.getClass());
            }
            while (!defClasses.isEmpty() && definedData.hasNext()) {
                if (monitor.isCancelled()) {
                    this.cancelled = true;
                    return;
                }
                d = definedData.next();
                DataSettingsDialog.removeMissingDefinitions(defClasses, defs, d.getDataType().getSettingsDefinitions());
            }
            this.defsArray = new SettingsDefinition[defs.size()];
            defs.toArray(this.defsArray);
        }

        private void accumulateInteriorSettingsDefinitions(InteriorSelection interiorSelection, TaskMonitor monitor) {
            ArrayList<Class<? extends SettingsDefinition>> defClasses = null;
            ArrayList<SettingsDefinition> defs = null;
            int[] from = interiorSelection.getFrom().getComponentPath();
            int[] to = interiorSelection.getTo().getComponentPath();
            Data dataComp = DataPlugin.getDataUnit(DataSettingsDialog.this.program, DataSettingsDialog.this.selection.getMinAddress(), from);
            if (dataComp == null || from.length != to.length) {
                return;
            }
            Data parent = dataComp.getParent();
            int fromIndex = from[from.length - 1];
            int toIndex = to[to.length - 1];
            for (int i = fromIndex; i <= toIndex && (dataComp = parent.getComponent(i)) != null; ++i) {
                DataType dt = dataComp.getDataType();
                if (dt == DataType.DEFAULT) continue;
                SettingsDefinition[] settingsDefinitions = dt.getSettingsDefinitions();
                if (settingsDefinitions.length == 0) {
                    return;
                }
                if (defClasses == null) {
                    defClasses = new ArrayList<Class<? extends SettingsDefinition>>();
                    defs = new ArrayList<SettingsDefinition>();
                    for (SettingsDefinition def : settingsDefinitions) {
                        defs.add(def);
                        defClasses.add(def.getClass());
                    }
                    continue;
                }
                DataSettingsDialog.removeMissingDefinitions(defClasses, (List<SettingsDefinition>)defs, settingsDefinitions);
            }
            this.defsArray = new SettingsDefinition[defs.size()];
            defs.toArray(this.defsArray);
        }
    }
}

