/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.BuiltInSourceArchive;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.plugin.core.datamgr.util.DataTypeComparator;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.util.HelpLocation;
import ghidra.util.UniversalID;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreePath;

public class DefaultDataTypeManagerService
implements DataTypeManagerService {
    private Map<String, FileDataTypeManager> archiveMap = new HashMap<String, FileDataTypeManager>();
    private DataTypeManager builtInDataTypesManager = BuiltInDataTypeManager.getDataTypeManager();

    void dispose() {
        for (FileDataTypeManager dtfm : this.archiveMap.values()) {
            dtfm.close();
        }
        this.archiveMap.clear();
    }

    private FileDataTypeManager findOpenFileArchiveWithID(UniversalID universalID) {
        if (universalID == null) {
            return null;
        }
        for (FileDataTypeManager dtm : this.archiveMap.values()) {
            if (!universalID.equals((Object)dtm.getUniversalID()) || dtm.isClosed()) continue;
            return dtm;
        }
        return null;
    }

    @Override
    public synchronized DataTypeManager openDataTypeArchive(String archiveName) throws IOException, DuplicateIdException {
        ResourceFile archiveFile;
        if (this.archiveMap.containsKey(archiveName)) {
            FileDataTypeManager dtm = this.archiveMap.get(archiveName);
            if (!dtm.isClosed()) {
                return dtm;
            }
            this.archiveMap.remove(archiveName);
        }
        if ((archiveFile = DataTypeArchiveUtility.findArchiveFile(archiveName)) == null) {
            return null;
        }
        FileDataTypeManager fileDtm = FileDataTypeManager.openFileArchive((ResourceFile)archiveFile, (boolean)false);
        FileDataTypeManager existingDtm = this.findOpenFileArchiveWithID(fileDtm.getUniversalID());
        if (existingDtm != null) {
            fileDtm.close();
            throw new DuplicateIdException(fileDtm.getName(), existingDtm.getName());
        }
        this.archiveMap.put(archiveName, fileDtm);
        return fileDtm;
    }

    @Override
    public void closeArchive(DataTypeManager dtm) {
        String archiveName = null;
        Set<Map.Entry<String, FileDataTypeManager>> entries = this.archiveMap.entrySet();
        for (Map.Entry<String, FileDataTypeManager> entry : entries) {
            FileDataTypeManager manager = entry.getValue();
            if (!manager.equals(dtm)) continue;
            archiveName = entry.getKey();
            break;
        }
        if (archiveName != null) {
            FileDataTypeManager manager = this.archiveMap.get(archiveName);
            this.archiveMap.remove(archiveName);
            manager.close();
        }
    }

    @Override
    public DataTypeManager[] getDataTypeManagers() {
        ArrayList<FileDataTypeManager> dtmList = new ArrayList<FileDataTypeManager>();
        for (FileDataTypeManager dtm : this.archiveMap.values()) {
            if (dtm.isClosed()) continue;
            dtmList.add(dtm);
        }
        DataTypeManager[] managers = new DataTypeManager[dtmList.size()];
        dtmList.toArray(managers);
        return managers;
    }

    @Override
    public HelpLocation getEditorHelpLocation(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDataTypeManagerChangeListener(DataTypeManagerChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEditable(DataType dt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void edit(DataType dt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataTypeManager getBuiltInDataTypesManager() {
        return this.builtInDataTypesManager;
    }

    @Override
    public DataType getDataType(String filterText) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType(TreePath selectedTreeNode) {
        if (selectedTreeNode == null) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataType> getFavorites() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getRecentlyUsed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataType> getSortedDataTypeList() {
        List dataTypes = this.builtInDataTypesManager.getDataTypes(BuiltInSourceArchive.INSTANCE);
        dataTypes.sort(new DataTypeComparator());
        return dataTypes;
    }

    @Override
    public void removeDataTypeManagerChangeListener(DataTypeManagerChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataTypeSelected(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRecentlyUsed(DataType dt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getPossibleEquateNames(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Archive openArchive(File file, boolean acquireWriteLock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Archive openArchive(DataTypeArchive dataTypeArchive) {
        throw new UnsupportedOperationException();
    }
}

