/*
 * Decompiled with CFR 0.152.
 */
package help.validator.links;

import help.validator.links.InvalidLink;
import help.validator.model.HREF;
import java.nio.file.Path;

public abstract class InvalidHREFLink
implements InvalidLink {
    protected final HREF href;
    protected final String message;

    InvalidHREFLink(HREF href, String message) {
        this.href = href;
        this.message = message;
        if (Boolean.parseBoolean(System.getProperty("ghidra.help.failfast"))) {
            throw new RuntimeException(message + ": " + href);
        }
    }

    public HREF getHREF() {
        return this.href;
    }

    @Override
    public int identityHashCode() {
        return System.identityHashCode(this.href);
    }

    @Override
    public Path getSourceFile() {
        return this.href.getSourceFile();
    }

    @Override
    public int getLineNumber() {
        return this.href.getLineNumber();
    }

    @Override
    public int compareTo(InvalidLink other) {
        String otherClassName;
        if (other == null) {
            return 1;
        }
        if (!(other instanceof InvalidHREFLink)) {
            return 1;
        }
        InvalidHREFLink otherLink = (InvalidHREFLink)other;
        String className = this.getClass().getSimpleName();
        int result = className.compareTo(otherClassName = other.getClass().getSimpleName());
        if (result != 0) {
            return -result;
        }
        return this.href.compareTo(otherLink.href);
    }

    @Override
    public String toString() {
        return this.message + "\n\tlink:       " + this.href;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvalidHREFLink other = (InvalidHREFLink)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }
}

