/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.nlpcn.commons.lang.pinyin.Pinyin;
import org.nlpcn.commons.lang.util.StringUtil;

public class MemoryIndex<T> {
    private Map<String, TreeSet<Entry>> index = new HashMap<String, TreeSet<Entry>>();
    private int size;
    private Model model;

    public MemoryIndex(int size, Model model) {
        this.size = size;
        this.model = model;
    }

    public MemoryIndex() {
        this.size = 10;
        this.model = Model.ALL;
    }

    public void addItem(T value, Double score, String ... fields) {
        Set<String> result = null;
        if (fields == null || fields.length == 0) {
            fields = new String[]{value.toString()};
        }
        switch (this.model) {
            case ALL: {
                result = this.getAllSplit(fields);
                break;
            }
            case PREX: {
                result = this.getPrexSplit(fields);
            }
        }
        for (String key : result) {
            if (StringUtil.isBlank(key)) continue;
            TreeSet<Entry> treeSet = this.index.get(key);
            if (treeSet == null) {
                treeSet = new TreeSet();
                this.index.put(key, treeSet);
            }
            treeSet.add(new Entry(value, this.score(value, score)));
            if (treeSet.size() <= this.size) continue;
            treeSet.pollLast();
        }
    }

    public void addItem(T value, String ... fields) {
        this.addItem(value, (Double)null, fields);
    }

    private Set<String> getAllSplit(String[] fields) {
        HashSet<String> hs = new HashSet<String>();
        for (String string : fields) {
            if (StringUtil.isBlank(string)) continue;
            string = string.trim();
            for (int i = 0; i < string.length(); ++i) {
                for (int j = i + 1; j < string.length() + 1; ++j) {
                    hs.add(string.substring(i, j));
                }
            }
        }
        return hs;
    }

    private Set<String> getPrexSplit(String[] fields) {
        HashSet<String> hs = new HashSet<String>();
        for (String string : fields) {
            if (StringUtil.isBlank(string)) continue;
            string = string.trim();
            for (int i = 1; i < string.length() + 1; ++i) {
                hs.add(string.substring(0, i));
            }
        }
        return hs;
    }

    public double score(T value, Double score) {
        if (score != null) {
            return score;
        }
        double weight = 0.0;
        if (value instanceof String) {
            weight = Math.log(Math.E / (double)value.toString().length());
        }
        return weight;
    }

    public String str2QP(String str) {
        return Pinyin.list2String(Pinyin.pinyin(str), "");
    }

    public List<T> suggest(String key) {
        if (StringUtil.isBlank(key)) {
            return Collections.emptyList();
        }
        key = key.replace("\\s", "");
        LinkedList<Object> result = new LinkedList<Object>();
        TreeSet<Entry> treeSet = this.index.get(key);
        if (treeSet == null) {
            return result;
        }
        for (Entry entry : treeSet) {
            result.add(entry.t);
        }
        return result;
    }

    public List<T> smartSuggest(String key) {
        List<T> suggest;
        if (StringUtil.isBlank(key)) {
            return Collections.emptyList();
        }
        key = key.replace("\\s", "");
        List<T> result = this.suggest(key);
        HashSet<T> sets = new HashSet<T>();
        sets.addAll(result);
        if (result.size() < this.size) {
            suggest = this.suggest(this.str2QP(key));
            for (T t : suggest) {
                if (sets.contains(t)) continue;
                sets.add(t);
                result.add(t);
            }
        }
        sets.addAll(result);
        if (result.size() < this.size) {
            suggest = this.suggest(Pinyin.list2String(Pinyin.firstChar(key), ""));
            for (T t : suggest) {
                if (sets.contains(t)) continue;
                sets.add(t);
                result.add(t);
            }
        }
        if (result.size() <= this.size) {
            return result;
        }
        return result.subList(0, this.size);
    }

    public class Entry
    implements Comparable<Entry> {
        private double score;
        private T t;

        public Entry(T t, Double score) {
            this.t = t;
            this.score = score;
        }

        @Override
        public int compareTo(Entry o) {
            if (this.t.equals(o.t)) {
                return 0;
            }
            if (this.score > o.score) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return e.t.equals(this.t);
            }
            return false;
        }

        public double getScore() {
            return this.score;
        }

        public T getValue() {
            return this.t;
        }

        public String toString() {
            return this.t.toString();
        }
    }

    public static enum Model {
        ALL,
        PREX;

    }
}

