/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Arrays;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.TagType;

public abstract class Tag
extends Segment {
    String name = null;
    private Object userData = null;
    Element element = Element.NOT_CACHED;
    private Tag previousTag = NOT_CACHED;
    private Tag nextTag = NOT_CACHED;
    static final Tag NOT_CACHED = new StartTag();
    private static final boolean INCLUDE_UNREGISTERED_IN_SEARCH = false;

    Tag(Source source, int begin, int end, String name) {
        super(source, begin, end);
        this.name = HTMLElements.getConstantElementName(name.toLowerCase());
    }

    Tag() {
    }

    public abstract Element getElement();

    public final String getName() {
        return this.name;
    }

    public Segment getNameSegment() {
        int nameSegmentBegin = this.begin + this.getTagType().startDelimiterPrefix.length();
        return new Segment(this.source, nameSegmentBegin, nameSegmentBegin + this.name.length());
    }

    public abstract TagType getTagType();

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Tag getNextTag() {
        if (this.nextTag == NOT_CACHED) {
            Tag localNextTag = Tag.getNextTag(this.source, this.begin + 1);
            if (this.source.wasFullSequentialParseCalled()) {
                return localNextTag;
            }
            this.nextTag = localNextTag;
        }
        return this.nextTag;
    }

    public Tag getPreviousTag() {
        if (this.previousTag == NOT_CACHED) {
            this.previousTag = Tag.getPreviousTag(this.source, this.begin - 1);
        }
        return this.previousTag;
    }

    public abstract boolean isUnregistered();

    public abstract String tidy();

    public static final boolean isXMLName(CharSequence text) {
        if (text == null || text.length() == 0 || !Tag.isXMLNameStartChar(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Tag.isXMLNameChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLNameStartChar(char ch) {
        return Character.isLetter(ch) || ch == '_' || ch == ':';
    }

    public static final boolean isXMLNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
    }

    StartTag getNextStartTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getNextTag()) != null) continue;
            return null;
        } while (!(tag instanceof StartTag));
        return (StartTag)tag;
    }

    StartTag getPreviousStartTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getPreviousTag()) != null) continue;
            return null;
        } while (!(tag instanceof StartTag));
        return (StartTag)tag;
    }

    EndTag getNextEndTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getNextTag()) != null) continue;
            return null;
        } while (!(tag instanceof EndTag));
        return (EndTag)tag;
    }

    EndTag getPreviousEndTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getPreviousTag()) != null) continue;
            return null;
        } while (!(tag instanceof EndTag));
        return (EndTag)tag;
    }

    Tag getNextTag(TagType tagType) {
        if (tagType == null) {
            return this.getNextTag();
        }
        if (tagType == StartTagType.UNREGISTERED || tagType == EndTagType.UNREGISTERED) {
            return Tag.getNextTag(this.source, this.begin + 1, tagType);
        }
        Tag tag = this;
        do {
            if (tag.nextTag == NOT_CACHED) {
                return Tag.getNextTag(this.source, tag.begin + 1, tagType);
            }
            tag = tag.nextTag;
            if (tag != null) continue;
            return null;
        } while (tag.getTagType() != tagType);
        return tag;
    }

    Tag getPreviousTag(TagType tagType) {
        if (tagType == null) {
            return this.getPreviousTag();
        }
        if (tagType == StartTagType.UNREGISTERED || tagType == EndTagType.UNREGISTERED) {
            return Tag.getPreviousTag(this.source, this.begin - 1, tagType);
        }
        Tag tag = this;
        do {
            if (tag.previousTag == NOT_CACHED) {
                return Tag.getPreviousTag(this.source, tag.begin - 1, tagType);
            }
            tag = tag.previousTag;
            if (tag != null) continue;
            return null;
        } while (tag.getTagType() != tagType);
        return tag;
    }

    final boolean includeInSearch() {
        return !this.isUnregistered();
    }

    static final Tag getPreviousTag(Source source, int pos) {
        return source.useAllTypesCache ? source.cache.getPreviousTag(pos) : Tag.getPreviousTagUncached(source, pos, -1);
    }

    static final Tag getNextTag(Source source, int pos) {
        return source.useAllTypesCache ? source.cache.getNextTag(pos) : Tag.getNextTagUncached(source, pos, -1);
    }

    static final Tag getPreviousTagUncached(Source source, int pos, int breakAtPos) {
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.lastIndexOf('<', begin, breakAtPos)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin, false);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (--begin >= 0);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AssertionError((Object)"Unexpected internal exception");
        }
        return null;
    }

    static final Tag getNextTagUncached(Source source, int pos, int breakAtPos) {
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.indexOf('<', begin, breakAtPos)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin, false);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag getPreviousTag(Source source, int pos, TagType tagType) {
        if (tagType == null) {
            return Tag.getPreviousTag(source, pos);
        }
        if (source.useSpecialTypesCache) {
            return source.cache.getPreviousTag(pos, tagType);
        }
        return Tag.getPreviousTagUncached(source, pos, tagType, -1);
    }

    static final Tag getNextTag(Source source, int pos, TagType tagType) {
        if (tagType == null) {
            return Tag.getNextTag(source, pos);
        }
        if (source.useSpecialTypesCache) {
            return source.cache.getNextTag(pos, tagType);
        }
        return Tag.getNextTagUncached(source, pos, tagType, -1);
    }

    static final Tag getPreviousTagUncached(Source source, int pos, TagType tagType, int breakAtPos) {
        if (tagType == null) {
            return Tag.getPreviousTagUncached(source, pos, breakAtPos);
        }
        String startDelimiter = tagType.getStartDelimiter();
        ParseText parseText = source.getParseText();
        int begin = pos;
        do {
            if ((begin = parseText.lastIndexOf(startDelimiter, begin, breakAtPos)) == -1) {
                return null;
            }
            Tag tag = Tag.getTagAt(source, begin, false);
            if (tag == null || tag.getTagType() != tagType) continue;
            return tag;
        } while (--begin >= 0);
        return null;
    }

    static final Tag getNextTagUncached(Source source, int pos, TagType tagType, int breakAtPos) {
        if (tagType == null) {
            return Tag.getNextTagUncached(source, pos, breakAtPos);
        }
        String startDelimiter = tagType.getStartDelimiter();
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.indexOf(startDelimiter, begin, breakAtPos)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin, false);
                if (tag == null || tag.getTagType() != tagType) continue;
                return tag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static final Tag getTagAt(Source source, int pos, boolean serverTagOnly) {
        return source.useAllTypesCache ? source.cache.getTagAt(pos, serverTagOnly) : Tag.getTagAtUncached(source, pos, serverTagOnly);
    }

    static final Tag getTagAtUncached(Source source, int pos, boolean serverTagOnly) {
        return TagType.getTagAt(source, pos, serverTagOnly, false);
    }

    static final Tag[] parseAll(Source source, boolean assumeNoNestedTags) {
        int registeredTagCount = 0;
        int registeredStartTagCount = 0;
        ArrayList<Tag> list = new ArrayList<Tag>();
        source.fullSequentialParseData = new int[1];
        if (source.end != 0) {
            ParseText parseText = source.getParseText();
            Tag tag = Tag.parseAllgetNextTag(source, parseText, 0, assumeNoNestedTags);
            while (tag != null) {
                int pos;
                list.add(tag);
                if (!tag.isUnregistered()) {
                    ++registeredTagCount;
                    if (tag instanceof StartTag) {
                        ++registeredStartTagCount;
                    }
                }
                int n = pos = tag.getTagType() == StartTagType.SERVER_COMMON_COMMENT || assumeNoNestedTags && !tag.isUnregistered() ? tag.end : tag.begin + 1;
                if (pos == source.end) break;
                tag = Tag.parseAllgetNextTag(source, parseText, pos, assumeNoNestedTags);
            }
        }
        Tag[] allRegisteredTags = new Tag[registeredTagCount];
        StartTag[] allRegisteredStartTags = new StartTag[registeredStartTagCount];
        source.cache.loadAllTags(list, allRegisteredTags, allRegisteredStartTags);
        source.allTagsArray = allRegisteredTags;
        source.allTags = Arrays.asList(allRegisteredTags);
        source.allStartTags = Arrays.asList(allRegisteredStartTags);
        int lastIndex = allRegisteredTags.length - 1;
        for (int i = 0; i < allRegisteredTags.length; ++i) {
            Tag tag = allRegisteredTags[i];
            tag.previousTag = i > 0 ? allRegisteredTags[i - 1] : null;
            tag.nextTag = i < lastIndex ? allRegisteredTags[i + 1] : null;
        }
        return allRegisteredTags;
    }

    private static final Tag parseAllgetNextTag(Source source, ParseText parseText, int pos, boolean assumeNoNestedTags) {
        try {
            int begin = pos;
            do {
                if ((begin = parseText.indexOf('<', begin)) == -1) {
                    return null;
                }
                Tag tag = TagType.getTagAt(source, begin, false, assumeNoNestedTags);
                if (tag == null) continue;
                if (!assumeNoNestedTags) {
                    TagType tagType = tag.getTagType();
                    if (tag.end > source.fullSequentialParseData[0] && tagType != StartTagType.DOCTYPE_DECLARATION && tagType != StartTagType.UNREGISTERED && tagType != EndTagType.UNREGISTERED) {
                        source.fullSequentialParseData[0] = tagType == StartTagType.NORMAL && tag.name == "script" && !((StartTag)tag).isEmptyElementTag() ? Integer.MAX_VALUE : tag.end;
                    }
                }
                return tag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    void orphan() {
        this.nextTag = NOT_CACHED;
    }

    boolean isOrphaned() {
        return this.source.wasFullSequentialParseCalled() && this.nextTag == NOT_CACHED;
    }
}

