/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class FileReader {
    static final int OFFSETS = 10;
    static final int MAXBUFFER = 0x100000;
    static final String EXTENSION = ".hak";
    public Hackit hackit;
    public String name;
    public String pathname;
    public String fcsVersion;
    private int hdrStrt;
    private int hdrEnd;
    private int dataStrt;
    private int dataEnd;
    public byte mode;
    private String date;
    private String btim;
    private String etim;
    public String title;
    public int total;
    public int nPars;
    private int[] pBits;
    private int pBytes;
    public String[] parname;
    public String[] parstain;
    private int readIndex;
    private byte[] header;
    private byte[] preamble;
    FileDialog fd = null;
    Message msg;
    byte[] totalKey = new byte[]{36, 84, 79, 84};
    byte[] systemKey = new byte[]{36, 83, 89, 83};
    byte[] parnumKey = new byte[]{36, 80, 65, 82};
    byte[] bitKey = new byte[]{36, 80, 110, 66};
    byte[] rngKey = new byte[]{36, 80, 110, 82};
    byte[] grngKey = new byte[]{36, 71, 110, 82};
    byte[] parnameKey = new byte[]{36, 80, 110, 78};
    byte[] dateKey = new byte[]{36, 68, 65, 84, 69};
    byte[] btimKey = new byte[]{36, 66, 84, 73, 77};
    byte[] etimKey = new byte[]{36, 69, 84, 73, 77};
    byte[] titleKey = new byte[]{84, 73, 84, 76, 69};
    byte[] title2Key = new byte[]{83, 65, 77, 80, 76, 69, 32, 73, 68};
    byte[] modeKey = new byte[]{36, 77, 79, 68, 69};
    byte[] acqparnumKey = new byte[]{80, 65, 82, 73, 78};
    final int BITINDEX = 2;
    final int FCSPREAMBLESIZE = 74;
    final int FCSVERSIONSIZE = 10;
    final int FCSOFFSETSIZE = 8;

    public FileReader(Hackit hackit) {
        this.hackit = hackit;
        if (this.fd == null) {
            this.fd = new FileDialog((Frame)hackit, "Input FCS data file");
        }
        this.pBits = new int[16];
        this.parname = new String[16];
        this.parstain = new String[16];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSpec read(int pBytes0) throws FCSFileSpecException {
        block16: {
            boolean failure = false;
            this.fd.setMode(0);
            this.fd.show();
            this.name = this.fd.getFile();
            if (this.name == null) {
                return null;
            }
            this.pathname = this.fd.getDirectory() + this.name;
            try {
                this.readHeader(this.pathname);
            }
            catch (FileNotFoundException e) {
                failure = true;
                this.msg = new Message(this.hackit, "File could not be opened");
                return this.msg;
            }
            catch (FileNotFCSTypeException e) {
                failure = true;
                this.msg = new Message(this.hackit, "File is not FCS type");
                return this.msg;
            }
            catch (IllegalFCSFormatException e) {
                failure = true;
                this.msg = new Message(this.hackit, "File not standard FCS list mode");
                return this.msg;
            }
            catch (IOException e) {
                failure = true;
                this.msg = new Message(this.hackit, "File could not be read");
                return this.msg;
            }
            catch (OutOfMemoryError e) {
                failure = true;
                this.msg = new Message(this.hackit, "Memory Error reading header");
                return this.msg;
            }
            finally {
                if (!failure) break block16;
                throw new FCSFileSpecException();
            }
        }
        if (pBytes0 > 0 && pBytes0 != this.pBytes) {
            this.msg = new Message(this.hackit, "This file incompatible with previous");
            return null;
        }
        if (this.dataStrt + this.pBytes * this.total - 1 != this.dataEnd) {
            this.msg = new Message(this.hackit, "Warning: Total Cells vs Data Size Discrepancy");
        }
        return new FileSpec(this.pathname, this.hdrStrt, this.hdrEnd, this.dataStrt, this.dataEnd, this.total, 0, this.total, this.pBytes, this.preamble, this.header);
    }

    public String write(Vector files) {
        int num;
        if (files == null || (num = files.size()) <= 0) {
            this.msg = new Message(this.hackit, "No files to write");
            return null;
        }
        this.fd.setMode(1);
        this.fd.setFile("*.hak");
        this.fd.show();
        this.name = this.fd.getFile();
        if (this.name == null) {
            return null;
        }
        this.pathname = this.fd.getDirectory() + this.name;
        this.pathname = this.extend_name(this.pathname, EXTENSION);
        try {
            int i;
            FileSpec fs = (FileSpec)files.elementAt(0);
            int total0 = fs.total;
            int total = fs.retain;
            int pBytes = fs.pBytes;
            byte[] header0 = fs.header;
            byte[] preamble0 = fs.preamble;
            int hdrStrt = fs.hdrStrt;
            int hdrEnd = fs.hdrEnd;
            int dataStrt = fs.dataStrt;
            int dataEnd = fs.dataEnd;
            for (i = 1; i < num; ++i) {
                fs = (FileSpec)files.elementAt(i);
                total += fs.retain;
            }
            byte[] buffer = total * pBytes >= 0x100000 ? new byte[0x100000] : new byte[total * pBytes];
            FileOutputStream foup = new FileOutputStream(this.pathname);
            byte[] newHeader = this.replaceVal(header0, this.totalKey, String.valueOf(total).trim().getBytes());
            if (hdrEnd < newHeader.length - 1 + hdrStrt) {
                hdrEnd = hdrStrt + newHeader.length - 1;
            }
            if (hdrEnd >= dataStrt) {
                dataStrt = hdrEnd + 1;
            }
            dataEnd = dataStrt + total * pBytes - 1;
            this.modifyPreamble(preamble0, hdrStrt, hdrEnd, dataStrt, dataEnd);
            foup.write(preamble0);
            foup.write(newHeader);
            this.writeSkip(foup, dataStrt - newHeader.length - hdrStrt);
            for (i = 0; i < num; ++i) {
                int cBytes;
                fs = (FileSpec)files.elementAt(i);
                String inpathname = fs.pathname;
                FileInputStream finp = new FileInputStream(inpathname);
                if (finp == null) {
                    throw new FileNotFoundException("Input File can't be opened");
                }
                finp.skip(fs.dataStrt + fs.clip * fs.pBytes);
                for (int nBytes = fs.retain * pBytes; nBytes > 0; nBytes -= cBytes) {
                    cBytes = nBytes > 0x100000 ? 0x100000 : nBytes;
                    cBytes = finp.read(buffer, 0, cBytes);
                    foup.write(buffer, 0, cBytes);
                }
                finp.close();
            }
            foup.close();
        }
        catch (IOException e) {
            this.msg = new Message(this.hackit, "Error writing output file!");
            return null;
        }
        return this.pathname;
    }

    private byte[] numberedKey(byte[] key, int index, int par) {
        int lin;
        if (par > 99) {
            return null;
        }
        int lout = lin = key.length;
        if (par > 9) {
            ++lout;
        }
        byte[] nk = new byte[lout];
        int j = 0;
        for (int i = 0; i < lin; ++i) {
            if (i != index) {
                nk[j++] = key[i];
                continue;
            }
            if (par > 9) {
                nk[j++] = (byte)(48 + par / 10);
            }
            nk[j++] = (byte)(48 + par % 10);
        }
        return nk;
    }

    public void readHeader(String name) throws FileNotFCSTypeException, IllegalFCSFormatException, FileNotFoundException, IOException {
        int defined = 0;
        boolean notFound = true;
        Object flg = null;
        Object sys = null;
        FileInputStream finp = new FileInputStream(name);
        this.preamble = new byte[74];
        if (finp.read(this.preamble) != 74) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        int offset = 0;
        this.fcsVersion = new String(this.preamble, offset, 10);
        if (this.fcsVersion.indexOf("FCS") < 0) {
            throw new FileNotFCSTypeException("FileNotFCSType");
        }
        this.hdrStrt = Integer.parseInt(new String(this.preamble, offset += 10, 8).trim());
        this.hdrEnd = Integer.parseInt(new String(this.preamble, offset += 8, 8).trim());
        this.dataStrt = Integer.parseInt(new String(this.preamble, offset += 8, 8).trim());
        this.dataEnd = Integer.parseInt(new String(this.preamble, offset += 8, 8).trim());
        offset += 8;
        finp.close();
        finp = new FileInputStream(name);
        this.preamble = new byte[this.hdrStrt];
        if (finp.read(this.preamble) != this.hdrStrt) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        this.header = new byte[this.hdrEnd - this.hdrStrt + 1];
        if (finp.read(this.header) != this.header.length) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        finp.close();
        byte dlt = this.header[0];
        this.nPars = this.extractI(this.header, this.parnumKey, dlt);
        if (this.nPars <= 0) {
            this.nPars = 16;
        }
        if (this.nPars > 16) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        this.total = this.extractI(this.header, this.totalKey, dlt);
        if (this.total <= 0) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        this.pBytes = 0;
        for (int i = 0; i < 16; ++i) {
            this.pBits[i] = this.extractI(this.header, this.numberedKey(this.bitKey, 2, i + 1), dlt);
            if (this.pBits[i] <= 0 || i < defined) continue;
            defined = i + 1;
            this.pBytes += this.pBits[i];
        }
        this.pBytes /= 8;
        if (defined <= 0) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        if (this.nPars > defined) {
            this.nPars = defined;
        }
        if ((this.mode = this.extractB(this.header, this.modeKey, dlt)) != 76) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        this.date = this.extractS(this.header, this.dateKey, dlt);
        this.btim = this.extractS(this.header, this.btimKey, dlt);
        this.etim = this.extractS(this.header, this.etimKey, dlt);
        this.title = this.extractS(this.header, this.titleKey, dlt);
        if (this.title == null) {
            this.title = this.extractS(this.header, this.title2Key, dlt);
        }
    }

    private String find(byte[] a, byte[] b, byte c) {
        int i;
        int j = 0;
        for (i = 0; i <= a.length - b.length; ++i) {
            for (j = 0; j < b.length && b[j] == a[i + j]; ++j) {
            }
            if (j == b.length) break;
        }
        if (j < b.length) {
            return null;
        }
        i += j + 1;
        for (j = i; j < a.length && a[j] != c; ++j) {
        }
        if (j >= a.length) {
            return null;
        }
        return new String(a, i, j - i);
    }

    private String extractS(byte[] a, byte[] b, byte c) {
        return this.find(a, b, c);
    }

    private int extractI(byte[] a, byte[] b, byte c) {
        String str = this.find(a, b, c);
        if (str == null) {
            return -1;
        }
        return Integer.parseInt(str.trim());
    }

    private byte extractB(byte[] a, byte[] b, byte c) {
        String str = this.find(a, b, c);
        if (str == null) {
            return -1;
        }
        return (byte)str.charAt(0);
    }

    private int[] extractIA(byte[] a, byte[] b, byte c) {
        String str = this.find(a, b, c);
        if (str == null) {
            return null;
        }
        int[] iA = new int[2];
        int k = 0;
        for (int i = 0; i < 2; ++i) {
            int j;
            for (j = k; j < str.length() && !Character.isDigit(str.charAt(j)); ++j) {
            }
            for (k = j + 1; k < str.length() && Character.isDigit(str.charAt(k)); ++k) {
            }
            if (j == str.length()) {
                return null;
            }
            iA[i] = Integer.parseInt(str.substring(j, k));
        }
        return iA;
    }

    int insertInt(byte[] b, int start, int lngth, int num) {
        int end;
        int i = end = start + lngth;
        if (start < 0 || end > b.length || end <= start) {
            return -1;
        }
        while (num > 0 && i > start) {
            b[--i] = (byte)(48 + num % 10);
            num /= 10;
        }
        if (i == end) {
            b[--i] = 48;
        }
        while (i > start) {
            b[--i] = 32;
        }
        return end;
    }

    String extend_name(String name, String ext) {
        if (name.indexOf(ext) > 0) {
            return name;
        }
        int index = name.indexOf(46);
        if (index <= 0) {
            index = name.length();
        }
        return name.substring(0, index).concat(ext);
    }

    byte getByte(int index, int value) {
        if (index >= 0 && index < 4) {
            return (byte)(value >> index * 8 & 0xFF);
        }
        return -1;
    }

    void writeSkip(FileOutputStream f, int i) throws IOException {
        if (i > 0) {
            byte[] skip = new byte[i];
            while (i > 0) {
                skip[--i] = 32;
            }
            f.write(skip);
        }
    }

    private void modifyPreamble(byte[] preamble, int hdrStrt, int hdrEnd, int dataStrt, int dataEnd) {
        int index = 10;
        index = this.insertInt(preamble, index, 8, hdrStrt);
        index = this.insertInt(preamble, index, 8, hdrEnd);
        index = this.insertInt(preamble, index, 8, dataStrt);
        index = this.insertInt(preamble, index, 8, dataEnd);
    }

    private byte[] replaceVal(byte[] hdr, byte[] key, byte[] val) {
        int k;
        int i;
        int j = 0;
        byte dlmt = hdr[0];
        for (i = 0; i <= hdr.length - key.length; ++i) {
            for (j = 0; j < key.length && key[j] == hdr[i + j]; ++j) {
            }
            if (j == key.length) break;
        }
        if (j < key.length) {
            return null;
        }
        for (j = i += key.length + 1; j < hdr.length && hdr[j] != dlmt; ++j) {
        }
        if (j >= hdr.length) {
            return null;
        }
        int oldLength = j - i;
        int last = hdr.length;
        while (hdr[--last] != dlmt) {
        }
        if (val.length - oldLength > hdr.length - last - 1) {
            int k2;
            byte[] newB = new byte[hdr.length + val.length - oldLength];
            for (k2 = 0; k2 < i; ++k2) {
                newB[k2] = hdr[k2];
            }
            for (k2 = i; k2 < i + val.length; ++k2) {
                newB[k2] = val[k2 - i];
            }
            for (k2 = i + val.length; k2 < newB.length; ++k2) {
                newB[k2] = hdr[k2 + oldLength - val.length];
            }
            return newB;
        }
        if (val.length > oldLength) {
            for (k = hdr.length - 1; k >= j; --k) {
                hdr[k] = hdr[k - val.length + oldLength];
            }
        }
        for (k = i; k < j; ++k) {
            hdr[k] = k - i < val.length ? val[k - i] : 32;
        }
        return hdr;
    }
}

