/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import neobio.alignment.AlignmentBlock;
import neobio.alignment.CrochemoreLandauZivUkelson;
import neobio.alignment.Factor;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.PairwiseAlignment;

public class CrochemoreLandauZivUkelsonGlobalAlignment
extends CrochemoreLandauZivUkelson {
    protected AlignmentBlock createBlock(Factor factor, Factor factor2, int n, int n2) throws IncompatibleScoringSchemeException {
        int n3 = factor.length();
        int n4 = factor2.length();
        int n5 = n3 + n4 + 1;
        AlignmentBlock alignmentBlock = new AlignmentBlock(factor, factor2, n5);
        AlignmentBlock alignmentBlock2 = this.getLeftPrefix(alignmentBlock);
        AlignmentBlock alignmentBlock3 = this.getDiagonalPrefix(alignmentBlock);
        AlignmentBlock alignmentBlock4 = this.getTopPrefix(alignmentBlock);
        int n6 = this.scoreInsertion(factor2.getNewChar());
        int n7 = this.scoreSubstitution(factor.getNewChar(), factor2.getNewChar());
        int n8 = this.scoreDeletion(factor.getNewChar());
        int n9 = 0;
        while (n9 < n5) {
            int n10;
            int n11 = Integer.MIN_VALUE;
            int n12 = Integer.MIN_VALUE;
            int n13 = Integer.MIN_VALUE;
            if (n9 < n5 - 1) {
                n13 = alignmentBlock2.dist_column[n9] + n6;
            }
            if (n9 > 0 && n9 < n5 - 1) {
                n12 = alignmentBlock3.dist_column[n9 - 1] + n7;
            }
            if (n9 > 0) {
                n11 = alignmentBlock4.dist_column[n9 - 1] + n8;
            }
            alignmentBlock.dist_column[n9] = n10 = this.max(n13, n12, n11);
            alignmentBlock.direction[n9] = n10 == n13 ? 1 : (n10 == n12 ? 2 : 3);
            ++n9;
        }
        this.computeOutputBorder(alignmentBlock, n, n2, n5, n4, n3);
        return alignmentBlock;
    }

    protected AlignmentBlock createRootBlock(Factor factor, Factor factor2) {
        return new AlignmentBlock(factor, factor2);
    }

    protected AlignmentBlock createFirstRowBlock(Factor factor, Factor factor2, int n) throws IncompatibleScoringSchemeException {
        int n2 = 0;
        int n3 = factor2.length();
        int n4 = n2 + n3 + 1;
        AlignmentBlock alignmentBlock = new AlignmentBlock(factor, factor2, n4);
        AlignmentBlock alignmentBlock2 = this.getLeftPrefix(alignmentBlock);
        int n5 = this.scoreInsertion(factor2.getNewChar());
        int n6 = 0;
        while (n6 < n3) {
            alignmentBlock.dist_column[n6] = alignmentBlock2.dist_column[n6] + n5;
            alignmentBlock.direction[n6] = 1;
            ++n6;
        }
        alignmentBlock.dist_column[n3] = 0;
        alignmentBlock.direction[n3] = 0;
        this.computeOutputBorder(alignmentBlock, 0, n, n4, n3, n2);
        return alignmentBlock;
    }

    protected AlignmentBlock createFirstColumnBlock(Factor factor, Factor factor2, int n) throws IncompatibleScoringSchemeException {
        int n2 = factor.length();
        int n3 = 0;
        int n4 = n2 + n3 + 1;
        AlignmentBlock alignmentBlock = new AlignmentBlock(factor, factor2, n4);
        AlignmentBlock alignmentBlock2 = this.getTopPrefix(alignmentBlock);
        int n5 = this.scoreDeletion(factor.getNewChar());
        alignmentBlock.dist_column[0] = 0;
        alignmentBlock.direction[0] = 0;
        int n6 = 1;
        while (n6 < n4) {
            alignmentBlock.dist_column[n6] = alignmentBlock2.dist_column[n6 - 1] + n5;
            alignmentBlock.direction[n6] = 3;
            ++n6;
        }
        this.computeOutputBorder(alignmentBlock, n, 0, n4, n3, n2);
        return alignmentBlock;
    }

    protected void computeOutputBorder(AlignmentBlock alignmentBlock, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = this.assembleInputBorder(n3, n, n2, n5);
        int[][] nArray2 = this.assembleDistMatrix(alignmentBlock, n3, n, n2, n4);
        this.out_matrix.setData(nArray2, nArray, n3, n4);
        this.smawk.computeColumnMaxima(this.out_matrix, alignmentBlock.source_path);
        int n6 = 0;
        while (n6 < n3) {
            alignmentBlock.output_border[n6] = this.out_matrix.valueAt(alignmentBlock.source_path[n6], n6);
            ++n6;
        }
    }

    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = this.num_rows - 1;
        int n2 = this.num_cols - 1;
        AlignmentBlock alignmentBlock = this.block_table[n][n2];
        int n3 = alignmentBlock.factor2.length();
        while (n > 0 || n2 > 0) {
            alignmentBlock = this.block_table[n][n2];
            int n4 = alignmentBlock.source_path[n3];
            AlignmentBlock alignmentBlock2 = alignmentBlock.ancestor[n3];
            int n5 = n4;
            if (n3 > alignmentBlock.factor2.length()) {
                n5 -= alignmentBlock.factor1.length() - alignmentBlock2.factor1.length();
            }
            this.traverseBlock(alignmentBlock2, n5, stringBuffer, stringBuffer2, stringBuffer3);
            if (n == 0) {
                n3 = this.block_table[n][--n2].factor2.length();
                continue;
            }
            if (n2 == 0) {
                --n;
                n3 = 0;
                continue;
            }
            if (n4 < alignmentBlock.factor1.length()) {
                n3 = this.block_table[n][--n2].factor2.length() + n4;
                continue;
            }
            if (n4 == alignmentBlock.factor1.length()) {
                n3 = this.block_table[--n][--n2].factor2.length();
                continue;
            }
            --n;
            n3 = n4 - alignmentBlock.factor1.length();
        }
        return new PairwiseAlignment(stringBuffer.toString(), stringBuffer2.toString(), stringBuffer3.toString(), this.locateScore());
    }

    protected int locateScore() {
        AlignmentBlock alignmentBlock = this.block_table[this.num_rows - 1][this.num_cols - 1];
        return alignmentBlock.output_border[alignmentBlock.factor2.length()];
    }
}

