/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = 3765500299698649550L;
    Frame theFrame;
    final JLabel mLogoLabel = new JLabel();
    final JTextField uidFld = new JTextField(8);
    final JTextField titleFld = new JTextField(30);
    final JRadioButton proteinBtn = new JRadioButton("Protein");
    final JRadioButton dnaBtn = new JRadioButton("DNA");
    final JRadioButton rnaBtn = new JRadioButton("RNA");
    final JButton okBtn = new JButton("OK");
    final JButton cancelBtn = new JButton("Cancel");
    boolean ok = false;

    public PreferencesDialog(Frame frame) {
        super(frame, "Preferences", true);
        this.theFrame = frame;
        this.setBackground(SystemColor.window);
        this.buildGUI();
        this.wireGUI();
        this.pack();
        this.setResizable(true);
    }

    private void buildGUI() {
        JPanel jPanel = this.buildLogoPanel();
        JPanel jPanel2 = this.buildWorkPanel();
        JPanel jPanel3 = this.buildButtonPanel();
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        n = 0;
        n2 = 0;
        n3 = 0;
        n4 = 0;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        n = 10;
        n2 = 0;
        n3 = 0;
        n4 = 10;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        n = 0;
        n2 = 0;
        n3 = 0;
        n4 = 20;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        container.add(jPanel3);
    }

    private void wireGUI() {
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.setVisible(false);
                PreferencesDialog.this.dispose();
            }
        });
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.ok = true;
                PreferencesDialog.this.setVisible(false);
                PreferencesDialog.this.dispose();
            }
        });
        this.uidFld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.titleFld.requestFocus();
            }
        });
        this.titleFld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.okBtn.doClick();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreferencesDialog.this.setVisible(false);
            }

            public void windowActivated(WindowEvent windowEvent) {
                PreferencesDialog.this.uidFld.requestFocus();
            }

            public void windowOpened(WindowEvent windowEvent) {
                PreferencesDialog.this.uidFld.requestFocus();
            }
        });
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pack();
            this.uidFld.requestFocus();
        }
        super.setVisible(bl);
    }

    void setTypeEnabled(boolean bl) {
        this.proteinBtn.setEnabled(bl);
        this.dnaBtn.setEnabled(bl);
        this.rnaBtn.setEnabled(bl);
    }

    Point centerIt(Component component, Component component2) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component2.getSize();
        Point point = component.getLocationOnScreen();
        Point point2 = new Point(0, 0);
        point2.x = (dimension.width - dimension2.width) / 2 + point.x;
        point2.y = (dimension.height - dimension2.height) / 2 + point.y;
        return point2;
    }

    Point dialogPosition(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point(0, 0);
        point.x = (dimension.width - dimension2.width) / 2;
        point.y = dimension.height / 3 - dimension2.height / 2;
        point.y = point.y > 0 ? point.y : 20;
        return point;
    }

    public void interact() {
        this.setVisible(true);
    }

    public boolean isOK() {
        return this.ok;
    }

    private JPanel buildLogoPanel() {
        JPanel jPanel = new JPanel();
        this.mLogoLabel.setHorizontalAlignment(0);
        this.mLogoLabel.setVerticalAlignment(0);
        try {
            URL uRL = this.getClass().getResource("/com/hgsi/sa/images/PSEM.large.gif");
            this.mLogoLabel.setIcon(new ImageIcon(uRL));
            this.mLogoLabel.setHorizontalTextPosition(0);
            this.mLogoLabel.setVerticalTextPosition(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        jPanel.add(this.mLogoLabel);
        return jPanel;
    }

    private JPanel buildWorkPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        JLabel jLabel = null;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        n = 0;
        n2 = 0;
        n3 = 10;
        n4 = 0;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        jLabel = new JLabel("UID:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        n = 0;
        n2 = 5;
        n3 = 10;
        n4 = 0;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        gridBagLayout.setConstraints(this.uidFld, gridBagConstraints);
        jPanel.add(this.uidFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        n = 0;
        n2 = 0;
        n3 = 10;
        n4 = 0;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        jLabel = new JLabel("Title:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        n = 0;
        n2 = 5;
        n3 = 10;
        n4 = 0;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        gridBagLayout.setConstraints(this.titleFld, gridBagConstraints);
        jPanel.add(this.titleFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        n = 0;
        n2 = 5;
        n3 = 0;
        n4 = 0;
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        JPanel jPanel2 = this.buildTypePanel();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel buildTypePanel() {
        int n = 20;
        int n2 = 5;
        JPanel jPanel = new JPanel(new FlowLayout(1, n, n2));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.proteinBtn);
        buttonGroup.add(this.dnaBtn);
        buttonGroup.add(this.rnaBtn);
        jPanel.add(this.proteinBtn);
        jPanel.add(this.dnaBtn);
        jPanel.add(this.rnaBtn);
        return jPanel;
    }

    private JPanel buildButtonPanel() {
        int n = 20;
        int n2 = 5;
        JPanel jPanel = new JPanel(new FlowLayout(1, n, n2));
        jPanel.add(this.cancelBtn);
        jPanel.add(this.okBtn);
        return jPanel;
    }
}

