/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.ElementStyle;
import com.informagen.giv.ElementType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.Properties;
import javax.swing.JComponent;

public class MapGlyph
extends JComponent {
    int mWidth;
    int mID;
    private String mLabel;
    private Properties properties = null;
    public float mStart;
    public float mStop;
    int mBarWidth;
    int mBarHeight;
    int mBarInset;
    int mLblInset;
    int mBarTop;
    int mLblTop;
    boolean mSelected;
    public ElementType mElementType = null;
    public ElementStyle mElementStyle = null;
    private Polygon polygon = null;
    int mLblWidth;

    public MapGlyph(float f, float f2) {
        this("", f, f2);
    }

    public MapGlyph(String string, float f, float f2) {
        this(string, f, f2, new ElementStyle());
    }

    public MapGlyph(String string, float f, float f2, ElementStyle elementStyle) {
        this.mLabel = string == null ? "" : string;
        this.mStart = f;
        this.mStop = f2;
        this.mSelected = false;
        this.mElementStyle = elementStyle;
        this.mLblWidth = this.mElementStyle.stringWidth(this.mLabel);
        this.mBarHeight = this.mElementStyle.barHeight();
    }

    public MapGlyph(String string, float f, float f2, ElementStyle elementStyle, ElementType elementType) {
        this(string, f, f2, elementStyle);
        this.mElementType = elementType;
    }

    public String getElementType() {
        String string = null;
        if (this.mElementType != null) {
            string = this.mElementType.getElementType();
        }
        if (string == null && this.mElementStyle != null) {
            string = this.mElementStyle.getStyleName();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public void paint(Graphics graphics) {
        this.drawTheBar(graphics);
        this.drawTheLabel(graphics);
        this.drawSelectionBox(graphics);
    }

    public String getName() {
        return this.mLabel;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setBarWidth(int n) {
        this.mBarWidth = n;
        this.setSize(this.adjust());
        this.polygon = null;
    }

    public boolean hasPropertyPair(String string, String string2) {
        if (this.properties == null) {
            return false;
        }
        String string3 = (String)this.properties.get(string);
        return string2.equalsIgnoreCase(string3);
    }

    public String getStringProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(string);
    }

    public void putStringProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(string, string2);
    }

    private Dimension adjust() {
        if (!this.isVisible()) {
            return this.getSize();
        }
        Dimension dimension = this.getSize();
        this.mBarInset = 0;
        this.mLblInset = 0;
        if (this.mBarWidth == 0) {
            this.mBarWidth = 1;
        }
        int n = this.mBarWidth;
        int n2 = this.mBarHeight;
        this.mLblTop = this.mElementStyle.getAscent();
        int n3 = this.mBarTop = this.mLabel.equals("") ? 0 : this.mElementStyle.labelHeight();
        if (this.mElementStyle.labelPosition() == 0) {
            this.mLblTop = this.mBarHeight + this.mElementStyle.getAscent();
            this.mBarTop = 0;
        }
        switch (this.mElementStyle.labelDisplay()) {
            case 2: {
                this.mBarTop = 0;
                break;
            }
            case 1: {
                if (this.mBarWidth < this.mLblWidth) {
                    this.mBarTop = 0;
                    break;
                }
            }
            case 0: {
                if (this.mLblWidth > this.mBarWidth) {
                    this.mLblInset = 0;
                    this.mBarInset = this.mLblWidth - this.mBarWidth >> 1;
                    n = this.mLblWidth;
                } else {
                    this.mLblInset = this.mBarWidth - this.mLblWidth >> 1;
                }
                n2 += this.mLabel.equals("") ? 0 : this.mElementStyle.labelHeight();
            }
        }
        dimension.width = n;
        dimension.height = n2;
        this.setSize(dimension);
        return dimension;
    }

    private void drawTheBar(Graphics graphics) {
        if (this.mBarHeight <= 0) {
            return;
        }
        graphics.setColor(this.mElementStyle.getColor());
        int n = this.mElementStyle.getStartEdgeStyle();
        int n2 = this.mElementStyle.getStopEdgeStyle();
        int n3 = this.mBarHeight;
        int n4 = n3 * 2;
        if (n == 0 || n2 == 0) {
            n4 = n3;
        }
        if (this.mBarWidth <= n4 || n == 0 && n2 == 0) {
            graphics.fillRect(this.mBarInset, this.mBarTop, this.mBarWidth, this.mBarHeight);
            if (this.mBarWidth > 2 && this.mBarHeight > 2) {
                graphics.draw3DRect(this.mBarInset, this.mBarTop, this.mBarWidth - 1, this.mBarHeight - 1, !this.mSelected);
            }
        } else {
            if (this.polygon == null) {
                this.polygon = new Polygon();
                switch (n) {
                    case 0: {
                        this.polygon.addPoint(this.mBarInset, this.mBarTop + this.mBarHeight);
                        this.polygon.addPoint(this.mBarInset, this.mBarTop);
                        break;
                    }
                    case 1: {
                        this.polygon.addPoint(this.mBarInset + n3, this.mBarTop + this.mBarHeight);
                        this.polygon.addPoint(this.mBarInset, this.mBarTop);
                        break;
                    }
                    case 2: {
                        this.polygon.addPoint(this.mBarInset + n3, this.mBarTop + this.mBarHeight);
                        this.polygon.addPoint(this.mBarInset, this.mBarTop + this.mBarHeight / 2);
                        this.polygon.addPoint(this.mBarInset + n3, this.mBarTop);
                        break;
                    }
                    case 4: {
                        this.polygon.addPoint(this.mBarInset, this.mBarTop + this.mBarHeight);
                        this.polygon.addPoint(this.mBarInset + n3, this.mBarTop + this.mBarHeight / 2);
                        this.polygon.addPoint(this.mBarInset, this.mBarTop);
                        break;
                    }
                    case 3: {
                        this.polygon.addPoint(this.mBarInset, this.mBarTop + this.mBarHeight);
                        this.polygon.addPoint(this.mBarInset + n3, this.mBarTop);
                    }
                }
                switch (n2) {
                    case 0: {
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth, this.mBarTop);
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth, this.mBarTop + this.mBarHeight);
                        break;
                    }
                    case 1: {
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth, this.mBarTop);
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth - n3, this.mBarTop + this.mBarHeight);
                        break;
                    }
                    case 2: {
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth - n3, this.mBarTop);
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth, this.mBarTop + this.mBarHeight / 2);
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth - n3, this.mBarTop + this.mBarHeight);
                        break;
                    }
                    case 4: {
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth, this.mBarTop);
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth - n3, this.mBarTop + this.mBarHeight / 2);
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth, this.mBarTop + this.mBarHeight);
                        break;
                    }
                    case 3: {
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth - n3, this.mBarTop);
                        this.polygon.addPoint(this.mBarInset + this.mBarWidth, this.mBarTop + this.mBarHeight);
                    }
                }
            }
            graphics.fillPolygon(this.polygon);
        }
    }

    private void drawTheLabel(Graphics graphics) {
        switch (this.mElementStyle.labelDisplay()) {
            case 2: {
                break;
            }
            case 1: {
                if (this.mBarWidth < this.mLblWidth) break;
            }
            case 0: {
                graphics.setFont(this.mElementStyle.getFont());
                graphics.setColor(Color.black);
                if (this.mLabel.equals("")) break;
                graphics.drawString(this.mLabel, this.mLblInset, this.mLblTop);
            }
        }
    }

    private void drawSelectionBox(Graphics graphics) {
        if (this.mSelected) {
            graphics.setColor(Color.black);
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }
}

