/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

public class HuffmanAllocator {
    private static int first(int[] array, int i, int nodesToMove) {
        int length = array.length;
        int limit = i;
        int k = array.length - 2;
        while (i >= nodesToMove && array[i] % length > limit) {
            k = i;
            i -= limit - i + 1;
        }
        i = Math.max(nodesToMove - 1, i);
        while (k > i + 1) {
            int temp = i + k >> 1;
            if (array[temp] % length > limit) {
                k = temp;
                continue;
            }
            i = temp;
        }
        return k;
    }

    private static void setExtendedParentPointers(int[] array) {
        int length = array.length;
        array[0] = array[0] + array[1];
        int headNode = 0;
        int tailNode = 1;
        int topNode = 2;
        while (tailNode < length - 1) {
            int temp;
            if (topNode >= length || array[headNode] < array[topNode]) {
                temp = array[headNode];
                array[headNode++] = tailNode;
            } else {
                temp = array[topNode++];
            }
            if (topNode >= length || headNode < tailNode && array[headNode] < array[topNode]) {
                temp += array[headNode];
                array[headNode++] = tailNode + length;
            } else {
                temp += array[topNode++];
            }
            array[tailNode] = temp;
            ++tailNode;
        }
    }

    private static int findNodesToRelocate(int[] array, int maximumLength) {
        int currentNode = array.length - 2;
        int currentDepth = 1;
        while (currentDepth < maximumLength - 1 && currentNode > 1) {
            currentNode = HuffmanAllocator.first(array, currentNode - 1, 0);
            ++currentDepth;
        }
        return currentNode;
    }

    private static void allocateNodeLengths(int[] array) {
        int firstNode = array.length - 2;
        int nextNode = array.length - 1;
        int currentDepth = 1;
        int availableNodes = 2;
        while (availableNodes > 0) {
            int lastNode = firstNode;
            firstNode = HuffmanAllocator.first(array, lastNode - 1, 0);
            int i = availableNodes - (lastNode - firstNode);
            while (i > 0) {
                array[nextNode--] = currentDepth;
                --i;
            }
            availableNodes = lastNode - firstNode << 1;
            ++currentDepth;
        }
    }

    private static void allocateNodeLengthsWithRelocation(int[] array, int nodesToMove, int insertDepth) {
        int firstNode = array.length - 2;
        int nextNode = array.length - 1;
        int currentDepth = insertDepth == 1 ? 2 : 1;
        int nodesLeftToMove = insertDepth == 1 ? nodesToMove - 2 : nodesToMove;
        int availableNodes = currentDepth << 1;
        while (availableNodes > 0) {
            int lastNode = firstNode;
            firstNode = firstNode <= nodesToMove ? firstNode : HuffmanAllocator.first(array, lastNode - 1, nodesToMove);
            int offset = 0;
            if (currentDepth >= insertDepth) {
                offset = Math.min(nodesLeftToMove, 1 << currentDepth - insertDepth);
            } else if (currentDepth == insertDepth - 1) {
                offset = 1;
                if (array[firstNode] == lastNode) {
                    ++firstNode;
                }
            }
            int i = availableNodes - (lastNode - firstNode + offset);
            while (i > 0) {
                array[nextNode--] = currentDepth;
                --i;
            }
            nodesLeftToMove -= offset;
            availableNodes = lastNode - firstNode + offset << 1;
            ++currentDepth;
        }
    }

    public static void allocateHuffmanCodeLengths(int[] array, int maximumLength) {
        switch (array.length) {
            case 2: {
                array[1] = 1;
            }
            case 1: {
                array[0] = 1;
                return;
            }
        }
        HuffmanAllocator.setExtendedParentPointers(array);
        int nodesToRelocate = HuffmanAllocator.findNodesToRelocate(array, maximumLength);
        if (array[0] % array.length >= nodesToRelocate) {
            HuffmanAllocator.allocateNodeLengths(array);
        } else {
            int insertDepth = maximumLength - (32 - Integer.numberOfLeadingZeros(nodesToRelocate - 1));
            HuffmanAllocator.allocateNodeLengthsWithRelocation(array, nodesToRelocate, insertDepth);
        }
    }

    private HuffmanAllocator() {
    }
}

