/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.KeypadGraphics;
import edsim51di.Peripheral;
import edsim51di.SwitchBankGraphics;
import edsim51di.logicdiagram.LogicDiagramInterface;

class SwitchBank
extends Peripheral {
    private double[] switchPins = new double[]{2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7};
    private SwitchBankGraphics graphics;

    SwitchBank(Board board, KeypadGraphics keypad) {
        super("Switch Bank", false);
        double[] d = board.getPortMapSetting("switches_dbs");
        if (d != null) {
            this.switchPins = d;
        }
        this.initDataLineMappings(this.switchPins, "SW ");
        this.graphics = new SwitchBankGraphics(board, this, keypad);
    }

    boolean letKeypadKnowPinState(int portNumber, int pinNumber) {
        for (int i = 0; i < this.dataLineMappings.length; ++i) {
            if (portNumber != this.dataLineMappings[i].portNumber || pinNumber != this.dataLineMappings[i].pinNumber) continue;
            this.graphics.getSwitch(i).isOpen();
        }
        return true;
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[8];
        int start = 321;
        for (int i = 0; i < 8; ++i) {
            interfaces[i] = new LogicDiagramInterface();
            interfaces[i].peripheralPin = start;
            interfaces[i].portNumber = this.dataLineMappings[i].portNumber;
            interfaces[i].pinNumber = this.dataLineMappings[i].pinNumber;
            start += 14;
        }
        return interfaces;
    }

    SwitchBankGraphics getGraphics() {
        return this.graphics;
    }
}

