/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public final class Body {
    private Settings.DisplayFormat displayFormat = Settings.DisplayFormat.FIX;
    private boolean round;
    private int roundLength;
    private boolean truncateZeros;
    private boolean arcAutorelease;
    private boolean hypAutorelease;
    private Settings.PasteParsingAlgorithm pasteParsingAlgorithm;
    private String customButtonCommand;
    final JFrame frame;
    private final JPanel mainPanel;
    final Map<Command, AbstractButton> buttons;
    private NumberDisplay mainDisplay;
    private DoubleByDigitGetters mainDisplayContent;
    private NumberDisplay[] regDisplays;
    private OpDisplay[] opDisplays;
    private NumberDisplay[] memDisplays;
    private IndicatorDisplay<Settings.AngleUnits> angleUnitsDisplay;
    private IndicatorDisplay<Settings.DisplayFormat> displayFormatDisplay;
    private LabelDisplay[] regLabels;
    private ImageIcon activeMemIcon;
    private final int inputLength;
    private final int expInputLength;
    private final int base;

    boolean isRound() {
        return this.round;
    }

    void setRound(boolean bl) {
        this.round = bl;
    }

    int getRoundLength() {
        return this.roundLength;
    }

    void setRoundLength(int n) {
        this.roundLength = n;
    }

    boolean isTruncateZeros() {
        return this.truncateZeros;
    }

    void setTruncateZeros(boolean bl) {
        this.truncateZeros = bl;
    }

    boolean isArcAutorelease() {
        return this.arcAutorelease;
    }

    void setArcAutorelease(boolean bl) {
        this.arcAutorelease = bl;
    }

    boolean isHypAutorelease() {
        return this.hypAutorelease;
    }

    void setHypAutorelease(boolean bl) {
        this.hypAutorelease = bl;
    }

    Settings.PasteParsingAlgorithm getPasteParsingAlgorithm() {
        return this.pasteParsingAlgorithm;
    }

    void setPasteParsingAlgorithm(Settings.PasteParsingAlgorithm pasteParsingAlgorithm) {
        this.pasteParsingAlgorithm = pasteParsingAlgorithm;
    }

    String getCustomButtonCommand() {
        return this.customButtonCommand;
    }

    String[] getCustomButtonCommandAsArray() {
        if (this.customButtonCommand.isEmpty()) {
            return new String[0];
        }
        return this.customButtonCommand.trim().split(" +");
    }

    void setCustomButtonCommand(String string) {
        this.customButtonCommand = string;
    }

    String getMainDisplayString() {
        return this.mainDisplayContent.toString();
    }

    void displayOnlyActiveButtonsForMode(Settings.Mode mode) {
        switch (mode) {
            case RPN: {
                for (Command command : Command.rpnOnly) {
                    this.buttons.get((Object)command).setVisible(true);
                }
                for (Command command : Command.algOnly) {
                    this.buttons.get((Object)command).setVisible(false);
                }
                break;
            }
            case ALG: {
                for (Command command : Command.rpnOnly) {
                    this.buttons.get((Object)command).setVisible(false);
                }
                for (Command command : Command.algOnly) {
                    this.buttons.get((Object)command).setVisible(true);
                }
                break;
            }
        }
    }

    Body(CommandListener commandListener, int n, int n2, int n3) {
        this.inputLength = n;
        this.expInputLength = n2;
        this.base = n3;
        this.frame = new JFrame("Calcoo");
        this.frame.setLayout(new GridLayout(1, 1));
        this.frame.setDefaultCloseOperation(3);
        URL uRL = Button.class.getResource("icons/main/calcoo.png");
        this.frame.setIconImage(new ImageIcon(uRL).getImage());
        this.mainPanel = new JPanel();
        this.mainPanel.setPreferredSize(new Dimension(416, 240));
        this.mainPanel.setLayout(null);
        this.buttons = new EnumMap<Command, AbstractButton>(Command.class);
        this.createLayout(commandListener);
        this.frame.add(this.mainPanel);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
        this.frame.pack();
    }

    void close() {
        this.frame.dispose();
    }

    void switchDisplayFormat() {
        switch (this.displayFormat) {
            case FIX: {
                this.displayFormat = Settings.DisplayFormat.SCI;
                break;
            }
            case SCI: {
                this.displayFormat = Settings.DisplayFormat.ENG;
                break;
            }
            case ENG: {
                this.displayFormat = Settings.DisplayFormat.FIX;
            }
        }
    }

    void setDisplayFormat(Settings.DisplayFormat displayFormat) {
        this.displayFormat = displayFormat;
    }

    Settings.DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    private static int expDivisor(Settings.DisplayFormat displayFormat) {
        if (displayFormat == Settings.DisplayFormat.ENG) {
            return 3;
        }
        return 1;
    }

    void refresh(CpuOutput cpuOutput) {
        int n;
        if (this.inputLength < cpuOutput.getInput().getNIntDigits() + cpuOutput.getInput().getNFracDigits()) {
            throw new RuntimeException("mantissa input lengths don't match on the body (" + this.inputLength + ") and cpu (" + (cpuOutput.getInput().getNIntDigits() + cpuOutput.getInput().getNFracDigits()) + ")");
        }
        if (this.expInputLength != cpuOutput.getInput().getNExpDigits() && cpuOutput.getInput().getNExpDigits() != 0) {
            throw new RuntimeException("exp input lengths don't match on the body (" + this.expInputLength + ") and cpu(" + cpuOutput.getInput().getNExpDigits() + ")");
        }
        if (cpuOutput.isInputInProgress()) {
            this.mainDisplayContent = cpuOutput.getInput();
            if (this.mainDisplayContent.getNIntDigits() == 0) {
                DoubleByDigit doubleByDigit = new DoubleByDigit();
                doubleByDigit.addIntDigit(0);
                doubleByDigit.setSign(this.mainDisplayContent.getSign());
                this.mainDisplayContent = doubleByDigit;
            }
        } else {
            this.mainDisplayContent = DoubleByDigit.fromDouble(cpuOutput.getX(), this.inputLength, this.expInputLength, this.displayFormat != Settings.DisplayFormat.FIX, Body.expDivisor(this.displayFormat), this.round ? this.roundLength : this.inputLength, this.round && !this.truncateZeros, this.base);
        }
        this.mainDisplay.show(this.mainDisplayContent);
        for (n = 0; n < this.regDisplays.length; ++n) {
            this.regDisplays[n].show(DoubleByDigit.fromDouble(cpuOutput.getStack().peekValue(n), this.inputLength, this.expInputLength, this.displayFormat != Settings.DisplayFormat.FIX, Body.expDivisor(this.displayFormat), this.round ? this.roundLength : this.inputLength, this.round && !this.truncateZeros, this.base));
            this.opDisplays[n].show(cpuOutput.getStack().peekOp(n), cpuOutput.getStack().peekParenExists(n));
        }
        for (n = 0; n < this.memDisplays.length; ++n) {
            this.memDisplays[n].show(DoubleByDigit.fromDouble(cpuOutput.getMem(n), this.inputLength, this.expInputLength, this.displayFormat != Settings.DisplayFormat.FIX, Body.expDivisor(this.displayFormat), this.round ? this.roundLength : this.inputLength, this.round && !this.truncateZeros, this.base));
            if (n == cpuOutput.getActiveMemNum()) {
                this.buttons.get((Object)Command.mem[n]).setIcon(this.activeMemIcon);
                continue;
            }
            this.buttons.get((Object)Command.mem[n]).setIcon(null);
        }
        this.angleUnitsDisplay.show(cpuOutput.getAngleUnits());
        this.displayFormatDisplay.show(this.displayFormat);
        if (this.mainDisplayContent.isOverflow()) {
            for (Command command : this.buttons.keySet()) {
                if (command == Command.UNDO || command == Command.REDO || command == Command.CLEAR_ALL) continue;
                this.buttons.get((Object)command).setEnabled(false);
            }
        } else {
            for (Command command : this.buttons.keySet()) {
                if (command == Command.UNDO || command == Command.REDO) continue;
                this.buttons.get((Object)command).setEnabled(true);
            }
        }
        this.mainPanel.repaint();
    }

    private void createShortcut(final CommandListener commandListener, String string, final Command command) {
        this.mainPanel.getInputMap().put(KeyStroke.getKeyStroke(string), (Object)command);
        this.mainPanel.getActionMap().put((Object)command, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                commandListener.processCommand(command);
            }
        });
    }

    private void createLayout(CommandListener commandListener) {
        this.regDisplays = new NumberDisplay[3];
        this.opDisplays = new OpDisplay[3];
        this.regLabels = new LabelDisplay[3];
        for (int i = 0; i < 3; ++i) {
            this.regDisplays[i] = new NumberDisplay(20, 8 + (3 - i - 1) * 16, 112, 16, 7, 1, 9, 3, 1, 2, 40, 0, 0, this.inputLength, this.expInputLength, false, false, "icons/displays/small", this.base, this.mainPanel);
            this.opDisplays[i] = new OpDisplay(132, 8 + (3 - i - 1) * 16, 20, 16, 0, 0, "icons/displays/operation", this.mainPanel);
            this.regLabels[i] = new LabelDisplay(8, 8 + (3 - i - 1) * 16, 12, 16, "icons/labels/LABEL_" + i + ".png", this.mainPanel);
        }
        this.buttons.put(Command.DEG_RAD, Button.create(Command.DEG_RAD, 8, 72, 32, 16, null, "Change angle units", "icons/buttons", commandListener, this.mainPanel, false));
        this.angleUnitsDisplay = new IndicatorDisplay<Settings.AngleUnits>(8, 88, 32, 16, Settings.AngleUnits.values(), "icons/displays/indicator", this.mainPanel);
        this.buttons.put(Command.INFO, Button.create(Command.INFO, 8, 104, 32, 32, new String[]{"shift SLASH"}, "About/Help", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.SETTINGS, Button.create(Command.SETTINGS, 8, 136, 32, 32, new String[]{"EXCLAMATION_MARK", "shift 1"}, "Settings", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.COPY, Button.create(Command.COPY, 8, 168, 32, 32, new String[]{"control C"}, "Copy", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.PASTE, Button.create(Command.PASTE, 8, 200, 32, 32, new String[]{"control V"}, "Paste", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.SIN, Button.create(Command.SIN, 56, 72, 32, 32, new String[]{"S"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.SQR, Button.create(Command.SQR, 88, 72, 32, 32, new String[]{"Q"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.SQRT, Button.create(Command.SQRT, 120, 72, 32, 32, new String[]{"W"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.COS, Button.create(Command.COS, 56, 104, 32, 32, new String[]{"C"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.ETOX, Button.create(Command.ETOX, 88, 104, 32, 32, new String[]{"X"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.LN, Button.create(Command.LN, 120, 104, 32, 32, new String[]{"N"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.TAN, Button.create(Command.TAN, 56, 136, 32, 32, new String[]{"T"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.TENTOX, Button.create(Command.TENTOX, 88, 136, 32, 32, new String[]{"D"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.LOG10, Button.create(Command.LOG10, 120, 136, 32, 32, new String[]{"G"}, "Base-10 log", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.ARC, Button.create(Command.ARC, 56, 168, 32, 32, new String[]{"A"}, null, "icons/buttons", commandListener, this.mainPanel, true));
        this.buttons.put(Command.POW, Button.create(Command.POW, 88, 168, 32, 32, new String[]{"shift 6", "R"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.INVX, Button.create(Command.INVX, 120, 168, 32, 32, new String[]{"I"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.HYP, Button.create(Command.HYP, 56, 200, 32, 32, new String[]{"H"}, null, "icons/buttons", commandListener, this.mainPanel, true));
        this.buttons.put(Command.PI, Button.create(Command.PI, 88, 200, 32, 32, new String[]{"P"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.FACT, Button.create(Command.FACT, 120, 200, 32, 32, new String[]{"F"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_7, Button.create(Command.DIGIT_7, 168, 56, 32, 32, new String[]{"7", "NUMPAD7"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_8, Button.create(Command.DIGIT_8, 200, 56, 32, 32, new String[]{"8", "NUMPAD8"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_9, Button.create(Command.DIGIT_9, 232, 56, 32, 32, new String[]{"9", "NUMPAD9"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_4, Button.create(Command.DIGIT_4, 168, 88, 32, 32, new String[]{"4", "NUMPAD4"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_5, Button.create(Command.DIGIT_5, 200, 88, 32, 32, new String[]{"5", "NUMPAD5"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_6, Button.create(Command.DIGIT_6, 232, 88, 32, 32, new String[]{"6", "NUMPAD6"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_1, Button.create(Command.DIGIT_1, 168, 120, 32, 32, new String[]{"1", "NUMPAD1"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_2, Button.create(Command.DIGIT_2, 200, 120, 32, 32, new String[]{"2", "NUMPAD2"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_3, Button.create(Command.DIGIT_3, 232, 120, 32, 32, new String[]{"3", "NUMPAD3"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIGIT_0, Button.create(Command.DIGIT_0, 168, 152, 32, 32, new String[]{"0", "NUMPAD0"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.SIGN, Button.create(Command.SIGN, 200, 152, 32, 32, new String[]{"M"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DOT, Button.create(Command.DOT, 232, 152, 32, 32, new String[]{"PERIOD", "COMMA", "DECIMAL"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.EXP, Button.create(Command.EXP, 168, 200, 32, 32, new String[]{"E"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.CUSTOM, Button.create(Command.CUSTOM, 200, 200, 32, 32, null, "Custom command", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.FORMAT, Button.create(Command.FORMAT, 232, 200, 32, 16, null, "Change display format", "icons/buttons", commandListener, this.mainPanel, false));
        this.displayFormatDisplay = new IndicatorDisplay<Settings.DisplayFormat>(232, 216, 32, 16, Settings.DisplayFormat.values(), "icons/displays/indicator", this.mainPanel);
        this.buttons.put(Command.ADD, Button.create(Command.ADD, 280, 56, 32, 32, new String[]{"ADD", "PLUS", "shift EQUALS"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.SUB, Button.create(Command.SUB, 312, 56, 32, 32, new String[]{"SUBTRACT", "MINUS"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.CLEAR_ALL, Button.create(Command.CLEAR_ALL, 344, 56, 32, 32, new String[]{"ESCAPE"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.UNDO, Button.create(Command.UNDO, 376, 56, 32, 32, new String[]{"control Z", "LEFT", "BACK_SPACE"}, "Undo", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.MUL, Button.create(Command.MUL, 280, 88, 32, 32, new String[]{"MULTIPLY", "ASTERISK", "shift 8"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.DIV, Button.create(Command.DIV, 312, 88, 32, 32, new String[]{"DIVIDE", "SLASH"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.EQ, Button.create(Command.EQ, 344, 88, 32, 32, new String[]{"EQUALS"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.ENTER, Button.create(Command.ENTER, 344, 88, 32, 32, new String[]{"ENTER"}, "Enter", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.REDO, Button.create(Command.REDO, 376, 88, 32, 32, new String[]{"control Y", "RIGHT"}, "Redo", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.EXCH_XY, Button.create(Command.EXCH_XY, 280, 120, 32, 32, new String[]{"Y"}, "Swap X and Y", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.LEFT_PAREN, Button.create(Command.LEFT_PAREN, 312, 120, 32, 32, new String[]{"LEFT_PARENTHESIS", "shift 9", "OPEN_BRACKET"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.STACK_DOWN, Button.create(Command.STACK_DOWN, 312, 120, 32, 32, new String[]{"DOWN"}, "Scroll stack down", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.RIGHT_PAREN, Button.create(Command.RIGHT_PAREN, 344, 120, 32, 32, new String[]{"RIGHT_PARENTHESIS", "shift 0", "CLOSE_BRACKET"}, null, "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.STACK_UP, Button.create(Command.STACK_UP, 344, 120, 32, 32, new String[]{"UP"}, "Scroll stack up", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.CLEAR_X, Button.create(Command.CLEAR_X, 376, 120, 32, 32, new String[]{"DELETE"}, "Clear X", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.X_TO_MEM, Button.create(Command.X_TO_MEM, 280, 168, 32, 32, null, "STO", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.MEM_TO_X, Button.create(Command.MEM_TO_X, 312, 168, 32, 32, null, "RCL", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.MEM_PLUS, Button.create(Command.MEM_PLUS, 344, 168, 32, 32, null, "Add X to memory", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.EXCH_X_MEM, Button.create(Command.EXCH_X_MEM, 376, 168, 32, 32, null, "Swap X and memory", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.MEM0, Button.create(Command.MEM0, 280, 200, 16, 16, null, "Switch to memory register 0", "icons/buttons", commandListener, this.mainPanel, false));
        this.buttons.put(Command.MEM1, Button.create(Command.MEM1, 280, 216, 16, 16, null, "Switch to memory register 1", "icons/buttons", commandListener, this.mainPanel, false));
        for (AbstractButton abstractButton : this.buttons.values()) {
            this.mainPanel.add(abstractButton);
        }
        this.createShortcut(commandListener, "control Q", Command.EXIT);
        this.createShortcut(commandListener, "control MINUS", Command.MANTISSA_SIGN);
        this.createShortcut(commandListener, "control E", Command.EXP_SIGN);
        this.memDisplays = new NumberDisplay[2];
        for (int i = 0; i < 2; ++i) {
            this.memDisplays[i] = new NumberDisplay(296, 200 + i * 16, 112, 16, 7, 1, 9, 3, 1, 2, 40, 0, 0, this.inputLength, this.expInputLength, false, false, "icons/displays/small", this.base, this.mainPanel);
        }
        this.activeMemIcon = new ImageIcon(Button.class.getResource("icons/buttons/ACTIVE_MEM.png"));
        this.mainDisplay = new NumberDisplay(168, 8, 240, 32, 15, 0, 17, 5, 6, 5, 76, 12, -2, this.inputLength, this.expInputLength, true, true, "icons/displays/main", this.base, this.mainPanel);
    }

    private static class IconLocations {
        static final String iconPath = "icons";
        static final String buttons = "icons/buttons";
        static final String smallDisplay = "icons/displays/small";
        static final String opDisplay = "icons/displays/operation";
        static final String mainDisplay = "icons/displays/main";
        static final String indicatorDisplay = "icons/displays/indicator";
        static final String labelDisplay = "icons/labels";
        static final String mainWindow = "icons/main";

        private IconLocations() {
            throw new AssertionError((Object)"IconLocations is a utility class.");
        }
    }

    private static class Layout {
        static final int BUTTON_SIZE = 32;
        static final int LEFT_MARGIN = 8;
        static final int RIGHT_MARGIN = 8;
        static final int TOP_MARGIN = 8;
        static final int BOTTOM_MARGIN = 8;
        static final int DISPLAY_SIZE_X = 240;
        static final int DISPLAY_SIZE_Y = 32;
        static final int UNDERDISPLAY_SPACING = 16;
        static final int INTERBLOCK_SPACING = 16;
        static final int NUMBER_OF_ROWS = 5;
        static final int NUMBER_OF_COLS_IN_BLOCK_0 = 1;
        static final int NUMBER_OF_COLS_IN_BLOCK_1 = 3;
        static final int NUMBER_OF_COLS_IN_BLOCK_2 = 3;
        static final int NUMBER_OF_COLS_IN_BLOCK_3 = 4;
        static final int OFFSET_OF_BLOCK_0 = 8;
        static final int OFFSET_OF_BLOCK_1 = 56;
        static final int OFFSET_OF_BLOCK_2 = 168;
        static final int OFFSET_OF_BLOCK_3 = 280;
        static final int LEFT_FOR_DISPLAY_Y = 56;
        static final int BODY_SIZE_Y = 240;
        static final int BODY_SIZE_X = 416;
        static final int DISPLAY_CELL_WIDTH = 15;
        static final int DISPLAY_DOT_OFFSET_X = 0;
        static final int DISPLAY_DOT_OFFSET_Y = 17;
        static final int DISPLAY_DOT_WIDTH = 5;
        static final int DISPLAY_MARGIN_Y = 5;
        static final int DISPLAY_MARGIN_X = 6;
        static final int DISPLAY_OVERFLOW_INDENT = 76;
        static final int DISPLAY_TICK_OFFSET_Y = -2;
        static final int DISPLAY_TICK_OFFSET_X = 12;
        static final int DISPLAY_LEFT_SHIFT = 168;
        static final int MEM_DISPLAY_LEFT_SHIFT = 296;
        static final int MEM_DISPLAY_TOP_SHIFT = 200;
        static final int MEM_DISPLAY_V_STEP = 16;
        static final int MEM_DISPLAY_SIZE_X = 112;
        static final int MEM_DISPLAY_SIZE_Y = 16;
        static final int MEM_DISPLAY_CELL_WIDTH = 7;
        static final int MEM_DISPLAY_DOT_OFFSET_X = 1;
        static final int MEM_DISPLAY_DOT_OFFSET_Y = 9;
        static final int MEM_DISPLAY_DOT_WIDTH = 3;
        static final int MEM_DISPLAY_MARGIN_Y = 2;
        static final int MEM_DISPLAY_MARGIN_X = 1;
        static final int MEM_DISPLAY_OVERFLOW_INDENT = 40;
        static final int OP_DISPLAY_SIZE_X = 20;
        static final int OP_DISPLAY_MARGIN_Y = 0;
        static final int OP_DISPLAY_MARGIN_X = 0;
        static final int REG_DISPLAY_LABEL_SIZE_X = 12;
        static final int REG_DISPLAY_LEFT_SHIFT = 20;
        static final int NUMBER_OF_REG_DISPLAYS = 3;
        static final int NUMBER_OF_MEM_DISPLAYS = 2;

        private Layout() {
            throw new AssertionError((Object)"Layout is a utility class.");
        }
    }
}

