/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalProgram {
    private Process _process;
    private final String _path_to_cmd;

    public static boolean isExecuteableFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return file.canExecute();
    }

    public ExternalProgram(String string) {
        File file = new File(string);
        this.checkCmdFile(file);
        this._path_to_cmd = file.getAbsolutePath();
    }

    private void checkCmdFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] does not exist");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] is a directory");
        }
        if (!file.canExecute()) {
            throw new IllegalArgumentException("[" + file.getAbsolutePath() + "] is not executeable");
        }
    }

    public InputStream getErrorStream() {
        return this.getProcess().getErrorStream();
    }

    public InputStream getInputStream() {
        return this.getProcess().getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.getProcess().getOutputStream();
    }

    private String getPathToCmd() {
        return this._path_to_cmd;
    }

    private Process getProcess() {
        return this._process;
    }

    public Process launch(String[] stringArray) throws IOException, InterruptedException {
        String[] stringArray2;
        if (stringArray == null || stringArray.length < 1) {
            stringArray2 = new String[1];
        } else {
            stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i + 1] = stringArray[i];
            }
        }
        stringArray2[0] = this.getPathToCmd();
        System.out.println();
        for (String string : stringArray2) {
            System.out.print(string + " ");
        }
        System.out.println();
        this.setProcess(Runtime.getRuntime().exec(stringArray2));
        return this.getProcess();
    }

    private void setProcess(Process process) {
        this._process = process;
    }

    public int waitFor() {
        try {
            return this.getProcess().waitFor();
        }
        catch (InterruptedException interruptedException) {
            this.getProcess().destroy();
            interruptedException.printStackTrace();
            return -1;
        }
    }
}

