/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.application.surfacing;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.matrix.character.BasicCharacterStateMatrix;
import org.forester.evoinference.matrix.character.CharacterStateMatrix;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.matrix.distance.DistanceMatrix;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.PfamToGoMapping;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.protein.BasicDomain;
import org.forester.protein.BasicProtein;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.Species;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.DomainCountsDifferenceUtil;
import org.forester.surfacing.DomainLengths;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.SurfacingConstants;
import org.forester.util.AsciiHistogram;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;
import org.forester.util.TaxonomyColors;

public final class SurfacingUtil {
    public static final Pattern PATTERN_SP_STYLE_TAXONOMY = Pattern.compile("^[A-Z0-9]{3,5}$");
    private static final Map<String, String> _TAXCODE_HEXCOLORSTRING_MAP = new HashMap<String, String>();
    private static final Map<String, String> _TAXCODE_TAXGROUP_MAP = new HashMap<String, String>();
    private static final Comparator<Domain> ASCENDING_CONFIDENCE_VALUE_ORDER = new Comparator<Domain>(){

        @Override
        public int compare(Domain domain, Domain domain2) {
            if (domain.getPerDomainEvalue() < domain2.getPerDomainEvalue()) {
                return -1;
            }
            if (domain.getPerDomainEvalue() > domain2.getPerDomainEvalue()) {
                return 1;
            }
            return domain.compareTo(domain2);
        }
    };
    private static final NumberFormat FORMATTER_3 = new DecimalFormat("0.000");

    private SurfacingUtil() {
    }

    public static void addAllBinaryDomainCombinationToSet(GenomeWideCombinableDomains genomeWideCombinableDomains, SortedSet<BinaryDomainCombination> sortedSet) {
        SortedMap<String, CombinableDomains> sortedMap = genomeWideCombinableDomains.getAllCombinableDomainsIds();
        for (String string : sortedMap.keySet()) {
            sortedSet.addAll(((CombinableDomains)sortedMap.get(string)).toBinaryDomainCombinations());
        }
    }

    public static void addAllDomainIdsToSet(GenomeWideCombinableDomains genomeWideCombinableDomains, SortedSet<String> sortedSet) {
        SortedSet<String> sortedSet2 = genomeWideCombinableDomains.getAllDomainIds();
        for (String string : sortedSet2) {
            sortedSet.add(string);
        }
    }

    public static DescriptiveStatistics calculateDescriptiveStatisticsForMeanValues(Set<DomainSimilarity> set) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (DomainSimilarity domainSimilarity : set) {
            basicDescriptiveStatistics.addValue(domainSimilarity.getMeanSimilarityScore());
        }
        return basicDescriptiveStatistics;
    }

    public static void checkForOutputFileWriteability(File file) {
        String string = ForesterUtil.isWritableFile(file);
        if (!ForesterUtil.isEmpty(string)) {
            ForesterUtil.fatalError("surfacing", string);
        }
    }

    public static void checkWriteabilityForPairwiseComparisons(DomainSimilarity.PRINT_OPTION pRINT_OPTION, String[][] stringArray, String string, File file) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                String string2 = stringArray[i][1];
                String string3 = stringArray[j][1];
                String string4 = "pwc_" + string2 + "_" + string3 + string;
                switch (pRINT_OPTION) {
                    case HTML: {
                        if (string4.endsWith(".html")) break;
                        string4 = string4 + ".html";
                    }
                }
                String string5 = ForesterUtil.isWritableFile(new File(file == null ? string4 : file + ForesterUtil.FILE_SEPARATOR + string4));
                if (ForesterUtil.isEmpty(string5)) continue;
                ForesterUtil.fatalError("surfacing", string5);
            }
        }
    }

    public static void collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, BinaryDomainCombination.DomainCombinationType domainCombinationType, List<BinaryDomainCombination> list, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        for (String string : treeSet) {
            for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                if ((!bl || characterStateMatrix.getState(string, i) != CharacterStateMatrix.GainLossStates.GAIN) && (bl || characterStateMatrix.getState(string, i) != CharacterStateMatrix.GainLossStates.LOSS)) continue;
                if (domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                    list.add(AdjactantDirectedBinaryDomainCombination.obtainInstance(characterStateMatrix.getCharacter(i)));
                    continue;
                }
                if (domainCombinationType == BinaryDomainCombination.DomainCombinationType.DIRECTED) {
                    list.add(DirectedBinaryDomainCombination.obtainInstance(characterStateMatrix.getCharacter(i)));
                    continue;
                }
                list.add(BasicBinaryDomainCombination.obtainInstance(characterStateMatrix.getCharacter(i)));
            }
        }
    }

    public static Map<String, List<GoId>> createDomainIdToGoIdMap(List<PfamToGoMapping> list) {
        HashMap<String, List<GoId>> hashMap = new HashMap<String, List<GoId>>(list.size());
        for (PfamToGoMapping pfamToGoMapping : list) {
            if (!hashMap.containsKey(pfamToGoMapping.getKey())) {
                hashMap.put(pfamToGoMapping.getKey(), new ArrayList());
            }
            ((List)hashMap.get(pfamToGoMapping.getKey())).add(pfamToGoMapping.getValue());
        }
        return hashMap;
    }

    public static Map<String, Set<String>> createDomainIdToSecondaryFeaturesMap(File file) throws IOException {
        BasicTable<String> basicTable = BasicTableParser.parse(file, '\t');
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
            String string = basicTable.getValue(0, i);
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new HashSet());
            }
            ((Set)treeMap.get(string)).add(basicTable.getValue(1, i));
        }
        return treeMap;
    }

    public static Phylogeny createNjTreeBasedOnMatrixToFile(File file, DistanceMatrix distanceMatrix) {
        SurfacingUtil.checkForOutputFileWriteability(file);
        NeighborJoining neighborJoining = NeighborJoining.createInstance();
        Phylogeny phylogeny = neighborJoining.execute((BasicSymmetricalDistanceMatrix)distanceMatrix);
        phylogeny.setName(file.getName());
        SurfacingUtil.writePhylogenyToFile(phylogeny, file.toString());
        return phylogeny;
    }

    public static StringBuilder createParametersAsString(boolean bl, double d, double d2, int n, boolean bl2, File file, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("iE-value: " + d);
        stringBuilder.append(", FS E-value: " + d2);
        if (file != null) {
            stringBuilder.append(", Cutoff-scores-file: " + file);
        } else {
            stringBuilder.append(", Cutoff-scores-file: not-set");
        }
        if (n != -1) {
            stringBuilder.append(", Max-overlap: " + n);
        } else {
            stringBuilder.append(", Max-overlap: not-set");
        }
        if (bl2) {
            stringBuilder.append(", Engulfing-overlaps: not-allowed");
        } else {
            stringBuilder.append(", Engulfing-overlaps: allowed");
        }
        if (bl) {
            stringBuilder.append(", Ignore-dufs: true");
        } else {
            stringBuilder.append(", Ignore-dufs: false");
        }
        stringBuilder.append(", DC type (if applicable): " + (Object)((Object)domainCombinationType));
        return stringBuilder;
    }

    public static void createSplitWriters(File file, String string, Map<Character, Writer> map) throws IOException {
        map.put(Character.valueOf('a'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_A.html")));
        map.put(Character.valueOf('b'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_B.html")));
        map.put(Character.valueOf('c'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_C.html")));
        map.put(Character.valueOf('d'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_D.html")));
        map.put(Character.valueOf('e'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_E.html")));
        map.put(Character.valueOf('f'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_F.html")));
        map.put(Character.valueOf('g'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_G.html")));
        map.put(Character.valueOf('h'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_H.html")));
        map.put(Character.valueOf('i'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_I.html")));
        map.put(Character.valueOf('j'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_J.html")));
        map.put(Character.valueOf('k'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_K.html")));
        map.put(Character.valueOf('l'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_L.html")));
        map.put(Character.valueOf('m'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_M.html")));
        map.put(Character.valueOf('n'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_N.html")));
        map.put(Character.valueOf('o'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_O.html")));
        map.put(Character.valueOf('p'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_P.html")));
        map.put(Character.valueOf('q'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_Q.html")));
        map.put(Character.valueOf('r'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_R.html")));
        map.put(Character.valueOf('s'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_S.html")));
        map.put(Character.valueOf('t'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_T.html")));
        map.put(Character.valueOf('u'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_U.html")));
        map.put(Character.valueOf('v'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_V.html")));
        map.put(Character.valueOf('w'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_W.html")));
        map.put(Character.valueOf('x'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_X.html")));
        map.put(Character.valueOf('y'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_Y.html")));
        map.put(Character.valueOf('z'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_Z.html")));
        map.put(Character.valueOf('0'), new BufferedWriter(new FileWriter(file + ForesterUtil.FILE_SEPARATOR + string + "_domains_0.html")));
    }

    public static Map<String, Integer> createTaxCodeToIdMap(Phylogeny phylogeny) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                int n;
                String string;
                Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
                String string2 = taxonomy.getTaxonomyCode();
                if (ForesterUtil.isEmpty(string2)) continue;
                if (phylogenyNode.getNodeData().getTaxonomy() == null) {
                    ForesterUtil.fatalError("surfacing", "no taxonomy id for node " + phylogenyNode);
                }
                if (ForesterUtil.isEmpty(string = phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue())) {
                    ForesterUtil.fatalError("surfacing", "no taxonomy id for node " + phylogenyNode);
                }
                if (hashMap.containsKey(string2)) {
                    ForesterUtil.fatalError("surfacing", "taxonomy code " + string2 + " is not unique");
                }
                if (hashMap.containsValue(n = Integer.valueOf(string).intValue())) {
                    ForesterUtil.fatalError("surfacing", "taxonomy id " + n + " is not unique");
                }
                hashMap.put(string2, n);
                continue;
            }
            ForesterUtil.fatalError("surfacing", "no taxonomy for node " + phylogenyNode);
        }
        return hashMap;
    }

    public static void decoratePrintableDomainSimilarities(SortedSet<DomainSimilarity> sortedSet, DomainSimilarityCalculator.Detailedness detailedness) {
        for (DomainSimilarity domainSimilarity : sortedSet) {
            if (!(domainSimilarity instanceof DomainSimilarity)) continue;
            DomainSimilarity domainSimilarity2 = domainSimilarity;
            domainSimilarity2.setDetailedness(detailedness);
        }
    }

    public static void doit(List<Protein> list, List<String> list2, Writer writer, String string, String string2, Map<String, List<Integer>> map) throws IOException {
        for (Protein protein : list) {
            if (!ForesterUtil.isEmpty(string2) && !protein.getSpecies().getSpeciesId().equalsIgnoreCase(string2) || !protein.contains(list2, true)) continue;
            writer.write(protein.getSpecies().getSpeciesId());
            writer.write(string);
            writer.write(protein.getProteinId().getId());
            writer.write(string);
            writer.write("[");
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = true;
            for (Domain domain : protein.getProteinDomains()) {
                if (hashSet.contains(domain.getDomainId())) continue;
                hashSet.add(domain.getDomainId());
                if (bl) {
                    bl = false;
                } else {
                    writer.write(" ");
                }
                writer.write(domain.getDomainId());
                writer.write(" {");
                writer.write("" + domain.getTotalCount());
                writer.write("}");
            }
            writer.write("]");
            writer.write(string);
            if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                writer.write(protein.getDescription());
            }
            writer.write(string);
            if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                writer.write(protein.getAccession());
            }
            writer.write(SurfacingConstants.NL);
        }
        writer.flush();
    }

    public static void domainsPerProteinsStatistics(String string, List<Protein> list, DescriptiveStatistics descriptiveStatistics, SortedMap<Integer, Integer> sortedMap, SortedSet<String> sortedSet, SortedSet<String> sortedSet2, SortedSet<String> sortedSet3, Writer writer) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (Protein protein : list) {
            int n = protein.getNumberOfProteinDomains();
            basicDescriptiveStatistics.addValue(n);
            descriptiveStatistics.addValue(n);
            if (!sortedMap.containsKey(n)) {
                sortedMap.put(n, 1);
            } else {
                sortedMap.put(n, 1 + (Integer)sortedMap.get(n));
            }
            if (n == 1) {
                String string2 = protein.getProteinDomain(0).getDomainId();
                if (sortedSet2.contains(string2)) continue;
                if (sortedSet3.contains(string2)) {
                    sortedSet3.remove(string2);
                    sortedSet2.add(string2);
                    continue;
                }
                sortedSet.add(string2);
                continue;
            }
            if (n <= 1) continue;
            for (Domain domain : protein.getProteinDomains()) {
                String string3 = domain.getDomainId();
                if (sortedSet2.contains(string3)) continue;
                if (sortedSet.contains(string3)) {
                    sortedSet.remove(string3);
                    sortedSet2.add(string3);
                    continue;
                }
                sortedSet3.add(string3);
            }
        }
        try {
            writer.write(string);
            writer.write("\t");
            if (basicDescriptiveStatistics.getN() >= 1) {
                writer.write(basicDescriptiveStatistics.arithmeticMean() + "");
                writer.write("\t");
                if (basicDescriptiveStatistics.getN() >= 2) {
                    writer.write(basicDescriptiveStatistics.sampleStandardDeviation() + "");
                } else {
                    writer.write("");
                }
                writer.write("\t");
                writer.write(basicDescriptiveStatistics.median() + "");
                writer.write("\t");
                writer.write(basicDescriptiveStatistics.getN() + "");
                writer.write("\t");
                writer.write(basicDescriptiveStatistics.getMin() + "");
                writer.write("\t");
                writer.write(basicDescriptiveStatistics.getMax() + "");
            } else {
                writer.write("\t");
                writer.write("\t");
                writer.write("\t");
                writer.write("0");
                writer.write("\t");
                writer.write("\t");
            }
            writer.write("\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void executeDomainLengthAnalysis(String[][] stringArray, int n, DomainLengthsTable domainLengthsTable, File file) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        SurfacingUtil.checkForOutputFileWriteability(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("MEAN BASED STATISTICS PER SPECIES");
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write(domainLengthsTable.createMeanBasedStatisticsPerSpeciesTable().toString());
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        List<DomainLengths> list = domainLengthsTable.getDomainLengthsList();
        bufferedWriter.write("OUTLIER SPECIES PER DOMAIN (Z>=1.5)");
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        for (DomainLengths object2 : list) {
            List<Species> d = object2.getMeanBasedOutlierSpecies(1.5);
            if (d.size() <= 0) continue;
            bufferedWriter.write(object2.getDomainId() + "\t");
            for (Species d2 : d) {
                bufferedWriter.write(d2 + "\t");
            }
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write("OUTLIER SPECIES (Z 1.0)");
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        DescriptiveStatistics descriptiveStatistics = domainLengthsTable.calculateMeanBasedStatisticsForAllSpecies();
        bufferedWriter.write(descriptiveStatistics.asSummary());
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        AsciiHistogram asciiHistogram = new AsciiHistogram(descriptiveStatistics);
        bufferedWriter.write(asciiHistogram.toStringBuffer(40, '=', 60, 4).toString());
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        double d = descriptiveStatistics.sampleStandardDeviation();
        double d2 = descriptiveStatistics.arithmeticMean();
        for (Species species : domainLengthsTable.getSpecies()) {
            double descriptiveStatistics2 = domainLengthsTable.calculateMeanBasedStatisticsForSpecies(species).arithmeticMean();
            double d3 = (descriptiveStatistics2 - d2) / d;
            bufferedWriter.write(species + "\t" + d3);
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        for (Species species : domainLengthsTable.getSpecies()) {
            DescriptiveStatistics descriptiveStatistics2 = domainLengthsTable.calculateMeanBasedStatisticsForSpecies(species);
            double d4 = descriptiveStatistics2.arithmeticMean();
            double d5 = (d4 - d2) / d;
            if (!(d5 <= -1.0) && !(d5 >= 1.0)) continue;
            bufferedWriter.write(species + "\t" + decimalFormat.format(d5) + "\t" + descriptiveStatistics2.asSummary());
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.close();
        System.gc();
    }

    public static void executeFitchGainsAnalysis(File file, List<BinaryDomainCombination> list, int n, SortedSet<BinaryDomainCombination> sortedSet, boolean bl) throws IOException {
        SurfacingUtil.checkForOutputFileWriteability(file);
        BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(file);
        SortedMap<Object, Integer> sortedMap = ForesterUtil.listToSortedCountsMap(list);
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        int n2 = 0;
        int n3 = 0;
        for (Object object : sortedMap.keySet()) {
            BinaryDomainCombination binaryDomainCombination = (BinaryDomainCombination)object;
            int n4 = (Integer)sortedMap.get(object);
            if (n4 < 1) {
                ForesterUtil.unexpectedFatalError("surfacing", "count < 1 ");
            }
            bufferedWriter.write(binaryDomainCombination + "\t" + n4 + ForesterUtil.LINE_SEPARATOR);
            if (n4 > 1) {
                treeSet.add(binaryDomainCombination.getId0());
                treeSet.add(binaryDomainCombination.getId1());
                ++n2;
                continue;
            }
            if (n4 != 1) continue;
            treeSet2.add(binaryDomainCombination.getId0());
            treeSet2.add(binaryDomainCombination.getId1());
            ++n3;
        }
        int n5 = sortedSet.size();
        int n6 = -1;
        if (!bl) {
            sortedSet.removeAll(list);
            n6 = sortedSet.size();
            for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
                bufferedWriter.write(binaryDomainCombination + "\t0" + ForesterUtil.LINE_SEPARATOR);
            }
        }
        if (bl) {
            bufferedWriter.write("Sum of all distinct domain combinations appearing once               : " + n3 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations appearing more than once     : " + n2 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations apppearing only once     : " + treeSet2.size() + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations apppearing more than once: " + treeSet.size() + ForesterUtil.LINE_SEPARATOR);
        } else {
            bufferedWriter.write("Sum of all distinct domain combinations never lost                   : " + n6 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations lost once                    : " + n3 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations lost more than once          : " + n2 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations lost only once           : " + treeSet2.size() + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations lost more than once: " + treeSet.size() + ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.write("All binary combinations                                              : " + n5 + ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write("All domains                                                          : " + n);
        ((Writer)bufferedWriter).close();
        ForesterUtil.programMessage("surfacing", "Wrote fitch domain combination dynamics counts analysis to \"" + file + "\"");
    }

    public static void executeParsimonyAnalysis(long l, boolean bl, String string, DomainParsimonyCalculator domainParsimonyCalculator, Phylogeny phylogeny, Map<String, List<GoId>> map, Map<GoId, GoTerm> map2, GoNameSpace goNameSpace, String string2, Map<String, Set<String>>[] mapArray, SortedSet<String> sortedSet, boolean bl2, List<BinaryDomainCombination> list, List<BinaryDomainCombination> list2, BinaryDomainCombination.DomainCombinationType domainCombinationType, Map<String, DescriptiveStatistics> map3, Map<String, DescriptiveStatistics> map4, Map<String, DescriptiveStatistics> map5, Map<String, Integer> map6, boolean bl3, boolean bl4, boolean bl5) {
        String string3 = ForesterUtil.LINE_SEPARATOR + "###################" + ForesterUtil.LINE_SEPARATOR;
        String string4 = ForesterUtil.getCurrentDateTime();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        TreeSet<String> treeSet4 = new TreeSet<String>();
        TreeSet<String> treeSet5 = new TreeSet<String>();
        if (bl3) {
            SurfacingUtil.writeToNexus(string, domainParsimonyCalculator, phylogeny);
        }
        Phylogeny phylogeny2 = phylogeny.copy();
        if (sortedSet != null && sortedSet.size() > 0) {
            domainParsimonyCalculator.executeDolloParsimonyOnDomainPresence(sortedSet);
        } else {
            domainParsimonyCalculator.executeDolloParsimonyOnDomainPresence();
        }
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossMatrix(), string + "_dollo_gl_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossCountsMatrix(), string + "_dollo_glc_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_dollo_gains_d", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_dollo_losses_d", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_dollo_present_d", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, false, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_dollo_gains_d.html", string3, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Gains | Domains", "+", mapArray, treeSet, treeSet2, "_dollo_gains_d", map6);
        SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, false, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_dollo_losses_d.html", string3, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Losses | Domains", "-", mapArray, treeSet, treeSet3, "_dollo_losses_d", map6);
        SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, false, domainParsimonyCalculator.getGainLossMatrix(), null, string + "_dollo_present_d.html", string3, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Present | Domains", "", mapArray, treeSet, null, "_dollo_present_d", map6);
        SurfacingUtil.preparePhylogeny(phylogeny2, domainParsimonyCalculator, string4, "Dollo parsimony on domain presence/absence", "dollo_on_domains_" + string, string2);
        SurfacingUtil.writePhylogenyToFile(phylogeny2, string + "_d_dollo.xml");
        try {
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(phylogeny2, true, string, "_dollo_all_gains_d");
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(phylogeny2, false, string, "_dollo_all_losses_d");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ForesterUtil.fatalError("surfacing", iOException.getLocalizedMessage());
        }
        if (bl5 && domainParsimonyCalculator.calculateNumberOfBinaryDomainCombination() > 0) {
            phylogeny2 = phylogeny.copy();
            String string5 = "no";
            if (bl) {
                domainParsimonyCalculator.executeFitchParsimonyOnBinaryDomainCombintion(l);
                string5 = "yes, seed = " + l;
            } else {
                domainParsimonyCalculator.executeFitchParsimonyOnBinaryDomainCombintion(bl4);
            }
            SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossMatrix(), string + "_fitch_gl_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossCountsMatrix(), string + "_fitch_glc_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_fitch_gains_dc", string3, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_fitch_losses_dc", string3, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_fitch_present_dc", string3, ForesterUtil.LINE_SEPARATOR, null);
            if (list != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), domainCombinationType, list, true);
            }
            if (list2 != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), domainCombinationType, list2, false);
            }
            if (bl2) {
                SurfacingUtil.writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_fitch_present_dc.dot", string3, ForesterUtil.LINE_SEPARATOR, BinaryDomainCombination.OutputFormat.DOT);
            }
            SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, true, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_fitch_gains_dc.html", string3, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Gains | Domain Combinations", "+", null, treeSet, treeSet4, "_fitch_gains_dc", map6);
            SurfacingUtil.writeBinaryStatesMatrixToList(map, map2, goNameSpace, true, domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_fitch_losses_dc.html", string3, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Losses | Domain Combinations", "-", null, treeSet, treeSet5, "_fitch_losses_dc", map6);
            SurfacingUtil.writeAllEncounteredPfamsToFile(map, map2, string, treeSet);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_gained_as_domains", treeSet2);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_lost_as_domains", treeSet3);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_gained_as_dc", treeSet4);
            SurfacingUtil.writePfamsToFile(string + "_all_pfams_lost_as_dc", treeSet5);
            SurfacingUtil.preparePhylogeny(phylogeny2, domainParsimonyCalculator, string4, "Fitch parsimony on binary domain combination presence/absence randomization: " + string5, "fitch_on_binary_domain_combinations_" + string, string2);
            SurfacingUtil.writePhylogenyToFile(phylogeny2, string + "_dc_fitch.xml");
            SurfacingUtil.calculateIndependentDomainCombinationGains(phylogeny2, string + "_indep_dc_gains_fitch_counts.txt", string + "_indep_dc_gains_fitch_lists.txt", string + "_indep_dc_gains_fitch_lists_for_go_mapping.txt", string + "_indep_dc_gains_fitch_lists_for_go_mapping_unique.txt", string + "_indep_dc_gains_fitch_lca_ranks.txt", string + "_indep_dc_gains_fitch_lca_taxonomies.txt", string + "_indep_dc_gains_fitch_protein_statistics.txt", map3, map4, map5);
        }
    }

    public static void executeParsimonyAnalysisForSecondaryFeatures(String string, DomainParsimonyCalculator domainParsimonyCalculator, Phylogeny phylogeny, String string2, Map<Species, MappingResults> map, boolean bl) {
        String string3 = ForesterUtil.LINE_SEPARATOR + "###################" + ForesterUtil.LINE_SEPARATOR;
        String string4 = ForesterUtil.getCurrentDateTime();
        System.out.println();
        SurfacingUtil.writeToNexus(string + "_secondary_features.nex", domainParsimonyCalculator.createMatrixOfSecondaryFeaturePresenceOrAbsence(null), phylogeny);
        Phylogeny phylogeny2 = phylogeny.copy();
        domainParsimonyCalculator.executeDolloParsimonyOnSecondaryFeatures(map);
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossMatrix(), string + "_dollo_gl_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossCountsMatrix(), string + "_dollo_glc_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_dollo_gains_secondary_features", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_dollo_losses_secondary_features", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_dollo_present_secondary_features", string3, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.preparePhylogeny(phylogeny2, domainParsimonyCalculator, string4, "Dollo parsimony on secondary feature presence/absence", "dollo_on_secondary_features_" + string, string2);
        SurfacingUtil.writePhylogenyToFile(phylogeny2, string + "_secondary_features_dollo.xml");
        phylogeny2 = phylogeny.copy();
        domainParsimonyCalculator.executeFitchParsimonyOnBinaryDomainCombintionOnSecondaryFeatures(bl);
        SurfacingUtil.preparePhylogeny(phylogeny2, domainParsimonyCalculator, string4, "Fitch parsimony on secondary binary domain combination presence/absence randomization: no", "fitch_on_binary_domain_combinations_" + string, string2);
        SurfacingUtil.writePhylogenyToFile(phylogeny2, string + "_dc_MAPPED_secondary_features_fitch.xml");
        SurfacingUtil.calculateIndependentDomainCombinationGains(phylogeny2, string + "_indep_dc_gains_fitch_counts_MAPPED.txt", string + "_indep_dc_gains_fitch_lists_MAPPED.txt", string + "_indep_dc_gains_fitch_lists_for_go_mapping_MAPPED.txt", string + "_indep_dc_gains_fitch_lists_for_go_mapping_unique_MAPPED.txt", string + "_MAPPED_indep_dc_gains_fitch_lca_ranks.txt", string + "_MAPPED_indep_dc_gains_fitch_lca_taxonomies.txt", null, null, null, null);
    }

    public static void executePlusMinusAnalysis(File file, List<String> list, List<String> list2, List<String> list3, List<GenomeWideCombinableDomains> list4, SortedMap<Species, List<Protein>> sortedMap, Map<String, List<GoId>> map, Map<GoId, GoTerm> map2, List<Object> list5) {
        HashSet<String> hashSet = new HashSet<String>();
        for (GenomeWideCombinableDomains object2 : list4) {
            hashSet.add(object2.getSpecies().getSpeciesId());
        }
        File file2 = new File(file + "_plus_minus_dom.html");
        File file3 = new File(file + "_plus_minus_dom.txt");
        File file4 = new File(file + "_plus_minus_dc.html");
        File file5 = new File(file + "_plus_minus_go_ids_all.txt");
        File file6 = new File(file + "_plus_minus_go_ids_passing.txt");
        File file7 = new File(file + "");
        int n = (Integer)list5.get(0);
        double d = (Double)list5.get(1);
        try {
            DomainCountsDifferenceUtil.calculateCopyNumberDifferences(list4, sortedMap, list, list2, list3, n, d, file3, file2, file4, map, map2, file5, file6, file7);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getLocalizedMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis results to \"" + file2 + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis results to \"" + file3 + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis results to \"" + file4 + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis based passing GO ids to \"" + file6 + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote plus minus domain analysis based all GO ids to \"" + file5 + "\"");
    }

    public static void extractProteinNames(List<Protein> list, List<String> list2, Writer writer, String string, String string2) throws IOException {
        for (Protein protein : list) {
            if (!ForesterUtil.isEmpty(string2) && !protein.getSpecies().getSpeciesId().equalsIgnoreCase(string2) || !protein.contains(list2, true)) continue;
            writer.write(protein.getSpecies().getSpeciesId());
            writer.write(string);
            writer.write(protein.getProteinId().getId());
            writer.write(string);
            writer.write("[");
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = true;
            for (Domain domain : protein.getProteinDomains()) {
                if (hashSet.contains(domain.getDomainId())) continue;
                hashSet.add(domain.getDomainId());
                if (bl) {
                    bl = false;
                } else {
                    writer.write(" ");
                }
                writer.write(domain.getDomainId());
                writer.write(" {");
                writer.write("" + domain.getTotalCount());
                writer.write("}");
            }
            writer.write("]");
            writer.write(string);
            if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                writer.write(protein.getDescription());
            }
            writer.write(string);
            if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                writer.write(protein.getAccession());
            }
            writer.write(SurfacingConstants.NL);
        }
        writer.flush();
    }

    public static void extractProteinNames(SortedMap<Species, List<Protein>> sortedMap, String string, Writer writer, String string2, String string3, double d) throws IOException {
        for (Species species : sortedMap.keySet()) {
            for (Protein protein : (List)sortedMap.get(species)) {
                int n;
                List<Domain> list;
                if (!ForesterUtil.isEmpty(string3) && !protein.getSpecies().getSpeciesId().equalsIgnoreCase(string3) || (list = protein.getProteinDomains(string)).size() <= 0) continue;
                writer.write(protein.getSpecies().getSpeciesId());
                writer.write(string2);
                writer.write(protein.getProteinId().getId());
                writer.write(string2);
                writer.write(string.toString());
                writer.write(string2);
                int n2 = -1;
                for (Domain domain : list) {
                    if (!(d < 0.0) && !(domain.getPerDomainEvalue() <= d)) continue;
                    writer.write("/");
                    writer.write(domain.getFrom() + "-" + domain.getTo());
                    if (n2 >= 0) {
                        n = domain.getFrom() - n2;
                    }
                    n2 = domain.getTo();
                }
                writer.write("/");
                writer.write(string2);
                ArrayList arrayList = new ArrayList();
                for (Domain domain : protein.getProteinDomains()) {
                    if (!(d < 0.0) && !(domain.getPerDomainEvalue() <= d)) continue;
                    arrayList.add(domain);
                }
                Domain[] domainArray2 = new Domain[arrayList.size()];
                for (n = 0; n < arrayList.size(); ++n) {
                    domainArray2[n] = (Domain)arrayList.get(n);
                }
                Arrays.sort(domainArray2, new DomainComparator(true));
                writer.write("{");
                n = 1;
                for (Domain domain : domainArray2) {
                    if (n != 0) {
                        n = 0;
                    } else {
                        writer.write(",");
                    }
                    writer.write(domain.getDomainId().toString());
                    writer.write(":" + domain.getFrom() + "-" + domain.getTo());
                    writer.write(":" + domain.getPerDomainEvalue());
                }
                writer.write("}");
                if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                    writer.write(protein.getDescription());
                }
                writer.write(string2);
                if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                    writer.write(protein.getAccession());
                }
                writer.write(SurfacingConstants.NL);
            }
        }
        writer.flush();
    }

    public static SortedSet<String> getAllDomainIds(List<GenomeWideCombinableDomains> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
            SortedSet<String> sortedSet = genomeWideCombinableDomains.getAllDomainIds();
            treeSet.addAll(sortedSet);
        }
        return treeSet;
    }

    public static SortedMap<String, Integer> getDomainCounts(List<Protein> list) {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (Protein protein : list) {
            for (Domain domain : protein.getProteinDomains()) {
                BasicDomain basicDomain = (BasicDomain)domain;
                String string = basicDomain.getDomainId();
                if (treeMap.containsKey(string)) {
                    treeMap.put(string, (Integer)treeMap.get(string) + 1);
                    continue;
                }
                treeMap.put(string, 1);
            }
        }
        return treeMap;
    }

    public static int getNumberOfNodesLackingName(Phylogeny phylogeny, StringBuilder stringBuilder) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        int n = 0;
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!ForesterUtil.isEmpty(phylogenyNode.getName()) || phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) || phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName())) continue;
            if (phylogenyNode.getParent() != null) {
                stringBuilder.append(" ");
                stringBuilder.append(phylogenyNode.getParent().getName());
            }
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            for (PhylogenyNode phylogenyNode2 : list) {
                System.out.println(list.toString());
            }
            ++n;
        }
        return n;
    }

    public static void log(String string, Writer writer) {
        try {
            writer.write(string);
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getLocalizedMessage());
        }
    }

    public static Phylogeny[] obtainAndPreProcessIntrees(File[] fileArray, int n, String[][] stringArray) {
        Phylogeny[] phylogenyArray = new Phylogeny[fileArray.length];
        int n2 = 0;
        for (File file : fileArray) {
            int n3;
            Object object;
            Phylogeny phylogeny = null;
            String string = ForesterUtil.isReadableFile(file);
            if (!ForesterUtil.isEmpty(string)) {
                ForesterUtil.fatalError("surfacing", "cannot read input tree file [" + file + "]: " + string);
            }
            try {
                object = ParserBasedPhylogenyFactory.getInstance().create(file, ParserUtils.createParserDependingOnFileType(file, true));
                if (((Phylogeny[])object).length < 1) {
                    ForesterUtil.fatalError("surfacing", "file [" + file + "] does not contain any phylogeny in phyloXML format");
                } else if (((Phylogeny[])object).length > 1) {
                    ForesterUtil.fatalError("surfacing", "file [" + file + "] contains more than one phylogeny in phyloXML format");
                }
                phylogeny = object[0];
            }
            catch (Exception exception) {
                ForesterUtil.fatalError("surfacing", "failed to read input tree from file [" + file + "]: " + string);
            }
            if (phylogeny == null || phylogeny.isEmpty()) {
                ForesterUtil.fatalError("surfacing", "input tree [" + file + "] is empty");
            }
            if (!phylogeny.isRooted()) {
                ForesterUtil.fatalError("surfacing", "input tree [" + file + "] is not rooted");
            }
            if ((n3 = SurfacingUtil.getNumberOfNodesLackingName(phylogeny, (StringBuilder)(object = new StringBuilder()))) > 0) {
                ForesterUtil.fatalError("surfacing", "input tree [" + file + "] has " + n3 + " node(s) lacking a name [parent names:" + object + "]");
            }
            SurfacingUtil.preparePhylogenyForParsimonyAnalyses(phylogeny, stringArray);
            if (!phylogeny.isCompletelyBinary()) {
                ForesterUtil.printWarningMessage("surfacing", "input tree [" + file + "] is not completely binary");
            }
            phylogenyArray[n2++] = phylogeny;
        }
        return phylogenyArray;
    }

    public static Phylogeny obtainFirstIntree(File file) {
        Phylogeny phylogeny = null;
        String string = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(string)) {
            ForesterUtil.fatalError("surfacing", "cannot read input tree file [" + file + "]: " + string);
        }
        try {
            Phylogeny[] phylogenyArray = ParserBasedPhylogenyFactory.getInstance().create(file, ParserUtils.createParserDependingOnFileType(file, true));
            if (phylogenyArray.length < 1) {
                ForesterUtil.fatalError("surfacing", "file [" + file + "] does not contain any phylogeny in phyloXML format");
            } else if (phylogenyArray.length > 1) {
                ForesterUtil.fatalError("surfacing", "file [" + file + "] contains more than one phylogeny in phyloXML format");
            }
            phylogeny = phylogenyArray[0];
        }
        catch (Exception exception) {
            ForesterUtil.fatalError("surfacing", "failed to read input tree from file [" + file + "]: " + string);
        }
        if (phylogeny == null || phylogeny.isEmpty()) {
            ForesterUtil.fatalError("surfacing", "input tree [" + file + "] is empty");
        }
        if (!phylogeny.isRooted()) {
            ForesterUtil.fatalError("surfacing", "input tree [" + file + "] is not rooted");
        }
        return phylogeny;
    }

    public static String obtainHexColorStringDependingOnTaxonomyGroup(String string, Phylogeny phylogeny) throws IllegalArgumentException {
        if (!_TAXCODE_HEXCOLORSTRING_MAP.containsKey(string)) {
            if (phylogeny != null && !phylogeny.isEmpty()) {
                String string2 = SurfacingUtil.obtainTaxonomyGroup(string, phylogeny);
                Color color = ForesterUtil.obtainColorDependingOnTaxonomyGroup(string2);
                if (color == null) {
                    throw new IllegalArgumentException("no color found for taxonomy group \"" + string2 + "\" for code \"" + string + "\"");
                }
                String string3 = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                _TAXCODE_HEXCOLORSTRING_MAP.put(string, string3);
            } else {
                throw new IllegalArgumentException("unable to obtain color for code " + string + " (tree is null or empty and code is not in map)");
            }
        }
        return _TAXCODE_HEXCOLORSTRING_MAP.get(string);
    }

    public static String obtainTaxonomyGroup(String string, Phylogeny phylogeny) throws IllegalArgumentException {
        if (!_TAXCODE_TAXGROUP_MAP.containsKey(string)) {
            if (phylogeny != null && !phylogeny.isEmpty()) {
                List<PhylogenyNode> list = phylogeny.getNodesViaTaxonomyCode(string);
                if (list == null || list.isEmpty()) {
                    throw new IllegalArgumentException("code " + string + " is not found");
                }
                if (list.size() != 1) {
                    throw new IllegalArgumentException("code " + string + " is not unique");
                }
                String string2 = null;
                for (PhylogenyNode phylogenyNode = list.get(0); phylogenyNode != null; phylogenyNode = phylogenyNode.getParent()) {
                    if (phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) {
                        string2 = ForesterUtil.obtainNormalizedTaxonomyGroup(phylogenyNode.getNodeData().getTaxonomy().getScientificName());
                    }
                    if (ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
                        string2 = ForesterUtil.obtainNormalizedTaxonomyGroup(phylogenyNode.getName());
                    }
                    if (!ForesterUtil.isEmpty(string2)) break;
                }
                if (ForesterUtil.isEmpty(string2)) {
                    string2 = "other";
                }
                _TAXCODE_TAXGROUP_MAP.put(string, string2);
            } else {
                throw new IllegalArgumentException("unable to obtain group for code " + string + " (tree is null or empty and code is not in map)");
            }
        }
        return _TAXCODE_TAXGROUP_MAP.get(string);
    }

    public static void performDomainArchitectureAnalysis(SortedMap<String, Set<String>> sortedMap, SortedMap<String, Integer> sortedMap2, int n, File file, File file2) {
        SurfacingUtil.checkForOutputFileWriteability(file);
        SurfacingUtil.checkForOutputFileWriteability(file2);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file2));
            for (Map.Entry<String, Integer> entry : sortedMap2.entrySet()) {
                String string = entry.getKey();
                int n2 = entry.getValue();
                if (n2 >= n) {
                    bufferedWriter.write(string);
                    bufferedWriter.write("\t");
                    bufferedWriter.write(String.valueOf(n2));
                    bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
                }
                if (n2 != 1) continue;
                for (Map.Entry<String, Set<String>> entry2 : sortedMap.entrySet()) {
                    String string2 = entry2.getKey();
                    Set<String> set = entry2.getValue();
                    if (!set.contains(string)) continue;
                    bufferedWriter2.write(string2);
                    bufferedWriter2.write("\t");
                    bufferedWriter2.write(string);
                    bufferedWriter2.write(ForesterUtil.LINE_SEPARATOR);
                }
            }
            bufferedWriter2.close();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + file + "\"");
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + file2 + "\"");
    }

    public static void preparePhylogeny(Phylogeny phylogeny, DomainParsimonyCalculator domainParsimonyCalculator, String string, String string2, String string3, String string4) {
        domainParsimonyCalculator.decoratePhylogenyWithDomains(phylogeny);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Method: " + string2 + "] [Date: " + string + "] ");
        stringBuilder.append("[Cost: " + domainParsimonyCalculator.getCost() + "] ");
        stringBuilder.append("[Gains: " + domainParsimonyCalculator.getTotalGains() + "] ");
        stringBuilder.append("[Losses: " + domainParsimonyCalculator.getTotalLosses() + "] ");
        stringBuilder.append("[Unchanged: " + domainParsimonyCalculator.getTotalUnchanged() + "] ");
        stringBuilder.append("[Parameters: " + string4 + "]");
        phylogeny.setName(string3);
        phylogeny.setDescription(stringBuilder.toString());
        phylogeny.setConfidence(new Confidence(domainParsimonyCalculator.getCost(), "parsimony"));
        phylogeny.setRerootable(false);
        phylogeny.setRooted(true);
    }

    public static void preparePhylogenyForParsimonyAnalyses(Phylogeny phylogeny, String[][] stringArray) {
        List<String> list;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (phylogeny.getNodes(stringArray[i][1]).size() > 1) {
                ForesterUtil.fatalError("surfacing", "node named [" + stringArray[i][1] + "] is not unique in input tree " + phylogeny.getName());
            }
            stringArray2[i] = stringArray[i][1];
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            list = phylogenyNodeIterator.next();
            if (!ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getName())) continue;
            if (((PhylogenyNode)((Object)list)).getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getTaxonomyCode())) {
                ((PhylogenyNode)((Object)list)).setName(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getTaxonomyCode());
                continue;
            }
            if (((PhylogenyNode)((Object)list)).getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getScientificName())) {
                ((PhylogenyNode)((Object)list)).setName(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getScientificName());
                continue;
            }
            if (((PhylogenyNode)((Object)list)).getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getCommonName())) {
                ((PhylogenyNode)((Object)list)).setName(((PhylogenyNode)((Object)list)).getNodeData().getTaxonomy().getCommonName());
                continue;
            }
            ForesterUtil.fatalError("surfacing", "node with no name, scientific name, common name, or taxonomy code present");
        }
        list = PhylogenyMethods.deleteExternalNodesPositiveSelection(stringArray2, phylogeny);
        if (list.size() > 0) {
            System.out.println("Not using the following " + list.size() + " nodes:");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println(" " + i + ": " + (String)list.get(i));
            }
            System.out.println("--");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (String[] stringArray3 : stringArray) {
            String string = stringArray3[1];
            List<PhylogenyNode> list2 = phylogeny.getNodes(string);
            if (list2 == null || list2.size() < 1) {
                treeSet.add(string);
            }
            if (list2.size() <= 1) continue;
            treeSet2.add(string);
        }
        if (treeSet.size() > 0) {
            ForesterUtil.fatalError("surfacing", "the following " + treeSet.size() + " node(s) are not present in the input tree: " + treeSet);
        }
        if (treeSet2.size() > 0) {
            ForesterUtil.fatalError("surfacing", "the following " + treeSet2.size() + " node(s) are not unique in the input tree: " + treeSet2);
        }
    }

    public static void printOutPercentageOfMultidomainProteins(SortedMap<Integer, Integer> sortedMap, Writer writer) {
        int n = 0;
        for (Map.Entry<Integer, Integer> entry : sortedMap.entrySet()) {
            n += entry.getValue().intValue();
        }
        double d = 100.0 * (double)(n - (Integer)sortedMap.get(1)) / (double)n;
        ForesterUtil.programMessage("surfacing", "Percentage of multidomain proteins: " + d + "%");
        SurfacingUtil.log("Percentage of multidomain proteins:            : " + d + "%", writer);
    }

    public static void processFilter(File file, SortedSet<String> sortedSet) {
        SortedSet<String> sortedSet2 = null;
        try {
            sortedSet2 = ForesterUtil.file2set(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        if (sortedSet2 != null) {
            for (String string : sortedSet2) {
                sortedSet.add(string);
            }
        }
    }

    public static String[][] processInputGenomesFile(File file) {
        String[][] stringArray = null;
        try {
            stringArray = ForesterUtil.file22dArray(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", "genomes files is to be in the following format \"<hmmpfam output file> <species>\": " + iOException.getLocalizedMessage());
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!PhyloXmlUtil.TAXOMONY_CODE_PATTERN.matcher(stringArray[i][1]).matches()) {
                ForesterUtil.fatalError("surfacing", "illegal format for species code: " + stringArray[i][1]);
            }
            if (hashSet.contains(stringArray[i][1])) {
                ForesterUtil.fatalError("surfacing", "species code " + stringArray[i][1] + " is not unique");
            }
            hashSet.add(stringArray[i][1]);
            if (hashSet2.contains(stringArray[i][0])) {
                ForesterUtil.fatalError("surfacing", "path " + stringArray[i][0] + " is not unique");
            }
            hashSet2.add(stringArray[i][0]);
            String string = ForesterUtil.isReadableFile(new File(stringArray[i][0]));
            if (ForesterUtil.isEmpty(string)) continue;
            ForesterUtil.fatalError("surfacing", string);
        }
        return stringArray;
    }

    public static void processPlusMinusAnalysisOption(CommandLineArguments commandLineArguments, List<String> list, List<String> list2, List<String> list3, List<Object> list4) {
        if (commandLineArguments.isOptionSet("plus_minus")) {
            File file;
            String string;
            if (!commandLineArguments.isOptionValueSet("plus_minus")) {
                ForesterUtil.fatalError("surfacing", "no value for 'plus-minus' file: -plus_minus=<file>");
            }
            if (!ForesterUtil.isEmpty(string = ForesterUtil.isReadableFile(file = new File(commandLineArguments.getOptionValue("plus_minus"))))) {
                ForesterUtil.fatalError("surfacing", "can not read from \"" + file + "\": " + string);
            }
            SurfacingUtil.processPlusMinusFile(file, list, list2, list3, list4);
        }
    }

    public static void processPlusMinusFile(File file, List<String> list, List<String> list2, List<String> list3, List<Object> list4) {
        SortedSet<String> sortedSet = null;
        int n = 0;
        double d = 1.0;
        try {
            sortedSet = ForesterUtil.file2set(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        if (sortedSet != null) {
            for (String string : sortedSet) {
                String string2 = string.substring(1);
                if (string.startsWith("+")) {
                    if (list3.contains(string2)) {
                        ForesterUtil.fatalError("surfacing", "species/genome names can not appear with both '+' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list.add(string2);
                } else if (string.startsWith("*")) {
                    if (list3.contains(string2)) {
                        ForesterUtil.fatalError("surfacing", "species/genome names can not appear with both '*' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list2.add(string2);
                } else if (string.startsWith("-")) {
                    if (list.contains(string2) || list2.contains(string2)) {
                        ForesterUtil.fatalError("surfacing", "species/genome names can not appear with both '+' or '*' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list3.add(string2);
                } else if (string.startsWith("$D")) {
                    try {
                        n = Integer.parseInt(string.substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ForesterUtil.fatalError("surfacing", "could not parse integer value for minimal difference from: \"" + string.substring(3) + "\"");
                    }
                } else if (string.startsWith("$F")) {
                    try {
                        d = Double.parseDouble(string.substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ForesterUtil.fatalError("surfacing", "could not parse double value for factor from: \"" + string.substring(3) + "\"");
                    }
                } else if (!string.startsWith("#")) {
                    ForesterUtil.fatalError("surfacing", "species/genome names in 'plus minus' file must begin with '*' (high copy target genome), '+' (high copy base genomes), '-' (low copy genomes), '$D=<integer>' minimal Difference (default is 1), '$F=<double>' factor (default is 1.0), double), or '#' (ignore) suffix, encountered: \"" + string + "\"");
                }
                list4.add(Integer.valueOf(n + ""));
                list4.add(Double.valueOf(d + ""));
            }
        } else {
            ForesterUtil.fatalError("surfacing", "'plus minus' file [" + file + "] appears empty");
        }
    }

    public static StringBuffer proteinToDomainCombinations(Protein protein, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (protein.getSpecies() == null) {
            throw new IllegalArgumentException("species must not be null");
        }
        if (ForesterUtil.isEmpty(protein.getSpecies().getSpeciesId())) {
            throw new IllegalArgumentException("species id must not be empty");
        }
        List<Domain> list = protein.getProteinDomains();
        if (list.size() > 1) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (Domain domain : list) {
                String string3 = domain.getDomainId();
                if (hashMap.containsKey(string3)) {
                    hashMap.put(string3, (Integer)hashMap.get(string3) + 1);
                    continue;
                }
                hashMap.put(string3, 1);
            }
            HashSet hashSet = new HashSet();
            for (int i = 1; i < list.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    String string4;
                    Domain domain = list.get(i);
                    Domain domain2 = list.get(j);
                    if (domain.getFrom() > domain2.getFrom()) {
                        domain = list.get(j);
                        domain2 = list.get(i);
                    }
                    if (hashSet.contains(string4 = domain.getDomainId() + domain2.getDomainId())) continue;
                    hashSet.add(string4);
                    stringBuffer.append(protein.getSpecies());
                    stringBuffer.append(string2);
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    stringBuffer.append(domain.getDomainId());
                    stringBuffer.append(string2);
                    stringBuffer.append(domain2.getDomainId());
                    stringBuffer.append(string2);
                    stringBuffer.append(domain.getPerDomainEvalue());
                    stringBuffer.append(string2);
                    stringBuffer.append(domain2.getPerDomainEvalue());
                    stringBuffer.append(string2);
                    stringBuffer.append(hashMap.get(domain.getDomainId()));
                    stringBuffer.append(string2);
                    stringBuffer.append(hashMap.get(domain2.getDomainId()));
                    stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                }
            }
        } else if (list.size() == 1) {
            stringBuffer.append(protein.getSpecies());
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(list.get(0).getDomainId());
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(list.get(0).getPerDomainEvalue());
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(1);
            stringBuffer.append(string2);
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        } else {
            stringBuffer.append(protein.getSpecies());
            stringBuffer.append(string2);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuffer;
    }

    public static List<Domain> sortDomainsWithAscendingConfidenceValues(Protein protein) {
        ArrayList<Domain> arrayList = new ArrayList<Domain>();
        for (Domain domain : protein.getProteinDomains()) {
            arrayList.add(domain);
        }
        Collections.sort(arrayList, ASCENDING_CONFIDENCE_VALUE_ORDER);
        return arrayList;
    }

    public static int storeDomainArchitectures(String string, SortedMap<String, Set<String>> sortedMap, List<Protein> list, Map<String, Integer> map) {
        HashSet<String> hashSet = new HashSet<String>();
        sortedMap.put(string, hashSet);
        for (Protein protein : list) {
            String string2 = ((BasicProtein)protein).toDomainArchitectureString("~", 3, "=");
            if (hashSet.contains(string2)) continue;
            if (!map.containsKey(string2)) {
                map.put(string2, 1);
            } else {
                map.put(string2, map.get(string2) + 1);
            }
            hashSet.add(string2);
        }
        return hashSet.size();
    }

    public static void writeAllDomainsChangedOnAllSubtrees(Phylogeny phylogeny, boolean bl, String string, String string2) throws IOException {
        CharacterStateMatrix.GainLossStates gainLossStates = CharacterStateMatrix.GainLossStates.GAIN;
        if (!bl) {
            gainLossStates = CharacterStateMatrix.GainLossStates.LOSS;
        }
        File file = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_SUBTREE_EVENTS", false, gainLossStates, string);
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            SortedSet<String> sortedSet;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || (sortedSet = SurfacingUtil.collectAllDomainsChangedOnSubtree(phylogenyNode, bl)).size() <= 0) continue;
            BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(file + ForesterUtil.FILE_SEPARATOR + phylogenyNode.getName() + string2);
            for (String string3 : sortedSet) {
                bufferedWriter.write(string3);
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)bufferedWriter).close();
        }
    }

    public static void writeBinaryDomainCombinationsFileForGraphAnalysis(String[][] stringArray, File file, GenomeWideCombinableDomains genomeWideCombinableDomains, int n, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder genomeWideCombinableDomainsSortOrder) {
        File file2 = new File(stringArray[n][1] + "_dc.dot");
        if (file != null) {
            file2 = new File(file + ForesterUtil.FILE_SEPARATOR + file2);
        }
        SurfacingUtil.checkForOutputFileWriteability(file2);
        SortedSet<BinaryDomainCombination> sortedSet = SurfacingUtil.createSetOfAllBinaryDomainCombinationsPerGenome(genomeWideCombinableDomains);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
                bufferedWriter.write(binaryDomainCombination.toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat.DOT, null, null).toString());
                bufferedWriter.write(SurfacingConstants.NL);
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        if (stringArray[n].length == 3) {
            ForesterUtil.programMessage("surfacing", "Wrote binary domain combination for \"" + stringArray[n][0] + "\" (" + stringArray[n][1] + ", " + stringArray[n][2] + ") to: \"" + file2 + "\"");
        } else {
            ForesterUtil.programMessage("surfacing", "Wrote binary domain combination for \"" + stringArray[n][0] + "\" (" + stringArray[n][1] + ") to: \"" + file2 + "\"");
        }
    }

    public static void writeBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates, String string, String string2, String string3, Map<String, String> map) {
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (String string4 : treeSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write("#" + string4);
                bufferedWriter.write(string2);
                for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                    if (characterStateMatrix.getState(string4, i) != gainLossStates && (gainLossStates != null || characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.GAIN && characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) continue;
                    bufferedWriter.write(characterStateMatrix.getCharacter(i));
                    if (map != null && !map.isEmpty() && map.containsKey(characterStateMatrix.getCharacter(i))) {
                        bufferedWriter.write("\t");
                        bufferedWriter.write(map.get(characterStateMatrix.getCharacter(i)));
                    }
                    bufferedWriter.write(string3);
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + string + "\"");
    }

    public static void writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates, String string, String string2, String string3, BinaryDomainCombination.OutputFormat outputFormat) {
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (String string4 : treeSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write("#" + string4);
                bufferedWriter.write(string2);
                for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                    if (characterStateMatrix.getState(string4, i) != gainLossStates && (gainLossStates != null || characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.GAIN && characterStateMatrix.getState(string4, i) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) continue;
                    BinaryDomainCombination binaryDomainCombination = null;
                    try {
                        binaryDomainCombination = BasicBinaryDomainCombination.obtainInstance(characterStateMatrix.getCharacter(i));
                    }
                    catch (Exception exception) {
                        ForesterUtil.fatalError("surfacing", exception.getLocalizedMessage());
                    }
                    bufferedWriter.write(binaryDomainCombination.toGraphDescribingLanguage(outputFormat, null, null).toString());
                    bufferedWriter.write(string3);
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + string + "\"");
    }

    public static void writeBinaryStatesMatrixToList(Map<String, List<GoId>> map, Map<GoId, GoTerm> map2, GoNameSpace goNameSpace, boolean bl, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> characterStateMatrix, CharacterStateMatrix.GainLossStates gainLossStates, String string, String string2, String string3, String string4, String string5, Map<String, Set<String>>[] mapArray, SortedSet<String> sortedSet, SortedSet<String> sortedSet2, String string6, Map<String, Integer> map3) {
        if (goNameSpace != null && (map2 == null || map2.size() < 1)) {
            throw new IllegalArgumentException("attempt to use GO namespace limit without a GO-id to term map");
        }
        if (map == null || map.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a Pfam to GO map");
        }
        if (map2 == null || map2.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a GO-id to term map");
        }
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < characterStateMatrix.getNumberOfIdentifiers(); ++i) {
            treeSet.add(characterStateMatrix.getIdentifier(i));
        }
        try {
            Matcher matcher;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            File file2 = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_NODE_EVENTS", bl, gainLossStates, string);
            Writer writer = null;
            File file3 = null;
            int n = 0;
            bufferedWriter.write("<html>");
            bufferedWriter.write(SurfacingConstants.NL);
            SurfacingUtil.writeHtmlHead(bufferedWriter, string4);
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("<body>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("<h1>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write(string4);
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("</h1>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("<table>");
            bufferedWriter.write(SurfacingConstants.NL);
            for (String string7 : treeSet) {
                matcher = PATTERN_SP_STYLE_TAXONOMY.matcher(string7);
                if (matcher.matches()) continue;
                bufferedWriter.write("<tr>");
                bufferedWriter.write("<td>");
                bufferedWriter.write("<a href=\"#" + string7 + "\">" + string7 + "</a>");
                bufferedWriter.write("</td>");
                bufferedWriter.write("</tr>");
                bufferedWriter.write(SurfacingConstants.NL);
            }
            bufferedWriter.write("</table>");
            bufferedWriter.write(SurfacingConstants.NL);
            for (String string7 : treeSet) {
                matcher = PATTERN_SP_STYLE_TAXONOMY.matcher(string7);
                if (matcher.matches()) continue;
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<h2>");
                bufferedWriter.write("<a name=\"" + string7 + "\">" + string7 + "</a>");
                SurfacingUtil.writeTaxonomyLinks(bufferedWriter, string7, map3);
                bufferedWriter.write("</h2>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<table>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<tr>");
                bufferedWriter.write("<td><b>");
                bufferedWriter.write("Pfam domain(s)");
                bufferedWriter.write("</b></td><td><b>");
                bufferedWriter.write("GO term acc");
                bufferedWriter.write("</b></td><td><b>");
                bufferedWriter.write("GO term");
                bufferedWriter.write("</b></td><td><b>");
                bufferedWriter.write("GO namespace");
                bufferedWriter.write("</b></td>");
                bufferedWriter.write("</tr>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("</tr>");
                bufferedWriter.write(SurfacingConstants.NL);
                n = 0;
                if (characterStateMatrix.getNumberOfCharacters() > 0) {
                    file3 = new File(file2 + ForesterUtil.FILE_SEPARATOR + string7 + string6);
                    SurfacingUtil.checkForOutputFileWriteability(file3);
                    writer = ForesterUtil.createBufferedWriter(file3);
                } else {
                    file3 = null;
                    writer = null;
                }
                for (int i = 0; i < characterStateMatrix.getNumberOfCharacters(); ++i) {
                    if (characterStateMatrix.getState(string7, i) != gainLossStates && (gainLossStates != null || characterStateMatrix.getState(string7, i) != CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT && characterStateMatrix.getState(string7, i) != CharacterStateMatrix.GainLossStates.GAIN)) continue;
                    String string8 = characterStateMatrix.getCharacter(i);
                    String string9 = "";
                    String string10 = "";
                    if (string8.indexOf("=") > 0) {
                        String[] stringArray = string8.split("=");
                        if (stringArray.length != 2) {
                            throw new AssertionError((Object)("this should not have happened: unexpected format for domain combination: [" + string8 + "]"));
                        }
                        string9 = stringArray[0];
                        string10 = stringArray[1];
                    } else {
                        string9 = string8;
                    }
                    SurfacingUtil.writeDomainData(map, map2, goNameSpace, bufferedWriter, string9, string10, string5, string3, mapArray, null);
                    sortedSet.add(string9);
                    if (sortedSet2 != null) {
                        sortedSet2.add(string9);
                    }
                    if (!ForesterUtil.isEmpty(string10)) {
                        sortedSet.add(string10);
                        if (sortedSet2 != null) {
                            sortedSet2.add(string10);
                        }
                    }
                    if (writer == null) continue;
                    SurfacingUtil.writeDomainsToIndividualFilePerTreeNode(writer, string9, string10);
                    ++n;
                }
                if (writer != null) {
                    writer.close();
                    if (n < 1) {
                        file3.delete();
                    }
                    n = 0;
                }
                bufferedWriter.write("</table>");
                bufferedWriter.write(SurfacingConstants.NL);
                bufferedWriter.write("<hr>");
                bufferedWriter.write(SurfacingConstants.NL);
            }
            bufferedWriter.write("</body>");
            bufferedWriter.write(SurfacingConstants.NL);
            bufferedWriter.write("</html>");
            bufferedWriter.write(SurfacingConstants.NL);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters detailed HTML list: \"" + string + "\"");
    }

    public static void writeDomainCombinationsCountsFile(String[][] stringArray, File file, Writer writer, GenomeWideCombinableDomains genomeWideCombinableDomains, int n, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder genomeWideCombinableDomainsSortOrder) {
        Object object;
        File file2 = new File(stringArray[n][1] + ".dcc");
        if (file != null) {
            file2 = new File(file + ForesterUtil.FILE_SEPARATOR + file2);
        }
        SurfacingUtil.checkForOutputFileWriteability(file2);
        try {
            object = new BufferedWriter(new FileWriter(file2));
            ((Writer)object).write(genomeWideCombinableDomains.toStringBuilder(genomeWideCombinableDomainsSortOrder).toString());
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        object = genomeWideCombinableDomains.getPerGenomeDomainPromiscuityStatistics();
        try {
            writer.write(stringArray[n][1] + "\t");
            writer.write(FORMATTER_3.format(object.arithmeticMean()) + "\t");
            if (object.getN() < 2) {
                writer.write("n/a\t");
            } else {
                writer.write(FORMATTER_3.format(object.sampleStandardDeviation()) + "\t");
            }
            writer.write(FORMATTER_3.format(object.median()) + "\t");
            writer.write((int)object.getMin() + "\t");
            writer.write((int)object.getMax() + "\t");
            writer.write(object.getN() + "\t");
            SortedSet<String> sortedSet = genomeWideCombinableDomains.getMostPromiscuosDomain();
            for (String string : sortedSet) {
                writer.write(string + " ");
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        if (stringArray[n].length == 3) {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + stringArray[n][0] + "\" (" + stringArray[n][1] + ", " + stringArray[n][2] + ") to: \"" + file2 + "\"");
        } else {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + stringArray[n][0] + "\" (" + stringArray[n][1] + ") to: \"" + file2 + "\"");
        }
    }

    public static void writeDomainSimilaritiesToFile(StringBuilder stringBuilder, StringBuilder stringBuilder2, Writer writer, Writer writer2, Writer writer3, Map<Character, Writer> map, SortedSet<DomainSimilarity> sortedSet, boolean bl, List<Species> list, DomainSimilarity.PRINT_OPTION pRINT_OPTION, DomainSimilarity.DomainSimilarityScoring domainSimilarityScoring, boolean bl2, Map<String, Integer> map2, Phylogeny phylogeny, Set<String> set) throws IOException {
        Writer writer4;
        if (writer2 != null && (map == null || map.isEmpty())) {
            map = new HashMap<Character, Writer>();
            map.put(Character.valueOf('_'), writer2);
        }
        switch (pRINT_OPTION) {
            case SIMPLE_TAB_DELIMITED: {
                break;
            }
            case HTML: {
                for (Character object : map.keySet()) {
                    writer4 = map.get(object);
                    writer4.write("<html>");
                    writer4.write(SurfacingConstants.NL);
                    if (object.charValue() != '_') {
                        SurfacingUtil.writeHtmlHead(writer4, "DC analysis (" + stringBuilder2 + ") " + object.toString().toUpperCase());
                    } else {
                        SurfacingUtil.writeHtmlHead(writer4, "DC analysis (" + stringBuilder2 + ")");
                    }
                    writer4.write(SurfacingConstants.NL);
                    writer4.write("<body>");
                    writer4.write(SurfacingConstants.NL);
                    writer4.write(stringBuilder.toString());
                    writer4.write(SurfacingConstants.NL);
                    writer4.write("<hr>");
                    writer4.write(SurfacingConstants.NL);
                    writer4.write("<br>");
                    writer4.write(SurfacingConstants.NL);
                    writer4.write("<table>");
                    writer4.write(SurfacingConstants.NL);
                    writer4.write("<tr><td><b>Domains:</b></td></tr>");
                    writer4.write(SurfacingConstants.NL);
                }
                break;
            }
        }
        for (DomainSimilarity domainSimilarity : sortedSet) {
            if (list != null && !list.isEmpty()) {
                domainSimilarity.setSpeciesOrder(list);
            }
            if (writer2 != null) {
                if (!ForesterUtil.isEmpty(set) && set.contains(domainSimilarity.getDomainId())) {
                    writer2.write("<tr><td><b><a href=\"#" + domainSimilarity.getDomainId() + "\"><span style=\"color:#00ff00\">" + domainSimilarity.getDomainId() + "</span></a></b></td></tr>");
                } else {
                    writer2.write("<tr><td><b><a href=\"#" + domainSimilarity.getDomainId() + "\">" + domainSimilarity.getDomainId() + "</a></b></td></tr>");
                }
                writer2.write(SurfacingConstants.NL);
                continue;
            }
            writer4 = map.get(Character.valueOf((domainSimilarity.getDomainId().charAt(0) + "").toLowerCase().charAt(0)));
            if (writer4 == null) {
                writer4 = map.get(Character.valueOf('0'));
            }
            if (!ForesterUtil.isEmpty(set) && set.contains(domainSimilarity.getDomainId())) {
                writer4.write("<tr><td><b><a href=\"#" + domainSimilarity.getDomainId() + "\"><span style=\"color:#00ff00\">" + domainSimilarity.getDomainId() + "</span></a></b></td></tr>");
            } else {
                writer4.write("<tr><td><b><a href=\"#" + domainSimilarity.getDomainId() + "\">" + domainSimilarity.getDomainId() + "</a></b></td></tr>");
            }
            writer4.write(SurfacingConstants.NL);
        }
        for (Writer writer5 : map.values()) {
            writer5.write("</table>");
            writer5.write(SurfacingConstants.NL);
            writer5.write("<hr>");
            writer5.write(SurfacingConstants.NL);
            writer5.write("<table>");
            writer5.write(SurfacingConstants.NL);
            writer5.write("<tr><td><b>");
            writer5.write("Species group colors:");
            writer5.write("</b></td></tr>");
            writer5.write(SurfacingConstants.NL);
            SurfacingUtil.writeColorLabels("Deuterostomia", TaxonomyColors.DEUTEROSTOMIA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Protostomia", TaxonomyColors.PROTOSTOMIA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Cnidaria", TaxonomyColors.CNIDARIA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Placozoa", TaxonomyColors.PLACOZOA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Ctenophora (comb jellies)", TaxonomyColors.CTENOPHORA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Porifera (sponges)", TaxonomyColors.PORIFERA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Choanoflagellida", TaxonomyColors.CHOANOFLAGELLIDA, writer5);
            SurfacingUtil.writeColorLabels("Ichthyosporea & Filasterea", TaxonomyColors.ICHTHYOSPOREA_AND_FILASTEREA, writer5);
            SurfacingUtil.writeColorLabels("Dikarya (Ascomycota & Basidiomycota, so-called \"higher fungi\")", TaxonomyColors.DIKARYA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("other Fungi", TaxonomyColors.OTHER_FUNGI_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Nucleariidae and Fonticula group", TaxonomyColors.NUCLEARIIDAE_AND_FONTICULA_GROUP_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Amoebozoa", TaxonomyColors.AMOEBOZOA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Embryophyta (plants)", TaxonomyColors.EMBRYOPHYTA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Chlorophyta (green algae)", TaxonomyColors.CHLOROPHYTA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Rhodophyta (red algae)", TaxonomyColors.RHODOPHYTA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Glaucocystophyce (Glaucophyta)", TaxonomyColors.GLAUCOPHYTA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Hacrobia (Cryptophyta & Haptophyceae & Centroheliozoa)", TaxonomyColors.HACROBIA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Stramenopiles (Chromophyta, heterokonts)", TaxonomyColors.STRAMENOPILES_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Alveolata", TaxonomyColors.ALVEOLATA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Rhizaria", TaxonomyColors.RHIZARIA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Excavata", TaxonomyColors.EXCAVATA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Apusozoa", TaxonomyColors.APUSOZOA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Archaea", TaxonomyColors.ARCHAEA_COLOR, writer5);
            SurfacingUtil.writeColorLabels("Bacteria", TaxonomyColors.BACTERIA_COLOR, writer5);
            writer5.write("</table>");
            writer5.write(SurfacingConstants.NL);
            writer5.write("<hr>");
            writer5.write(SurfacingConstants.NL);
            writer5.write("<table>");
            writer5.write(SurfacingConstants.NL);
        }
        for (DomainSimilarity domainSimilarity : sortedSet) {
            if (writer3 != null) {
                writer3.write(domainSimilarity.getSpeciesAndSeqIdsAsStringBuffer(domainSimilarity.getDomainId()).toString());
                writer3.write(SurfacingConstants.NL);
            }
            if (list != null && !list.isEmpty()) {
                domainSimilarity.setSpeciesOrder(list);
            }
            if (writer != null) {
                writer.write(domainSimilarity.toStringBuffer(DomainSimilarity.PRINT_OPTION.SIMPLE_TAB_DELIMITED, map2, null).toString());
            }
            if (writer2 != null) {
                writer2.write(domainSimilarity.toStringBuffer(pRINT_OPTION, map2, phylogeny).toString());
                writer2.write(SurfacingConstants.NL);
                continue;
            }
            writer4 = map.get(Character.valueOf((domainSimilarity.getDomainId().charAt(0) + "").toLowerCase().charAt(0)));
            if (writer4 == null) {
                writer4 = map.get(Character.valueOf('0'));
            }
            writer4.write(domainSimilarity.toStringBuffer(pRINT_OPTION, map2, phylogeny).toString());
            writer4.write(SurfacingConstants.NL);
        }
        switch (pRINT_OPTION) {
            case HTML: {
                for (Writer writer6 : map.values()) {
                    writer6.write(SurfacingConstants.NL);
                    writer6.write("</table>");
                    writer6.write(SurfacingConstants.NL);
                    writer6.write("</font>");
                    writer6.write(SurfacingConstants.NL);
                    writer6.write("</body>");
                    writer6.write(SurfacingConstants.NL);
                    writer6.write("</html>");
                    writer6.write(SurfacingConstants.NL);
                }
                break;
            }
        }
        for (Writer writer7 : map.values()) {
            writer7.close();
        }
    }

    public static void writeHtmlHead(Writer writer, String string) throws IOException {
        writer.write(SurfacingConstants.NL);
        writer.write("<head>");
        writer.write("<title>");
        writer.write(string);
        writer.write("</title>");
        writer.write(SurfacingConstants.NL);
        writer.write("<style>");
        writer.write(SurfacingConstants.NL);
        writer.write("a:visited { color : #000066; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("a:link { color : #000066; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("a:active { color : ##000066; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("a:hover { color : #FFFFFF; background-color : #000000; text-decoration : none; }");
        writer.write(SurfacingConstants.NL);
        writer.write("a.pl:visited { color : #505050; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("a.pl:link { color : #505050; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("a.pl:active { color : #505050; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("a.pl:hover { color : #FFFFFF; background-color : #000000; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("a.ps:visited { color : #707070; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("a.ps:link { color : #707070; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("a.ps:active { color : #707070; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("a.ps:hover { color : #FFFFFF; background-color : #000000; text-decoration : none; font-size: 7px;}");
        writer.write(SurfacingConstants.NL);
        writer.write("td { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 8pt}");
        writer.write(SurfacingConstants.NL);
        writer.write("h1 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 18pt; font-weight: bold }");
        writer.write(SurfacingConstants.NL);
        writer.write("h2 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 16pt; font-weight: bold }");
        writer.write(SurfacingConstants.NL);
        writer.write("</style>");
        writer.write(SurfacingConstants.NL);
        writer.write("</head>");
        writer.write(SurfacingConstants.NL);
    }

    public static void writeMatrixToFile(CharacterStateMatrix<?> characterStateMatrix, String string, CharacterStateMatrix.Format format) {
        File file = new File(string);
        SurfacingUtil.checkForOutputFileWriteability(file);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            characterStateMatrix.toWriter(bufferedWriter, format);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote matrix: \"" + string + "\"");
    }

    public static void writeMatrixToFile(File file, List<DistanceMatrix> list) {
        SurfacingUtil.checkForOutputFileWriteability(file);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (DistanceMatrix distanceMatrix : list) {
                bufferedWriter.write(distanceMatrix.toStringBuffer(DistanceMatrix.Format.PHYLIP).toString());
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
                bufferedWriter.flush();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + file + "\"");
    }

    public static void writePhylogenyToFile(Phylogeny phylogeny, String string) {
        PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
        try {
            phylogenyWriter.toPhyloXML(new File(string), phylogeny, 1);
        }
        catch (IOException iOException) {
            ForesterUtil.printWarningMessage("surfacing", "failed to write phylogeny to \"" + string + "\": " + iOException);
        }
        ForesterUtil.programMessage("surfacing", "Wrote phylogeny to \"" + string + "\"");
    }

    public static void writePresentToNexus(File file, File file2, SortedSet<String> sortedSet, List<GenomeWideCombinableDomains> list) {
        try {
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(list, file2 == null ? null : sortedSet), file + "_dom.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(list), file + "_dc.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError("surfacing", exception.getLocalizedMessage());
        }
    }

    public static void writeProteinListsForAllSpecies(File file, SortedMap<Species, List<Protein>> sortedMap, List<GenomeWideCombinableDomains> list, double d, Set<String> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (GenomeWideCombinableDomains object : list) {
            treeSet.addAll(object.getAllDomainIds());
        }
        for (String string : treeSet) {
            if (!ForesterUtil.isEmpty(set) && !set.contains(string)) continue;
            File file2 = new File(file + ForesterUtil.FILE_SEPARATOR + string + ".prot");
            SurfacingUtil.checkForOutputFileWriteability(file2);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                SurfacingUtil.extractProteinNames(sortedMap, string, bufferedWriter, "\t", surfacing.LIMIT_SPEC_FOR_PROT_EX, d);
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError("surfacing", iOException.getLocalizedMessage());
            }
            ForesterUtil.programMessage("surfacing", "Wrote proteins list to \"" + file2 + "\"");
        }
    }

    public static void writeTaxonomyLinks(Writer writer, String string, Map<String, Integer> map) throws IOException {
        if (string.length() > 1 && string.indexOf(95) < 1) {
            writer.write(" [");
            if (map != null && map.containsKey(string)) {
                writer.write("<a href=\"http://www.uniprot.org/taxonomy/" + map.get(string) + "\" target=\"taxonomy_window\">uniprot</a>");
            } else {
                writer.write("<a href=\"http://www.eol.org/search?q=" + string + "\" target=\"taxonomy_window\">eol</a>");
                writer.write("|");
                writer.write("<a href=\"http://scholar.google.com/scholar?q=" + string + "\" target=\"taxonomy_window\">scholar</a>");
                writer.write("|");
                writer.write("<a href=\"http://www.google.com/search?q=" + string + "\" target=\"taxonomy_window\">google</a>");
            }
            writer.write("]");
        }
    }

    private static final void addToCountMap(Map<String, Integer> map, String string) {
        if (map.containsKey(string)) {
            map.put(string, map.get(string) + 1);
        } else {
            map.put(string, 1);
        }
    }

    private static void calculateIndependentDomainCombinationGains(Phylogeny phylogeny, String string, String string2, String string3, String string4, String string5, String string6, String string7, Map<String, DescriptiveStatistics> map, Map<String, DescriptiveStatistics> map2, Map<String, DescriptiveStatistics> map3) {
        try {
            Object object222;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(string2));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(string3));
            BufferedWriter bufferedWriter4 = new BufferedWriter(new FileWriter(string4));
            TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
            Object object7 = phylogeny.iteratorPostorder();
            while (object7.hasNext()) {
                object6 = object7.next();
                object5 = ((PhylogenyNode)object6).getNodeData().getBinaryCharacters().getGainedCharacters();
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (String)object4.next();
                    if (treeMap.containsKey(object3)) {
                        treeMap.put(object3, (Integer)treeMap.get(object3) + 1);
                        continue;
                    }
                    treeMap.put(object3, 1);
                }
            }
            object7 = new TreeMap();
            object6 = new TreeMap();
            object5 = new TreeMap();
            object4 = new TreeMap();
            object3 = new TreeMap();
            TreeMap<Integer, String[]> treeMap2 = new TreeMap<Integer, String[]>();
            TreeMap treeMap3 = new TreeMap();
            Set set = treeMap.keySet();
            TreeSet<TreeMap<String, Integer>> treeSet = new TreeSet<TreeMap<String, Integer>>();
            BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics basicDescriptiveStatistics2 = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics basicDescriptiveStatistics3 = new BasicDescriptiveStatistics();
            BasicDescriptiveStatistics basicDescriptiveStatistics4 = new BasicDescriptiveStatistics();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            for (Object object222 : set) {
                double d;
                Object object;
                Object object9;
                int n = (Integer)treeMap.get(object222);
                if (object7.containsKey(n)) {
                    object7.put(n, (Integer)object7.get(n) + 1);
                    ((StringBuilder)object6.get(n)).append(", " + object222);
                    ((PriorityQueue)treeMap2.get(n)).addAll(SurfacingUtil.splitDomainCombination(object222));
                    ((SortedSet)treeMap3.get(n)).addAll(SurfacingUtil.splitDomainCombination(object222));
                } else {
                    object7.put(n, 1);
                    object6.put(n, new StringBuilder((String)object222));
                    object9 = new PriorityQueue();
                    ((AbstractQueue)object9).addAll(SurfacingUtil.splitDomainCombination(object222));
                    treeMap2.put(n, (String[])object9);
                    TreeSet<String> treeSet2 = new TreeSet<String>();
                    treeSet2.addAll(SurfacingUtil.splitDomainCombination(object222));
                    treeMap3.put(n, treeSet2);
                }
                if (map != null) {
                    if (!object5.containsKey(n)) {
                        object5.put(n, new BasicDescriptiveStatistics());
                    }
                    ((DescriptiveStatistics)object5.get(n)).addValue(map.get(object222).arithmeticMean());
                }
                if (map2 != null) {
                    if (!object4.containsKey(n)) {
                        object4.put(n, new BasicDescriptiveStatistics());
                    }
                    ((DescriptiveStatistics)object4.get(n)).addValue(map2.get(object222).arithmeticMean());
                }
                if (map3 != null) {
                    if (!object3.containsKey(n)) {
                        object3.put(n, new BasicDescriptiveStatistics());
                    }
                    object9 = ((String)object222).split("=");
                    ((DescriptiveStatistics)object3.get(n)).addValue(map3.get(object9[0]).arithmeticMean());
                    ((DescriptiveStatistics)object3.get(n)).addValue(map3.get(object9[1]).arithmeticMean());
                }
                if (n > 1) {
                    treeSet.add((TreeMap<String, Integer>)object222);
                    if (map != null) {
                        object9 = map.get(object222);
                        for (double d2 : object9.getData()) {
                            basicDescriptiveStatistics3.addValue(d2);
                        }
                    }
                    if (map2 != null) {
                        object9 = map2.get(object222);
                        for (double d2 : object9.getData()) {
                            basicDescriptiveStatistics4.addValue(d2);
                        }
                    }
                    if (map3 == null) continue;
                    object9 = ((String)object222).split("=");
                    DescriptiveStatistics descriptiveStatistics = map3.get(object9[0]);
                    DescriptiveStatistics descriptiveStatistics2 = map3.get(object9[1]);
                    object = descriptiveStatistics.getData().iterator();
                    while (object.hasNext()) {
                        d = (Double)object.next();
                        l = (long)((double)l + d);
                        ++l3;
                    }
                    object = descriptiveStatistics2.getData().iterator();
                    while (object.hasNext()) {
                        d = (Double)object.next();
                        l = (long)((double)l + d);
                        ++l3;
                    }
                    continue;
                }
                if (map != null) {
                    object9 = map.get(object222);
                    for (double d3 : object9.getData()) {
                        basicDescriptiveStatistics.addValue(d3);
                    }
                }
                if (map2 != null) {
                    object9 = map2.get(object222);
                    for (double d4 : object9.getData()) {
                        basicDescriptiveStatistics2.addValue(d4);
                    }
                }
                if (map3 == null) continue;
                object9 = ((String)object222).split("=");
                DescriptiveStatistics descriptiveStatistics = map3.get(object9[0]);
                DescriptiveStatistics descriptiveStatistics3 = map3.get(object9[1]);
                object = descriptiveStatistics.getData().iterator();
                while (object.hasNext()) {
                    d = (Double)object.next();
                    l2 = (long)((double)l2 + d);
                    ++l4;
                }
                object = descriptiveStatistics3.getData().iterator();
                while (object.hasNext()) {
                    d = (Double)object.next();
                    l2 = (long)((double)l2 + d);
                    ++l4;
                }
            }
            Set set2 = object7.keySet();
            object222 = set2.iterator();
            while (object222.hasNext()) {
                Integer n = (Integer)object222.next();
                int n2 = (Integer)object7.get(n);
                StringBuilder stringBuilder = (StringBuilder)object6.get(n);
                bufferedWriter.write(n + "\t" + n2 + ForesterUtil.LINE_SEPARATOR);
                bufferedWriter2.write(n + "\t" + stringBuilder + ForesterUtil.LINE_SEPARATOR);
                bufferedWriter3.write("#" + n + ForesterUtil.LINE_SEPARATOR);
                Object[] objectArray = ((PriorityQueue)treeMap2.get(n)).toArray();
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    bufferedWriter3.write(object + ForesterUtil.LINE_SEPARATOR);
                }
                bufferedWriter4.write("#" + n + ForesterUtil.LINE_SEPARATOR);
                for (String string8 : (SortedSet)treeMap3.get(n)) {
                    bufferedWriter4.write(string8 + ForesterUtil.LINE_SEPARATOR);
                }
            }
            bufferedWriter.close();
            bufferedWriter2.close();
            bufferedWriter3.close();
            bufferedWriter4.close();
            object222 = new TreeMap<String, Integer>();
            TreeMap<String, Integer> treeMap4 = new TreeMap<String, Integer>();
            for (String string9 : treeSet) {
                ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
                PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
                while (phylogenyNodeIterator.hasNext()) {
                    PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                    if (!phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharacters().contains(string9)) continue;
                    arrayList.add(phylogenyNode);
                }
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    for (int j = i + 1; j < arrayList.size(); ++j) {
                        Object object;
                        PhylogenyNode phylogenyNode = PhylogenyMethods.calculateLCA((PhylogenyNode)arrayList.get(i), (PhylogenyNode)arrayList.get(j));
                        object = "unknown";
                        if (phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank())) {
                            object = phylogenyNode.getNodeData().getTaxonomy().getRank();
                        }
                        SurfacingUtil.addToCountMap(object222, (String)object);
                        String string10 = phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) ? phylogenyNode.getNodeData().getTaxonomy().getScientificName() : (phylogenyNode.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) ? phylogenyNode.getNodeData().getTaxonomy().getCommonName() : phylogenyNode.getName());
                        SurfacingUtil.addToCountMap(treeMap4, string10);
                    }
                }
            }
            BufferedWriter bufferedWriter5 = new BufferedWriter(new FileWriter(string5));
            BufferedWriter bufferedWriter6 = new BufferedWriter(new FileWriter(string6));
            ForesterUtil.map2writer(bufferedWriter5, object222, "\t", ForesterUtil.LINE_SEPARATOR);
            ForesterUtil.map2writer(bufferedWriter6, treeMap4, "\t", ForesterUtil.LINE_SEPARATOR);
            bufferedWriter5.close();
            bufferedWriter6.close();
            if (!(ForesterUtil.isEmpty(string7) || map3 == null && map == null && map2 == null)) {
                BufferedWriter bufferedWriter7 = new BufferedWriter(new FileWriter(string7));
                bufferedWriter7.write("Domain Lengths: ");
                bufferedWriter7.write("\n");
                if (map3 != null) {
                    for (Map.Entry entry : object3.entrySet()) {
                        bufferedWriter7.write(((Integer)entry.getKey()).toString());
                        bufferedWriter7.write("\t" + ((DescriptiveStatistics)entry.getValue()).arithmeticMean());
                        bufferedWriter7.write("\t" + ((DescriptiveStatistics)entry.getValue()).median());
                        bufferedWriter7.write("\n");
                    }
                }
                bufferedWriter7.flush();
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Protein Lengths: ");
                bufferedWriter7.write("\n");
                if (map != null) {
                    for (Map.Entry entry : object5.entrySet()) {
                        bufferedWriter7.write(((Integer)entry.getKey()).toString());
                        bufferedWriter7.write("\t" + ((DescriptiveStatistics)entry.getValue()).arithmeticMean());
                        bufferedWriter7.write("\t" + ((DescriptiveStatistics)entry.getValue()).median());
                        bufferedWriter7.write("\n");
                    }
                }
                bufferedWriter7.flush();
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Number of domains: ");
                bufferedWriter7.write("\n");
                if (map2 != null) {
                    for (Map.Entry entry : object4.entrySet()) {
                        bufferedWriter7.write(((Integer)entry.getKey()).toString());
                        bufferedWriter7.write("\t" + ((DescriptiveStatistics)entry.getValue()).arithmeticMean());
                        bufferedWriter7.write("\t" + ((DescriptiveStatistics)entry.getValue()).median());
                        bufferedWriter7.write("\n");
                    }
                }
                bufferedWriter7.flush();
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Gained once, domain lengths:");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("N: " + l4);
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Avg: " + (double)l2 / (double)l4);
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Gained multiple times, domain lengths:");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("N: " + l3);
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Avg: " + (double)l / (double)l3);
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Gained once, protein lengths:");
                bufferedWriter7.write("\n");
                bufferedWriter7.write(basicDescriptiveStatistics.toString());
                basicDescriptiveStatistics = null;
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Gained once, domain counts:");
                bufferedWriter7.write("\n");
                bufferedWriter7.write(basicDescriptiveStatistics2.toString());
                basicDescriptiveStatistics2 = null;
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Gained multiple times, protein lengths:");
                bufferedWriter7.write("\n");
                bufferedWriter7.write(basicDescriptiveStatistics3.toString());
                basicDescriptiveStatistics3 = null;
                bufferedWriter7.write("\n");
                bufferedWriter7.write("\n");
                bufferedWriter7.write("Gained multiple times, domain counts:");
                bufferedWriter7.write("\n");
                bufferedWriter7.write(basicDescriptiveStatistics4.toString());
                bufferedWriter7.flush();
                bufferedWriter7.close();
            }
        }
        catch (IOException iOException) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + iOException);
        }
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch counts to [" + string + "]");
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch lists to [" + string2 + "]");
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch lists to (for GO mapping) [" + string3 + "]");
        ForesterUtil.programMessage("surfacing", "Wrote independent domain combination gains fitch lists to (for GO mapping, unique) [" + string4 + "]");
    }

    private static SortedSet<String> collectAllDomainsChangedOnSubtree(PhylogenyNode phylogenyNode, boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (PhylogenyNode phylogenyNode2 : PhylogenyMethods.getAllDescendants(phylogenyNode)) {
            BinaryCharacters binaryCharacters = phylogenyNode2.getNodeData().getBinaryCharacters();
            if (bl) {
                treeSet.addAll(binaryCharacters.getGainedCharacters());
                continue;
            }
            treeSet.addAll(binaryCharacters.getLostCharacters());
        }
        return treeSet;
    }

    private static File createBaseDirForPerNodeDomainFiles(String string, boolean bl, CharacterStateMatrix.GainLossStates gainLossStates, String string2) {
        File file = new File(new File(string2).getParent() + ForesterUtil.FILE_SEPARATOR + string);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!(file = bl ? new File(file + ForesterUtil.FILE_SEPARATOR + "DC") : new File(file + ForesterUtil.FILE_SEPARATOR + "DOMAINS")).exists()) {
            file.mkdir();
        }
        if (!(file = gainLossStates == CharacterStateMatrix.GainLossStates.GAIN ? new File(file + ForesterUtil.FILE_SEPARATOR + "GAINS") : (gainLossStates == CharacterStateMatrix.GainLossStates.LOSS ? new File(file + ForesterUtil.FILE_SEPARATOR + "LOSSES") : new File(file + ForesterUtil.FILE_SEPARATOR + "PRESENT"))).exists()) {
            file.mkdir();
        }
        return file;
    }

    private static SortedSet<BinaryDomainCombination> createSetOfAllBinaryDomainCombinationsPerGenome(GenomeWideCombinableDomains genomeWideCombinableDomains) {
        SortedMap<String, CombinableDomains> sortedMap = genomeWideCombinableDomains.getAllCombinableDomainsIds();
        TreeSet<BinaryDomainCombination> treeSet = new TreeSet<BinaryDomainCombination>();
        for (String string : sortedMap.keySet()) {
            CombinableDomains combinableDomains = (CombinableDomains)sortedMap.get(string);
            treeSet.addAll(combinableDomains.toBinaryDomainCombinations());
        }
        return treeSet;
    }

    private static void printSomeStats(DescriptiveStatistics descriptiveStatistics, AsciiHistogram asciiHistogram, Writer writer) throws IOException {
        writer.write("<hr>");
        writer.write("<br>");
        writer.write(SurfacingConstants.NL);
        writer.write("<tt><pre>");
        writer.write(SurfacingConstants.NL);
        if (asciiHistogram != null) {
            writer.write(asciiHistogram.toStringBuffer(20, '|', 40, 5).toString());
            writer.write(SurfacingConstants.NL);
        }
        writer.write("</pre></tt>");
        writer.write(SurfacingConstants.NL);
        writer.write("<table>");
        writer.write(SurfacingConstants.NL);
        writer.write("<tr><td>N: </td><td>" + descriptiveStatistics.getN() + "</td></tr>");
        writer.write(SurfacingConstants.NL);
        writer.write("<tr><td>Min: </td><td>" + descriptiveStatistics.getMin() + "</td></tr>");
        writer.write(SurfacingConstants.NL);
        writer.write("<tr><td>Max: </td><td>" + descriptiveStatistics.getMax() + "</td></tr>");
        writer.write(SurfacingConstants.NL);
        writer.write("<tr><td>Mean: </td><td>" + descriptiveStatistics.arithmeticMean() + "</td></tr>");
        writer.write(SurfacingConstants.NL);
        if (descriptiveStatistics.getN() > 1) {
            writer.write("<tr><td>SD: </td><td>" + descriptiveStatistics.sampleStandardDeviation() + "</td></tr>");
        } else {
            writer.write("<tr><td>SD: </td><td>n/a</td></tr>");
        }
        writer.write(SurfacingConstants.NL);
        writer.write("</table>");
        writer.write(SurfacingConstants.NL);
        writer.write("<br>");
        writer.write(SurfacingConstants.NL);
    }

    private static List<String> splitDomainCombination(String string) {
        String[] stringArray = string.split("=");
        if (stringArray.length != 2) {
            ForesterUtil.printErrorMessage("surfacing", "Stringyfied domain combination has illegal format: " + string);
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(stringArray[0]);
        arrayList.add(stringArray[1]);
        return arrayList;
    }

    private static void writeAllEncounteredPfamsToFile(Map<String, List<GoId>> map, Map<GoId, GoTerm> map2, String string, SortedSet<String> sortedSet) {
        File file = new File(string + "_all_encountered_pfams");
        File file2 = new File(string + "_all_encountered_pfams_with_go_annotation");
        File file3 = new File(string + "_encountered_pfams_summary");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(file2));
            BufferedWriter bufferedWriter3 = new BufferedWriter(new FileWriter(file3));
            bufferedWriter3.write("# Pfam to GO mapping summary");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Actual summary is at the end of this file.");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Encountered Pfams without a GO mapping:");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            for (String string2 : sortedSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
                String string3 = new String(string2);
                if (map.containsKey(string3)) {
                    ++n4;
                    bufferedWriter2.write(string2);
                    bufferedWriter2.write(ForesterUtil.LINE_SEPARATOR);
                    List<GoId> list = map.get(string3);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (GoId goId : list) {
                        GoTerm goTerm = map2.get(goId);
                        if (goTerm.getGoNameSpace().isBiologicalProcess()) {
                            bl = true;
                            continue;
                        }
                        if (goTerm.getGoNameSpace().isCellularComponent()) {
                            bl2 = true;
                            continue;
                        }
                        if (!goTerm.getGoNameSpace().isMolecularFunction()) continue;
                        bl3 = true;
                    }
                    if (bl) {
                        ++n;
                    }
                    if (bl2) {
                        ++n2;
                    }
                    if (bl3) {
                        ++n3;
                    }
                    if (bl || bl3) {
                        ++n7;
                        continue;
                    }
                    ++n6;
                    continue;
                }
                ++n6;
                ++n5;
                bufferedWriter3.write(string2);
                bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)bufferedWriter).close();
            ((Writer)bufferedWriter2).close();
            ForesterUtil.programMessage("surfacing", "Wrote all [" + sortedSet.size() + "] encountered Pfams to: \"" + file + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote all [" + n4 + "] encountered Pfams with GO mappings to: \"" + file2 + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote summary (including all [" + n5 + "] encountered Pfams without GO mappings) to: \"" + file3 + "\"");
            ForesterUtil.programMessage("surfacing", "Sum of Pfams encountered                : " + sortedSet.size());
            ForesterUtil.programMessage("surfacing", "Pfams without a mapping                 : " + n5 + " [" + 100 * n5 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams without mapping to proc. or func. : " + n6 + " [" + 100 * n6 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping                    : " + n4 + " [" + 100 * n4 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping to proc. or func.  : " + n7 + " [" + 100 * n7 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to biological process: " + n + " [" + 100 * n / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to molecular function: " + n3 + " [" + 100 * n3 / sortedSet.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to cellular component: " + n2 + " [" + 100 * n2 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Sum of Pfams encountered                : " + sortedSet.size());
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams without a mapping                 : " + n5 + " [" + 100 * n5 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams without mapping to proc. or func. : " + n6 + " [" + 100 * n6 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with a mapping                    : " + n4 + " [" + 100 * n4 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with a mapping to proc. or func.  : " + n7 + " [" + 100 * n7 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with mapping to biological process: " + n + " [" + 100 * n / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with mapping to molecular function: " + n3 + " [" + 100 * n3 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            bufferedWriter3.write("# Pfams with mapping to cellular component: " + n2 + " [" + 100 * n2 / sortedSet.size() + "%]");
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
            ((Writer)bufferedWriter3).close();
        }
        catch (IOException iOException) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + iOException);
        }
    }

    private static final void writeColorLabels(String string, Color color, Writer writer) throws IOException {
        writer.write("<tr><td><b><span style=\"color:");
        writer.write(String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
        writer.write("\">");
        writer.write(string);
        writer.write("</span></b></td></tr>");
        writer.write(SurfacingConstants.NL);
    }

    private static void writeDomainData(Map<String, List<GoId>> map, Map<GoId, GoTerm> map2, GoNameSpace goNameSpace, Writer writer, String string, String string2, String string3, String string4, Map<String, Set<String>>[] mapArray, Set<GoId> set) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 2;
        if (ForesterUtil.isEmpty(string2)) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            List<GoId> list = null;
            boolean bl3 = false;
            if (i == 0) {
                if (map.containsKey(string)) {
                    bl3 = true;
                    bl = true;
                    list = map.get(string);
                } else {
                    bl2 = true;
                }
            } else if (map.containsKey(string2)) {
                bl3 = true;
                bl = true;
                list = map.get(string2);
            }
            if (!bl3) continue;
            boolean bl4 = i == 0 || i == 1 && bl2;
            for (GoId goId : list) {
                writer.write("<tr>");
                if (bl4) {
                    bl4 = false;
                    SurfacingUtil.writeDomainIdsToHtml(writer, string, string2, string3, mapArray);
                } else {
                    writer.write("<td></td>");
                }
                if (!map2.containsKey(goId)) {
                    throw new IllegalArgumentException("GO-id [" + goId + "] not found in GO-id to GO-term map");
                }
                GoTerm goTerm = map2.get(goId);
                if (goNameSpace == null || goNameSpace.equals(goTerm.getGoNameSpace())) {
                    String string5 = goId.getId();
                    writer.write("<td>");
                    writer.write("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + string5 + "\" target=\"amigo_window\">" + string5 + "</a>");
                    writer.write("</td><td>");
                    writer.write(goTerm.getName());
                    if (n == 2) {
                        writer.write(" (" + i + ")");
                    }
                    writer.write("</td><td>");
                    writer.write("[");
                    writer.write(goTerm.getGoNameSpace().toShortString());
                    writer.write("]");
                    writer.write("</td>");
                    if (set != null) {
                        set.add(goId);
                    }
                } else {
                    writer.write("<td>");
                    writer.write("</td><td>");
                    writer.write("</td><td>");
                    writer.write("</td><td>");
                    writer.write("</td>");
                }
                writer.write("</tr>");
                writer.write(SurfacingConstants.NL);
            }
        }
        if (!bl) {
            writer.write("<tr>");
            SurfacingUtil.writeDomainIdsToHtml(writer, string, string2, string3, mapArray);
            writer.write("<td>");
            writer.write("</td><td>");
            writer.write("</td><td>");
            writer.write("</td><td>");
            writer.write("</td>");
            writer.write("</tr>");
            writer.write(SurfacingConstants.NL);
        }
    }

    private static void writeDomainIdsToHtml(Writer writer, String string, String string2, String string3, Map<String, Set<String>>[] mapArray) throws IOException {
        writer.write("<td>");
        if (!ForesterUtil.isEmpty(string3)) {
            writer.write(string3);
            writer.write(" ");
        }
        writer.write("<a href=\"http://pfam.xfam.org/family/" + string + "\">" + string + "</a>");
        writer.write("</td>");
    }

    private static void writeDomainsToIndividualFilePerTreeNode(Writer writer, String string, String string2) throws IOException {
        writer.write(string);
        writer.write(ForesterUtil.LINE_SEPARATOR);
        if (!ForesterUtil.isEmpty(string2)) {
            writer.write(string2);
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    private static void writePfamsToFile(String string, SortedSet<String> sortedSet) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string)));
            for (String string2 : sortedSet) {
                bufferedWriter.write(string2);
                bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)bufferedWriter).close();
            ForesterUtil.programMessage("surfacing", "Wrote " + sortedSet.size() + " pfams to [" + string + "]");
        }
        catch (IOException iOException) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + iOException);
        }
    }

    private static void writeToNexus(String string, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix, Phylogeny phylogeny) {
        if (!(characterStateMatrix instanceof BasicCharacterStateMatrix)) {
            throw new IllegalArgumentException("can only write matrices of type [" + BasicCharacterStateMatrix.class + "] to nexus");
        }
        BasicCharacterStateMatrix basicCharacterStateMatrix = (BasicCharacterStateMatrix)characterStateMatrix;
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>(1);
        arrayList.add(phylogeny);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("#NEXUS");
            bufferedWriter.write(ForesterUtil.LINE_SEPARATOR);
            basicCharacterStateMatrix.writeNexusTaxaBlock(bufferedWriter);
            basicCharacterStateMatrix.writeNexusBinaryChractersBlock(bufferedWriter);
            PhylogenyWriter.writeNexusTreesBlock(bufferedWriter, arrayList, PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE);
            bufferedWriter.flush();
            bufferedWriter.close();
            ForesterUtil.programMessage("surfacing", "Wrote Nexus file: \"" + string + "\"");
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError("surfacing", iOException.getMessage());
        }
    }

    private static void writeToNexus(String string, DomainParsimonyCalculator domainParsimonyCalculator, Phylogeny phylogeny) {
        SurfacingUtil.writeToNexus(string + "_dom.nex", domainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(), phylogeny);
        SurfacingUtil.writeToNexus(string + "_dc.nex", domainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(), phylogeny);
    }

    static final class DomainComparator
    implements Comparator<Domain> {
        private final boolean _ascending;

        public DomainComparator(boolean bl) {
            this._ascending = bl;
        }

        @Override
        public final int compare(Domain domain, Domain domain2) {
            if (domain.getFrom() < domain2.getFrom()) {
                return this._ascending ? -1 : 1;
            }
            if (domain.getFrom() > domain2.getFrom()) {
                return this._ascending ? 1 : -1;
            }
            return 0;
        }
    }
}

