/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.BinaryCharactersParser;
import org.forester.io.parsers.phyloxml.data.BranchWidthParser;
import org.forester.io.parsers.phyloxml.data.ColorParser;
import org.forester.io.parsers.phyloxml.data.ConfidenceParser;
import org.forester.io.parsers.phyloxml.data.DateParser;
import org.forester.io.parsers.phyloxml.data.DistributionParser;
import org.forester.io.parsers.phyloxml.data.EventParser;
import org.forester.io.parsers.phyloxml.data.IdentifierParser;
import org.forester.io.parsers.phyloxml.data.PropertyParser;
import org.forester.io.parsers.phyloxml.data.ReferenceParser;
import org.forester.io.parsers.phyloxml.data.SequenceParser;
import org.forester.io.parsers.phyloxml.data.SequenceRelationParser;
import org.forester.io.parsers.phyloxml.data.TaxonomyParser;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesList;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.FailedConditionCheckException;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PhyloXmlHandler
extends DefaultHandler {
    private static final String PHYLOXML = "phyloxml";
    private String _current_element_name;
    private Phylogeny _current_phylogeny;
    private List<Phylogeny> _phylogenies;
    private XmlElement _current_xml_element;
    private PhylogenyNode _current_node;
    private static Map<Phylogeny, HashMap<String, Sequence>> phylogenySequencesById = new HashMap<Phylogeny, HashMap<String, Sequence>>();

    PhyloXmlHandler() {
    }

    private void addNode() {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        this.getCurrentNode().addAsChild(phylogenyNode);
        this.setCurrentNode(phylogenyNode);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.getCurrentXmlElement() != null && this.getCurrentElementName() != null && !this.getCurrentElementName().equals("clade") && !this.getCurrentElementName().equals("phylogeny")) {
            if (!ForesterUtil.isEmpty(this.getCurrentXmlElement().getValueAsString())) {
                this.getCurrentXmlElement().appendValue(new String(cArray, n, n2));
            } else {
                this.getCurrentXmlElement().setValue(new String(cArray, n, n2));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endElement(String var1_1, String var2_2, String var3_3) throws SAXException {
        if (ForesterUtil.isEmpty(var1_1) || var1_1.startsWith("http://www.phyloxml.org")) {
            if (var2_2.equals("clade")) {
                try {
                    this.mapElementToPhylogenyNode(this.getCurrentXmlElement(), this.getCurrentNode());
                    if (!this.getCurrentNode().isRoot()) {
                        this.setCurrentNode(this.getCurrentNode().getParent());
                    }
                    this.getCurrentXmlElement().setValue(null);
                    this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
                }
                catch (PhylogenyParserException var4_4) {
                    throw new SAXException(var4_4.getMessage());
                }
                catch (PhyloXmlDataFormatException var4_5) {
                    throw new SAXException(var4_5.getMessage());
                }
            }
            if (var2_2.equals("sequence_relation")) {
                try {
                    if (this.getCurrentPhylogeny() == null) ** GOTO lbl60
                    var4_6 = (SequenceRelation)SequenceRelationParser.getInstance(this.getCurrentPhylogeny()).parse(this.getCurrentXmlElement());
                    var5_10 = PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this.getCurrentPhylogeny());
                    var6_11 = var5_10.get(var4_6.getRef0().getSourceId());
                    var7_12 = var5_10.get(var4_6.getRef1().getSourceId());
                    if (var6_11 != null) {
                        var8_13 = false;
                        for (SequenceRelation var10_16 : var6_11.getSequenceRelations()) {
                            if (!var10_16.getType().equals((Object)var4_6.getType()) || (!var10_16.getRef0().isEqual(var7_12) || !var10_16.getRef1().isEqual(var6_11)) && (!var10_16.getRef0().isEqual(var6_11) || !var10_16.getRef1().isEqual(var7_12))) continue;
                            var8_13 = true;
                            if (var10_16.getConfidence() != null || var4_6.getConfidence() == null) continue;
                            var10_16.setConfidence(var4_6.getConfidence());
                        }
                        if (!var8_13) {
                            var6_11.addSequenceRelation(var4_6);
                        }
                    }
                    if (var7_12 != null) {
                        var8_13 = false;
                        for (SequenceRelation var10_16 : var7_12.getSequenceRelations()) {
                            if (!var10_16.getType().equals((Object)var4_6.getType()) || (!var10_16.getRef0().isEqual(var7_12) || !var10_16.getRef1().isEqual(var6_11)) && (!var10_16.getRef0().isEqual(var6_11) || !var10_16.getRef1().isEqual(var7_12))) continue;
                            var8_13 = true;
                            if (var10_16.getConfidence() != null || var4_6.getConfidence() == null) continue;
                            var10_16.setConfidence(var4_6.getConfidence());
                        }
                        if (!var8_13) {
                            var7_12.addSequenceRelation(var4_6);
                        }
                    }
                    if ((var8_14 = this.getCurrentPhylogeny().getRelevantSequenceRelationTypes()).contains((Object)var4_6.getType())) ** GOTO lbl60
                    var8_14.add(var4_6.getType());
                }
                catch (PhyloXmlDataFormatException var4_7) {
                    throw new SAXException(var4_7.getMessage());
                }
            } else if (var2_2.equals("phylogeny")) {
                try {
                    PhyloXmlHandler.mapElementToPhylogeny(this.getCurrentXmlElement(), this.getCurrentPhylogeny());
                }
                catch (PhylogenyParserException var4_8) {
                    throw new SAXException(var4_8.getMessage());
                }
                catch (PhyloXmlDataFormatException var4_9) {
                    throw new SAXException(var4_9.getMessage());
                }
                this.finishPhylogeny();
                this.reset();
            } else if (!var2_2.equals("phyloxml") && this.getCurrentPhylogeny() != null && this.getCurrentXmlElement().getParent() != null) {
                this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
            }
lbl60:
            // 8 sources

            this.setCurrentElementName(null);
        }
    }

    private void finishPhylogeny() throws SAXException {
        this.getCurrentPhylogeny().recalculateNumberOfExternalDescendants(false);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
        HashMap<String, Sequence> hashMap = phylogenySequencesById.get(this.getCurrentPhylogeny());
        if (hashMap != null) {
            this.getCurrentPhylogeny().setSequenceRelationQueries(hashMap.values());
            phylogenySequencesById.remove(this.getCurrentPhylogeny());
        }
    }

    private String getCurrentElementName() {
        return this._current_element_name;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private XmlElement getCurrentXmlElement() {
        return this._current_xml_element;
    }

    List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private void init() {
        this.reset();
        this.setPhylogenies(new ArrayList<Phylogeny>());
    }

    private void initCurrentNode() {
        if (this.getCurrentNode() != null) {
            throw new FailedConditionCheckException("attempt to create new current node when current node already exists");
        }
        if (this.getCurrentPhylogeny() == null) {
            throw new FailedConditionCheckException("attempt to create new current node for non-existing phylogeny");
        }
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        this.getCurrentPhylogeny().setRoot(phylogenyNode);
        this.setCurrentNode(this.getCurrentPhylogeny().getRoot());
    }

    private void mapElementToPhylogenyNode(XmlElement xmlElement, PhylogenyNode phylogenyNode) throws PhylogenyParserException, PhyloXmlDataFormatException {
        String string;
        if (xmlElement.isHasAttribute("branch_length")) {
            double d = 0.0;
            try {
                d = Double.parseDouble(xmlElement.getAttribute("branch_length"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new PhylogenyParserException("ill formatted distance in clade attribute [" + xmlElement.getAttribute("branch_length") + "]: " + numberFormatException.getMessage());
            }
            phylogenyNode.setDistanceToParent(d);
        }
        if (xmlElement.isHasAttribute("collapse") && !ForesterUtil.isEmpty(string = xmlElement.getAttribute("collapse")) && string.trim().equalsIgnoreCase("true")) {
            phylogenyNode.setCollapse(true);
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            PhylogenyData phylogenyData;
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            String string2 = xmlElement2.getQualifiedName();
            if (string2.equals("branch_length")) {
                if (phylogenyNode.getDistanceToParent() != -1024.0) {
                    throw new PhylogenyParserException("ill advised attempt to set distance twice for the same clade (probably via element and via attribute)");
                }
                phylogenyNode.setDistanceToParent(xmlElement2.getValueAsDouble());
            }
            if (string2.equals("name")) {
                phylogenyNode.setName(xmlElement2.getValueAsString());
                continue;
            }
            if (string2.equals("taxonomy")) {
                phylogenyNode.getNodeData().addTaxonomy((Taxonomy)TaxonomyParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("sequence")) {
                phylogenyData = (Sequence)SequenceParser.getInstance().parse(xmlElement2);
                phylogenyNode.getNodeData().addSequence((Sequence)phylogenyData);
                String string3 = ((Sequence)phylogenyData).getSourceId();
                if (this.getCurrentPhylogeny() == null || ForesterUtil.isEmpty(string3)) continue;
                PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this.getCurrentPhylogeny()).put(string3, (Sequence)phylogenyData);
                continue;
            }
            if (string2.equals("distribution")) {
                phylogenyNode.getNodeData().addDistribution((Distribution)DistributionParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("date")) {
                phylogenyNode.getNodeData().setDate((Date)DateParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("reference")) {
                phylogenyNode.getNodeData().addReference((Reference)ReferenceParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("binary_characters")) {
                phylogenyNode.getNodeData().setBinaryCharacters((BinaryCharacters)BinaryCharactersParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("color")) {
                phylogenyNode.getBranchData().setBranchColor((BranchColor)ColorParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("confidence")) {
                phylogenyNode.getBranchData().addConfidence((Confidence)ConfidenceParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("width")) {
                phylogenyNode.getBranchData().setBranchWidth((BranchWidth)BranchWidthParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string2.equals("events")) {
                phylogenyNode.getNodeData().setEvent((Event)EventParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!string2.equals("property")) continue;
            phylogenyData = (Property)PropertyParser.getInstance().parse(xmlElement2);
            if (((Property)phylogenyData).getRef().startsWith("style:") && ((Property)phylogenyData).getAppliesTo() == Property.AppliesTo.NODE) {
                if (phylogenyNode.getNodeData().getNodeVisualData() == null) {
                    phylogenyNode.getNodeData().setNodeVisualData(new NodeVisualData());
                }
                phylogenyNode.getNodeData().getNodeVisualData().parseProperty((Property)phylogenyData);
                continue;
            }
            if (!phylogenyNode.getNodeData().isHasProperties()) {
                phylogenyNode.getNodeData().setProperties(new PropertiesList());
            }
            phylogenyNode.getNodeData().getProperties().addProperty((Property)phylogenyData);
        }
    }

    private void newClade() {
        if (this.getCurrentNode() == null) {
            this.initCurrentNode();
        } else {
            this.addNode();
        }
    }

    private void newPhylogeny() {
        this.setCurrentPhylogeny(new Phylogeny());
    }

    private void reset() {
        this.setCurrentPhylogeny(null);
        this.setCurrentNode(null);
        this.setCurrentElementName(null);
        this.setCurrentXmlElement(null);
    }

    private void setCurrentElementName(String string) {
        this._current_element_name = string;
    }

    private void setCurrentNode(PhylogenyNode phylogenyNode) {
        this._current_node = phylogenyNode;
    }

    private void setCurrentPhylogeny(Phylogeny phylogeny) {
        this._current_phylogeny = phylogeny;
    }

    private void setCurrentXmlElement(XmlElement xmlElement) {
        this._current_xml_element = xmlElement;
    }

    private void setPhylogenies(List<Phylogeny> list) {
        this._phylogenies = list;
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (ForesterUtil.isEmpty(string) || string.startsWith("http://www.phyloxml.org")) {
            this.setCurrentElementName(string2);
            if (string2.equals("clade")) {
                XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
                this.getCurrentXmlElement().addChildElement(xmlElement);
                this.setCurrentXmlElement(xmlElement);
                this.newClade();
            } else if (string2.equals("phylogeny")) {
                this.setCurrentXmlElement(new XmlElement("", "", "", null));
                this.newPhylogeny();
                XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
                if (xmlElement.isHasAttribute("rerootable")) {
                    this.getCurrentPhylogeny().setRerootable(Boolean.parseBoolean(xmlElement.getAttribute("rerootable")));
                }
                if (xmlElement.isHasAttribute("branch_length_unit")) {
                    this.getCurrentPhylogeny().setDistanceUnit(xmlElement.getAttribute("branch_length_unit"));
                }
                if (xmlElement.isHasAttribute("rooted")) {
                    this.getCurrentPhylogeny().setRooted(Boolean.parseBoolean(xmlElement.getAttribute("rooted")));
                }
                if (xmlElement.isHasAttribute("type")) {
                    this.getCurrentPhylogeny().setType(xmlElement.getAttribute("type"));
                }
            } else if (!string2.equals(PHYLOXML) && this.getCurrentPhylogeny() != null) {
                XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
                this.getCurrentXmlElement().addChildElement(xmlElement);
                this.setCurrentXmlElement(xmlElement);
            }
        }
    }

    public static boolean attributeEqualsValue(XmlElement xmlElement, String string, String string2) {
        String string3 = xmlElement.getAttribute(string);
        return string3 != null && string3.equals(string2);
    }

    public static String getAtttributeValue(XmlElement xmlElement, String string) {
        String string2 = xmlElement.getAttribute(string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public static Map<String, Sequence> getSequenceMapByIdForPhylogeny(Phylogeny phylogeny) {
        HashMap<String, Sequence> hashMap = phylogenySequencesById.get(phylogeny);
        if (hashMap == null) {
            hashMap = new HashMap();
            phylogenySequencesById.put(phylogeny, hashMap);
        }
        return hashMap;
    }

    private static void mapElementToPhylogeny(XmlElement xmlElement, Phylogeny phylogeny) throws PhylogenyParserException, PhyloXmlDataFormatException {
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            String string = xmlElement2.getQualifiedName();
            if (string.equals("name")) {
                phylogeny.setName(xmlElement2.getValueAsString());
                continue;
            }
            if (string.equals("description")) {
                phylogeny.setDescription(xmlElement2.getValueAsString());
                continue;
            }
            if (string.equals("id")) {
                phylogeny.setIdentifier((Identifier)IdentifierParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!string.equals("confidence")) continue;
            phylogeny.setConfidence((Confidence)ConfidenceParser.getInstance().parse(xmlElement2));
        }
    }
}

