/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.phylogeny.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class RenderableVector
implements RenderablePhylogenyData {
    static final int VECTOR_DEFAULT_HEIGHT = 12;
    public static final int VECTOR_DEFAULT_WIDTH = 120;
    private double _rendering_factor_width = 1.0;
    private List<Double> _values = null;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private double _height = 12.0;
    private double _min;
    private double _max;
    private double _mean;
    private Color _min_color = Color.BLUE;
    private Color _max_color = Color.YELLOW;
    private Color _mean_color = Color.WHITE;
    private int _width = 120;
    private static RenderableVector _instance = null;

    private RenderableVector() {
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this._values.toString());
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    public Object clone() {
        throw new NoSuchMethodError();
    }

    @Override
    public PhylogenyData copy() {
        throw new NoSuchMethodError();
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this.getTotalLength(), (int)this.getRenderingHeight());
    }

    @Override
    public Object getParameter() {
        return null;
    }

    public double getRenderingFactorWidth() {
        return this._rendering_factor_width;
    }

    @Override
    public Dimension getRenderingSize() {
        return this.getOriginalSize();
    }

    public int getTotalLength() {
        return (int)((double)this._values.size() * this.getRenderingHeight());
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new NoSuchMethodError();
    }

    @Override
    public void render(float f, float f2, Graphics2D graphics2D, TreePanel treePanel, boolean bl) {
        double d = f2;
        double d2 = (double)f + 20.0;
        double d3 = (double)this._width / (double)this._values.size();
        for (int i = 0; i < this._values.size(); ++i) {
            graphics2D.setColor(this.calculateColor(this._values.get(i)));
            this._rectangle.setFrame(d2 + (double)i * d3, d - 0.5, d3 + 1.0, this.getRenderingHeight());
            graphics2D.fill(this._rectangle);
        }
    }

    @Override
    public void setParameter(double d) {
        throw new NoSuchMethodError();
    }

    public void setRenderingFactorWidth(double d) {
        this._rendering_factor_width = d;
    }

    @Override
    public void setRenderingHeight(float f) {
        this._height = f;
    }

    @Override
    public StringBuffer toNHX() {
        throw new NoSuchMethodError();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        throw new NoSuchMethodError();
    }

    private Color calculateColor(double d) {
        return ForesterUtil.calcColor(d, this._min, this._max, this._mean, this._min_color, this._max_color, this._mean_color);
    }

    private double getRenderingHeight() {
        return this._height;
    }

    public static RenderableVector createInstance(List<Double> list, DescriptiveStatistics descriptiveStatistics, Configuration configuration) {
        if (_instance == null) {
            _instance = new RenderableVector();
        }
        RenderableVector._instance._values = list;
        if (configuration != null) {
            RenderableVector._instance._min_color = configuration.getVectorDataMinColor();
            RenderableVector._instance._max_color = configuration.getVectorDataMaxColor();
            RenderableVector._instance._mean_color = configuration.getVectorDataMeanColor();
            RenderableVector._instance._width = configuration.getVectorDataWidth();
            RenderableVector._instance._height = configuration.getVectorDataHeight();
        }
        if (descriptiveStatistics.getN() > 0) {
            RenderableVector._instance._min = descriptiveStatistics.getMin();
            RenderableVector._instance._max = descriptiveStatistics.getMax();
            RenderableVector._instance._mean = descriptiveStatistics.arithmeticMean();
        } else {
            RenderableVector._instance._min = 0.0;
            RenderableVector._instance._max = 0.0;
            RenderableVector._instance._mean = 0.0;
            AptxUtil.printWarningMessage("Archaeopteryx", "creating renderable vector with empty statistics");
        }
        return _instance;
    }
}

