/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Font;
import org.forester.archaeopteryx.AptxConstants;
import org.forester.archaeopteryx.Configuration;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.util.ForesterUtil;

public final class Options {
    static final double MIN_CONFIDENCE_DEFAULT = 0.0;
    private boolean _abbreviate_scientific_names;
    private boolean _allow_errors_in_distance_to_parent;
    private boolean _antialias_print;
    private boolean _antialias_screen;
    private boolean _background_color_gradient;
    private Font _base_font;
    private CLADOGRAM_TYPE _cladogram_type;
    private boolean _color_by_taxonomic_group;
    private boolean _color_labels_same_as_parent_branch;
    private NodeVisualData.NodeFill _default_node_fill;
    private NodeVisualData.NodeShape _default_node_shape;
    private short _default_node_shape_size;
    private boolean _editable;
    private NodeDataField _ext_desc_data_to_return;
    private final boolean _graphics_export_using_actual_size = true;
    private boolean _graphics_export_visible_only;
    private boolean _internal_number_are_confidence_for_nh_parsing;
    private boolean _inverse_search_result;
    private boolean _match_whole_terms_only;
    private boolean _search_with_regex;
    private double _min_confidence_value;
    private PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE _nh_conversion_support_value_style;
    private boolean _nh_parsing_replace_underscores;
    private NODE_LABEL_DIRECTION _node_label_direction;
    private short _number_of_digits_after_comma_for_branch_length_values;
    private short _number_of_digits_after_comma_for_confidence_values;
    private OVERVIEW_PLACEMENT_TYPE _ov_placement;
    private PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type;
    private boolean _print_black_and_white;
    private float _print_line_width;
    private final boolean _print_using_actual_size = true;
    private double _scale_bar_length;
    private boolean _search_case_sensitive;
    private boolean _show_annotation_ref_source;
    private boolean _show_confidence_stddev;
    private boolean _show_default_node_shapes_for_marked_nodes;
    private boolean _show_default_node_shapes_external;
    private boolean _show_default_node_shapes_internal;
    private boolean _show_domain_labels;
    private boolean _show_overview;
    private boolean _show_scale;
    private NHXParser.TAXONOMY_EXTRACTION _taxonomy_extraction;
    private boolean _line_up_renderable_node_data;
    private boolean _right_align_domains;
    private boolean _color_all_found_nodes_when_coloring_subtree;
    private boolean _parse_beast_style_extended_nexus_tags;
    private boolean _collapsed_with_average_height;
    private boolean _show_abbreviated_labels_for_collapsed_nodes;

    private Options() {
        this.init();
    }

    public NodeDataField getExtDescNodeDataToReturn() {
        return this._ext_desc_data_to_return;
    }

    public boolean isAllowErrorsInDistanceToParent() {
        return this._allow_errors_in_distance_to_parent;
    }

    public final boolean isLineUpRendarableNodeData() {
        return this._line_up_renderable_node_data;
    }

    public final boolean isRightLineUpDomains() {
        return this._right_align_domains;
    }

    public final boolean isShowAnnotationRefSource() {
        return this._show_annotation_ref_source;
    }

    public final boolean isShowDomainLabels() {
        return this._show_domain_labels;
    }

    public final void setAllowErrorsInDistanceToParent(boolean bl) {
        this._allow_errors_in_distance_to_parent = bl;
    }

    public void setBackgroundColorGradient(boolean bl) {
        this._background_color_gradient = bl;
    }

    public void setColorLabelsSameAsParentBranch(boolean bl) {
        this._color_labels_same_as_parent_branch = bl;
    }

    public void setExtDescNodeDataToReturn(NodeDataField nodeDataField) {
        this._ext_desc_data_to_return = nodeDataField;
    }

    public final void setLineUpRendarableNodeData(boolean bl) {
        this._line_up_renderable_node_data = bl;
    }

    public final void setRightLineUpDomains(boolean bl) {
        this._right_align_domains = bl;
    }

    public final void setShowAnnotationRefSource(boolean bl) {
        this._show_annotation_ref_source = bl;
    }

    public void setShowDomainLabels(boolean bl) {
        this._show_domain_labels = bl;
    }

    private final void init() {
        this._default_node_shape = NodeVisualData.NodeShape.CIRCLE;
        this._default_node_fill = NodeVisualData.NodeFill.GRADIENT;
        this._default_node_shape_size = (short)7;
        this._internal_number_are_confidence_for_nh_parsing = false;
        this._show_scale = false;
        this._antialias_screen = true;
        this._antialias_print = true;
        this._graphics_export_visible_only = false;
        this._editable = true;
        this._background_color_gradient = false;
        this._show_default_node_shapes_internal = false;
        this._show_default_node_shapes_external = false;
        this._show_default_node_shapes_for_marked_nodes = false;
        this._color_all_found_nodes_when_coloring_subtree = false;
        this._parse_beast_style_extended_nexus_tags = true;
        this._min_confidence_value = 0.0;
        this._print_black_and_white = false;
        this._phylogeny_graphics_type = PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
        this._base_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
        this._match_whole_terms_only = false;
        this._search_with_regex = false;
        this._search_case_sensitive = false;
        this._print_line_width = 0.5f;
        this._show_overview = true;
        this._ov_placement = OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
        this._node_label_direction = NODE_LABEL_DIRECTION.HORIZONTAL;
        this._inverse_search_result = false;
        this._scale_bar_length = 0.0;
        this._number_of_digits_after_comma_for_branch_length_values = (short)3;
        this._number_of_digits_after_comma_for_confidence_values = (short)2;
        this._nh_parsing_replace_underscores = false;
        this._taxonomy_extraction = NHXParser.TAXONOMY_EXTRACTION.NO;
        this._cladogram_type = AptxConstants.CLADOGRAM_TYPE_DEFAULT;
        this._show_domain_labels = true;
        this._show_annotation_ref_source = true;
        this.setAbbreviateScientificTaxonNames(false);
        this._color_labels_same_as_parent_branch = false;
        this._show_confidence_stddev = false;
        this._nh_conversion_support_value_style = PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE.NONE;
        this._ext_desc_data_to_return = NodeDataField.UNKNOWN;
        this._line_up_renderable_node_data = true;
        this._right_align_domains = false;
        this._collapsed_with_average_height = true;
        this._show_abbreviated_labels_for_collapsed_nodes = true;
    }

    private final void setNumberOfDigitsAfterCommaForBranchLength(short s) {
        this._number_of_digits_after_comma_for_branch_length_values = s;
    }

    private final void setNumberOfDigitsAfterCommaForConfidenceValues(short s) {
        this._number_of_digits_after_comma_for_confidence_values = s;
    }

    final Font getBaseFont() {
        return this._base_font;
    }

    final CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    final NodeVisualData.NodeFill getDefaultNodeFill() {
        return this._default_node_fill;
    }

    final NodeVisualData.NodeShape getDefaultNodeShape() {
        return this._default_node_shape;
    }

    final short getDefaultNodeShapeSize() {
        return this._default_node_shape_size;
    }

    final double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE getNhConversionSupportValueStyle() {
        return this._nh_conversion_support_value_style;
    }

    final NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    final short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    final short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    final OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    final PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    final float getPrintLineWidth() {
        return this._print_line_width;
    }

    final double getScaleBarLength() {
        return this._scale_bar_length;
    }

    final NHXParser.TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    final boolean isAbbreviateScientificTaxonNames() {
        return this._abbreviate_scientific_names;
    }

    boolean isAllowMagnificationOfTaxonomyImages() {
        return true;
    }

    final boolean isAntialiasPrint() {
        return this._antialias_print;
    }

    final boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    final boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    final boolean isColorByTaxonomicGroup() {
        return this._color_by_taxonomic_group;
    }

    final boolean isColorLabelsSameAsParentBranch() {
        return this._color_labels_same_as_parent_branch;
    }

    final boolean isEditable() {
        return this._editable;
    }

    final boolean isGraphicsExportUsingActualSize() {
        return true;
    }

    final boolean isGraphicsExportVisibleOnly() {
        return this._graphics_export_visible_only;
    }

    final boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    final boolean isInverseSearchResult() {
        return this._inverse_search_result;
    }

    final boolean isMatchWholeTermsOnly() {
        return this._match_whole_terms_only;
    }

    final boolean isPrintBlackAndWhite() {
        return this._print_black_and_white;
    }

    final boolean isPrintUsingActualSize() {
        return true;
    }

    final boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    final boolean isSearchCaseSensitive() {
        return this._search_case_sensitive;
    }

    final boolean isSearchWithRegex() {
        return this._search_with_regex;
    }

    boolean isShowConfidenceStddev() {
        return this._show_confidence_stddev;
    }

    boolean isShowDefaultNodeShapesExternal() {
        return this._show_default_node_shapes_external;
    }

    boolean isShowDefaultNodeShapesForMarkedNodes() {
        return this._show_default_node_shapes_for_marked_nodes;
    }

    boolean isShowDefaultNodeShapesInternal() {
        return this._show_default_node_shapes_internal;
    }

    final boolean isShowOverview() {
        return this._show_overview;
    }

    final boolean isShowScale() {
        return this._show_scale;
    }

    final void setAbbreviateScientificTaxonNames(boolean bl) {
        this._abbreviate_scientific_names = bl;
    }

    final void setAntialiasPrint(boolean bl) {
        this._antialias_print = bl;
    }

    final void setAntialiasScreen(boolean bl) {
        this._antialias_screen = bl;
    }

    final void setBaseFont(Font font) {
        this._base_font = font;
    }

    final void setCladogramType(CLADOGRAM_TYPE cLADOGRAM_TYPE) {
        this._cladogram_type = cLADOGRAM_TYPE;
    }

    final void setColorByTaxonomicGroup(boolean bl) {
        this._color_by_taxonomic_group = bl;
    }

    final void setDefaultNodeFill(NodeVisualData.NodeFill nodeFill) {
        this._default_node_fill = nodeFill;
    }

    final void setDefaultNodeShape(NodeVisualData.NodeShape nodeShape) {
        this._default_node_shape = nodeShape;
    }

    final void setDefaultNodeShapeSize(short s) {
        this._default_node_shape_size = s;
    }

    final void setEditable(boolean bl) {
        this._editable = bl;
    }

    final void setGraphicsExportVisibleOnly(boolean bl) {
        this._graphics_export_visible_only = bl;
    }

    final void setInternalNumberAreConfidenceForNhParsing(boolean bl) {
        this._internal_number_are_confidence_for_nh_parsing = bl;
    }

    final void setInverseSearchResult(boolean bl) {
        this._inverse_search_result = bl;
    }

    final void setMatchWholeTermsOnly(boolean bl) {
        this._match_whole_terms_only = bl;
    }

    final void setMinConfidenceValue(double d) {
        this._min_confidence_value = d;
    }

    void setNhConversionSupportValueStyle(PhylogenyNode.NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) {
        this._nh_conversion_support_value_style = nH_CONVERSION_SUPPORT_VALUE_STYLE;
    }

    final void setNodeLabelDirection(NODE_LABEL_DIRECTION nODE_LABEL_DIRECTION) {
        this._node_label_direction = nODE_LABEL_DIRECTION;
    }

    final void setOvPlacement(OVERVIEW_PLACEMENT_TYPE oVERVIEW_PLACEMENT_TYPE) {
        this._ov_placement = oVERVIEW_PLACEMENT_TYPE;
    }

    final void setPhylogenyGraphicsType(PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this._phylogeny_graphics_type = pHYLOGENY_GRAPHICS_TYPE;
    }

    final void setPrintBlackAndWhite(boolean bl) {
        this._print_black_and_white = bl;
    }

    final void setPrintLineWidth(float f) {
        this._print_line_width = f;
    }

    final void setReplaceUnderscoresInNhParsing(boolean bl) {
        this._nh_parsing_replace_underscores = bl;
    }

    final void setScaleBarLength(double d) {
        this._scale_bar_length = d;
    }

    final void setSearchCaseSensitive(boolean bl) {
        this._search_case_sensitive = bl;
    }

    final void setSearchWithRegex(boolean bl) {
        this._search_with_regex = bl;
    }

    void setShowConfidenceStddev(boolean bl) {
        this._show_confidence_stddev = bl;
    }

    void setShowDefaultNodeShapesExternal(boolean bl) {
        this._show_default_node_shapes_external = bl;
    }

    void setShowDefaultNodeShapesForMarkedNodes(boolean bl) {
        this._show_default_node_shapes_for_marked_nodes = bl;
    }

    void setShowDefaultNodeShapesInternal(boolean bl) {
        this._show_default_node_shapes_internal = bl;
    }

    final void setShowOverview(boolean bl) {
        this._show_overview = bl;
    }

    final void setShowScale(boolean bl) {
        this._show_scale = bl;
    }

    final void setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        this._taxonomy_extraction = tAXONOMY_EXTRACTION;
    }

    public static final Options createInstance(Configuration configuration) {
        Options options = Options.createDefaultInstance();
        if (configuration != null) {
            options.setAntialiasScreen(configuration.isAntialiasScreen());
            options.setShowScale(configuration.isShowScale());
            options.setShowOverview(configuration.isShowOverview());
            options.setColorByTaxonomicGroup(configuration.isColorByTaxonomicGroup());
            options.setCladogramType(configuration.getCladogramType());
            options.setOvPlacement(configuration.getOvPlacement());
            options.setPrintLineWidth(configuration.getPrintLineWidth());
            options.setNodeLabelDirection(configuration.getNodeLabelDirection());
            options.setBackgroundColorGradient(configuration.isBackgroundColorGradient());
            if (configuration.getNumberOfDigitsAfterCommaForBranchLengthValues() >= 0) {
                options.setNumberOfDigitsAfterCommaForBranchLength(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
            }
            if (configuration.getNumberOfDigitsAfterCommaForConfidenceValues() >= 0) {
                options.setNumberOfDigitsAfterCommaForConfidenceValues(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
            }
            options.setTaxonomyExtraction(configuration.getTaxonomyExtraction());
            options.setReplaceUnderscoresInNhParsing(configuration.isReplaceUnderscoresInNhParsing());
            options.setInternalNumberAreConfidenceForNhParsing(configuration.isInternalNumberAreConfidenceForNhParsing());
            options.setEditable(configuration.isEditable());
            options.setColorLabelsSameAsParentBranch(configuration.isColorLabelsSameAsParentBranch());
            options.setShowDomainLabels(configuration.isShowDomainLabels());
            options.setShowAnnotationRefSource(configuration.isShowAnnotationRefSource());
            options.setAbbreviateScientificTaxonNames(configuration.isAbbreviateScientificTaxonNames());
            if (configuration.getMinConfidenceValue() != 0.0) {
                options.setMinConfidenceValue(configuration.getMinConfidenceValue());
            }
            if (configuration.getBaseFontSize() > 0) {
                options.setBaseFont(options.getBaseFont().deriveFont((float)configuration.getBaseFontSize()));
            }
            if (!ForesterUtil.isEmpty(configuration.getBaseFontFamilyName())) {
                options.setBaseFont(new Font(configuration.getBaseFontFamilyName(), 0, options.getBaseFont().getSize()));
            }
            if (configuration.getPhylogenyGraphicsType() != null) {
                options.setPhylogenyGraphicsType(configuration.getPhylogenyGraphicsType());
            }
            if (configuration.getDefaultNodeFill() != null) {
                options.setDefaultNodeFill(configuration.getDefaultNodeFill());
            }
            if (configuration.getDefaultNodeShape() != null) {
                options.setDefaultNodeShape(configuration.getDefaultNodeShape());
            }
            if (configuration.getDefaultNodeShapeSize() >= 0) {
                options.setDefaultNodeShapeSize(configuration.getDefaultNodeShapeSize());
            }
            options.setShowDefaultNodeShapesInternal(configuration.isShowDefaultNodeShapesInternal());
            options.setShowDefaultNodeShapesExternal(configuration.isShowDefaultNodeShapesExternal());
            options.setShowDefaultNodeShapesForMarkedNodes(configuration.isShowDefaultNodeShapesForMarkedNodes());
            if (configuration.getExtDescNodeDataToReturn() != null) {
                options.setExtDescNodeDataToReturn(configuration.getExtDescNodeDataToReturn());
            }
            options.setRightLineUpDomains(configuration.isRightLineUpDomains());
            options.setLineUpRendarableNodeData(configuration.isLineUpRendarableNodeData());
            options.setAllowErrorsInDistanceToParent(false);
        }
        return options;
    }

    static final Options createDefaultInstance() {
        return new Options();
    }

    final boolean isColorAllFoundNodesWhenColoringSubtree() {
        return this._color_all_found_nodes_when_coloring_subtree;
    }

    final void setColorAllFoundNodesWhenColoringSubtree(boolean bl) {
        this._color_all_found_nodes_when_coloring_subtree = bl;
    }

    final boolean isParseBeastStyleExtendedNexusTags() {
        return this._parse_beast_style_extended_nexus_tags;
    }

    final void setParseBeastStyleExtendedNexusTags(boolean bl) {
        this._parse_beast_style_extended_nexus_tags = bl;
    }

    final boolean isCollapsedWithAverageHeigh() {
        return this._collapsed_with_average_height;
    }

    final void setCollapsedWithAverageHeigh(boolean bl) {
        this._collapsed_with_average_height = bl;
    }

    final boolean isShowAbbreviatedLabelsForCollapsedNodes() {
        return this._show_abbreviated_labels_for_collapsed_nodes;
    }

    final void setShowAbbreviatedLabelsForCollapsedNodes(boolean bl) {
        this._show_abbreviated_labels_for_collapsed_nodes = bl;
    }

    static enum OVERVIEW_PLACEMENT_TYPE {
        LOWER_LEFT("lower left"),
        LOWER_RIGHT("lower right"),
        UPPER_LEFT("upper left"),
        UPPER_RIGHT("upper right");

        private final String _name;

        private OVERVIEW_PLACEMENT_TYPE(String string2) {
            this._name = string2;
        }

        public String toString() {
            return this._name;
        }

        public String toTag() {
            return this.toString().replaceAll(" ", "_");
        }
    }

    static enum PHYLOGENY_DISPLAY_TYPE {
        CLADOGRAM,
        ALIGNED_PHYLOGRAM,
        UNALIGNED_PHYLOGRAM;

    }

    public static enum PHYLOGENY_GRAPHICS_TYPE {
        CIRCULAR,
        CONVEX,
        CURVED,
        EURO_STYLE,
        RECTANGULAR,
        ROUNDED,
        TRIANGULAR,
        UNROOTED;

    }

    public static enum NODE_LABEL_DIRECTION {
        HORIZONTAL,
        RADIAL;

    }

    public static enum CLADOGRAM_TYPE {
        LINED_UP,
        NON_LINED_UP;

    }
}

