/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.forester.analysis.AncestralTaxonomyInference;
import org.forester.analysis.AncestralTaxonomyInferenceException;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;
import org.forester.ws.seqdb.SequenceDbWsTools;

public final class annotator {
    private static final String PRG_NAME = "annotator";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "131122";

    public static void main(String[] stringArray) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (stringArray.length != 2) {
            annotator.argumentsError();
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        if (!file.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, file + " is not a directory");
        }
        if (!file2.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, file2 + " is not a directory");
        }
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file3 : fileArray) {
            if (!file3.isFile() || !file3.canRead() || !file3.toString().toLowerCase().endsWith(".xml")) continue;
            arrayList.add(file3);
        }
        Collections.sort(arrayList);
        int n = 0;
        for (File file4 : arrayList) {
            Object object;
            File file3;
            System.out.println(++n + "/" + arrayList.size() + ": " + file4);
            file3 = new File(file2.getAbsolutePath().toString() + "/" + file4.getName());
            if (file3.exists()) {
                System.out.println(file3 + " already exists");
                continue;
            }
            Phylogeny phylogeny = null;
            try {
                object = ParserBasedPhylogenyFactory.getInstance();
                Phylogeny[] phylogenyArray = object.create(file4, PhyloXmlParser.createPhyloXmlParserXsdValidating());
                phylogeny = phylogenyArray[0];
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylgenies from [" + file4 + "] [" + exception.getMessage() + "]");
            }
            try {
                annotator.obtainSeqInformation(phylogeny);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
            try {
                object = new PhylogenyWriter();
                ((PhylogenyWriter)object).toPhyloXML(phylogeny, 0, file3);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write output [" + iOException.getMessage() + "]");
            }
        }
    }

    private static void obtainSeqInformation(Phylogeny phylogeny) throws IOException {
        SequenceDbWsTools.obtainSeqInformation(phylogeny, true, true, 4000);
    }

    private static void inferTaxonomyFromDescendents(Phylogeny phylogeny) throws IOException, AncestralTaxonomyInferenceException {
        AncestralTaxonomyInference.inferTaxonomyFromDescendents(phylogeny);
    }

    private static void argumentsError() {
        System.out.println("annotator <indir> <outdir>");
        System.out.println();
        System.exit(-1);
    }
}

