/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.model.DataSet;
import com.approximatrix.charting.model.DefaultChartDataModelConstraints;
import com.approximatrix.charting.model.DefaultDataSet;
import java.util.HashMap;
import java.util.TreeSet;

public class ObjectChartDataModel
extends AbstractChartDataModel {
    protected Object[] columns;
    protected DataSet[] data;
    protected HashMap valuesbyaxis = new HashMap();
    protected ChartDataModelConstraints constraints1;
    protected ChartDataModelConstraints constraints2;

    public ObjectChartDataModel() {
        this.data = new DefaultDataSet[0];
        this.columns = new Object[0];
        TreeSet set1 = new TreeSet();
        this.valuesbyaxis.put(new Integer(0), set1);
        TreeSet set2 = new TreeSet();
        this.valuesbyaxis.put(new Integer(1), set2);
        this.constraints1 = new DefaultChartDataModelConstraints(this, 0, false);
        this.constraints2 = new DefaultChartDataModelConstraints(this, 1, false);
    }

    public ObjectChartDataModel(Number[][] data, Object[] columns, String[] rows) {
        this();
        this.columns = columns;
        this.data = new DefaultDataSet[data.length];
        TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(set, data);
        int i = 0;
        while (i < data.length) {
            this.data[i] = new DefaultDataSet(data[i], columns, 0, rows[i]);
            ++i;
        }
    }

    public ObjectChartDataModel(int[][] data, Object[] columns, String[] rows) {
        this();
        Number[][] numdata = ChartUtilities.transformArray(data);
        this.columns = columns;
        this.data = new DefaultDataSet[data.length];
        TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(set, numdata);
        int i = 0;
        while (i < data.length) {
            this.data[i] = new DefaultDataSet(numdata[i], columns, 0, rows[i]);
            ++i;
        }
    }

    public ObjectChartDataModel(double[][] data, Object[] columns, String[] rows) {
        this();
        Number[][] numdata = ChartUtilities.transformArray(data);
        this.columns = columns;
        this.data = new DefaultDataSet[data.length];
        TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(0));
        ChartUtilities.addDataToSet(set, numdata);
        int i = 0;
        while (i < data.length) {
            this.data[i] = new DefaultDataSet(numdata[i], columns, 0, rows[i]);
            ++i;
        }
    }

    public ObjectChartDataModel(DataSet[] ds, Object[] columns) {
        this();
        this.data = ds;
        this.columns = columns;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int i = 0;
        while (i < ds.length) {
            map.clear();
            Object[] numdata = new Number[columns.length];
            int j = 0;
            while (j < columns.length) {
                map.put(columns[j], new Double(Double.NaN));
                ++j;
            }
            TreeSet set = (TreeSet)this.valuesbyaxis.get(new Integer(ds[i].getYAxis()));
            j = 0;
            while (j < ds[i].getDataSetLength()) {
                map.put(ds[i].getColumnValueAt(j), ds[i].getValueAt(j));
                set.add(ds[i].getValueAt(j));
                ++j;
            }
            j = 0;
            while (j < columns.length) {
                numdata[j] = (Number)map.get(columns[j]);
                ++j;
            }
            this.data[i] = new DefaultDataSet(numdata, columns, 0, ds[i].getTitle());
            ++i;
        }
    }

    @Override
    public int getDataSetLength(int set) {
        return this.data[set].getDataSetLength();
    }

    @Override
    public int getDataSetNumber() {
        return this.data.length;
    }

    @Override
    public String getDataSetName(int set) {
        return this.data[set].getTitle();
    }

    @Override
    public int getAxisBinding(int set) {
        return this.data[set].getYAxis();
    }

    @Override
    public Number getValueAt(int set, int index) {
        return (Number)this.data[set].getValueAt(index);
    }

    @Override
    public ChartDataModelConstraints getChartDataModelConstraints(int axis) {
        if (axis == 0) {
            return this.constraints1;
        }
        return this.constraints2;
    }

    @Override
    public void setChartDataModelConstraints(int axis, ChartDataModelConstraints constraints) {
        if (axis == 0) {
            this.constraints1 = constraints;
        } else {
            this.constraints2 = constraints;
        }
    }

    @Override
    public Object getColumnValueAt(int col) {
        if (this.columns == null) {
            return null;
        }
        if (col < this.columns.length && col >= 0) {
            return this.columns[col];
        }
        return null;
    }

    @Override
    public Object getColumnValueAt(int set, int col) {
        return this.getColumnValueAt(col);
    }

    @Override
    protected TreeSet getOrderedValues(int axis) {
        return (TreeSet)this.valuesbyaxis.get(new Integer(axis));
    }

    @Override
    protected double getFirstColumnValue() {
        return 0.0;
    }

    @Override
    protected double getLastColumnValue() {
        return Math.max((double)this.columns.length, 1.0);
    }
}

