/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import com.google.protobuf.ByteString;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.io.OutputStream;
import org.campagnelab.goby.compression.FastArithmeticCoder;
import org.campagnelab.goby.compression.FastArithmeticDecoder;
import org.campagnelab.goby.reads.ReadCodec;
import org.campagnelab.goby.reads.Reads;

public class ReadCodecImpl
implements ReadCodec {
    private FastArithmeticCoder sequenceCoder;
    private FastArithmeticCoder qualityScoreCoder;
    public static final int CODEC_REGISTRATION_CODE = 1;
    private boolean isFirstCode = true;
    private boolean isFirstDecode;
    int written = 0;
    private FastArithmeticDecoder sequenceDecoder;
    private FastArithmeticDecoder qualityScoreDecoder;
    ByteArrayList buffer = new ByteArrayList();

    @Override
    public String name() {
        return "read-codec-1";
    }

    @Override
    public byte registrationCode() {
        return 1;
    }

    @Override
    public Reads.ReadEntry.Builder encode(Reads.ReadEntry.Builder source) {
        Reads.ReadEntry.Builder result = Reads.ReadEntry.newBuilder();
        result.mergeFrom(source.build());
        try {
            FastByteArrayOutputStream os = new FastByteArrayOutputStream();
            OutputBitStream out = new OutputBitStream((OutputStream)os);
            if (this.isFirstCode) {
                out.writeInt(1, 8);
                this.isFirstCode = false;
            }
            int readLength = source.getReadLength();
            if (source.hasSequence()) {
                this.writeBit(out, true);
                this.compressSequence(source.getSequence(), out, readLength);
                result.clearSequence();
            } else {
                this.writeBit(out, false);
            }
            if (source.hasQualityScores()) {
                this.writeBit(out, true);
                this.compressQuality(source.getQualityScores(), out, readLength);
                result.clearQualityScores();
            } else {
                this.writeBit(out, false);
            }
            if (source.hasSequencePair()) {
                this.writeBit(out, true);
                this.compressSequence(source.getSequencePair(), out, readLength);
                result.clearSequencePair();
            } else {
                this.writeBit(out, false);
            }
            if (source.hasQualityScoresPair()) {
                this.writeBit(out, true);
                this.compressQuality(source.getQualityScoresPair(), out, readLength);
                result.clearQualityScoresPair();
            } else {
                this.writeBit(out, false);
            }
            out.close();
            ByteString compressedData = ByteString.copyFrom((byte[])os.array, (int)0, (int)((int)os.length()));
            result.setCompressedData(compressedData);
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void writeBit(OutputBitStream out, boolean bit) throws IOException {
        int i = out.writeBit(bit);
        assert (i == 1);
    }

    private void compressQuality(ByteString qualityScores, OutputBitStream out, int readLength) throws IOException {
        this.qualityScoreCoder.reset();
        for (int i = 0; i < readLength; ++i) {
            byte x = qualityScores.byteAt(i);
            this.qualityScoreCoder.encode(x, out);
        }
        this.qualityScoreCoder.flush(out);
    }

    private void compressSequence(ByteString sequence, OutputBitStream out, int readLength) throws IOException {
        this.sequenceCoder.reset();
        for (int i = 0; i < readLength; ++i) {
            int x = this.codeBase(sequence.byteAt(i));
            this.sequenceCoder.encode(x, out);
        }
        this.sequenceCoder.flush(out);
    }

    private int codeBase(byte base) {
        switch (base) {
            case 65: {
                return 0;
            }
            case 67: {
                return 1;
            }
            case 84: {
                return 2;
            }
            case 71: {
                return 3;
            }
            case 78: {
                return 4;
            }
        }
        return -1;
    }

    private byte decodeBase(int decode) {
        switch (decode) {
            case 0: {
                return 65;
            }
            case 1: {
                return 67;
            }
            case 2: {
                return 84;
            }
            case 3: {
                return 71;
            }
            case 4: {
                return 78;
            }
        }
        return -1;
    }

    @Override
    public Reads.ReadEntry.Builder decode(Reads.ReadEntry source) {
        if (!source.hasCompressedData()) {
            return null;
        }
        byte[] bytes = new byte[source.getCompressedData().size() + 40];
        source.getCompressedData().copyTo(bytes, 0);
        InputBitStream input = new InputBitStream(bytes);
        try {
            int codecRegistrationStored;
            if (this.isFirstDecode && (codecRegistrationStored = input.readInt(8)) != 1) {
                return null;
            }
            Reads.ReadEntry.Builder result = Reads.ReadEntry.newBuilder();
            result.mergeFrom(source);
            int readLength = source.getReadLength();
            this.debug("readLength=" + readLength);
            this.debug("readBits= " + input.readBits());
            if (input.readBit() == 1) {
                this.debug("hasSequence ");
                this.debug("readBits= " + input.readBits());
                ByteString sequence = this.decodeSequence(input, readLength);
                this.debug("readBits= " + input.readBits());
                result.setSequence(sequence);
            }
            if (input.readBit() == 1) {
                this.debug("hasQual ");
                this.debug("readBits= " + input.readBits());
                ByteString qual = this.decodeQualityScore(input, readLength);
                this.debug("readBits= " + input.readBits());
                result.setQualityScores(qual);
            }
            if (input.readBit() == 1) {
                this.debug("hasSequencePair ");
                ByteString sequencePair = this.decodeSequence(input, readLength);
                this.debug("readBits= " + input.readBits());
                result.setSequencePair(sequencePair);
            }
            if (input.readBit() == 1) {
                this.debug("hasQualPair ");
                ByteString qualPair = this.decodeQualityScore(input, readLength);
                this.debug("readBits= " + input.readBits());
                result.setQualityScoresPair(qualPair);
            }
            result.clearCompressedData();
            this.isFirstDecode = false;
            input.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void debug(String text) {
    }

    @Override
    public final void newChunk() {
        this.reset();
        this.isFirstCode = true;
        this.isFirstDecode = true;
    }

    private void reset() {
        this.sequenceCoder = new FastArithmeticCoder(5);
        this.sequenceDecoder = new FastArithmeticDecoder(5);
        this.qualityScoreCoder = new FastArithmeticCoder(255);
        this.qualityScoreDecoder = new FastArithmeticDecoder(255);
    }

    public ReadCodecImpl() {
        this.newChunk();
    }

    private ByteString decodeSequence(InputBitStream input, int readLength) throws IOException {
        this.buffer.clear();
        this.sequenceDecoder.reset();
        for (int i = 0; i < readLength; ++i) {
            int decoded = this.sequenceDecoder.decode(input);
            this.buffer.add(this.decodeBase(decoded));
        }
        this.sequenceDecoder.reposition(input);
        return ByteString.copyFrom((byte[])this.buffer.toByteArray(), (int)0, (int)readLength);
    }

    private ByteString decodeQualityScore(InputBitStream input, int readLength) throws IOException {
        this.buffer.clear();
        this.qualityScoreDecoder.reset();
        for (int i = 0; i < readLength; ++i) {
            this.buffer.add((byte)this.qualityScoreDecoder.decode(input));
        }
        this.qualityScoreDecoder.reposition(input);
        return ByteString.copyFrom((byte[])this.buffer.toByteArray(), (int)0, (int)readLength);
    }
}

