/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.lang.MutableString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.io.LineIterator;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;

public class PicardFastaIndexedSequence
implements RandomAccessSequenceInterface {
    IndexedFastaSequenceFile delegate;
    final int[] lengths;
    final Object2IntMap<String> namesToIndices = new Object2IntAVLTreeMap();
    final String[] names;
    private ReferenceSequence cachedSeq;
    private final MutableString baseBuffer = new MutableString();
    private FastaSequenceIndex indexDelegate;
    private long[] basesPerLine;
    private int cachedReferenceIndex = -1;
    int cachedStart = -1;
    int cachedStop = -1;

    public PicardFastaIndexedSequence(String filename) throws FileNotFoundException {
        this.delegate = new IndexedFastaSequenceFile(new File(filename));
        this.indexDelegate = new FastaSequenceIndex(new File(filename + ".fai"));
        int numContigs = this.indexDelegate.size();
        if (!this.delegate.isIndexed()) {
            throw new FileNotFoundException("An fasta idx index must be found for filename " + filename);
        }
        this.lengths = new int[numContigs];
        this.names = new String[numContigs];
        this.basesPerLine = new long[numContigs];
        LineIterator lineIt = new LineIterator((Reader)new FileReader(filename + ".fai"));
        int index = 0;
        while (lineIt.hasNext()) {
            String line = lineIt.nextLine();
            String[] tokens = line.split("[\\s]");
            this.names[index] = tokens[0];
            this.namesToIndices.put((Object)tokens[0], index);
            this.lengths[index] = Integer.parseInt(tokens[1]);
            this.basesPerLine[index] = Long.parseLong(tokens[2]);
            ++index;
        }
    }

    @Override
    public char get(int referenceIndex, int position) {
        if (position >= this.cachedStart && position < this.cachedStop && referenceIndex == this.cachedReferenceIndex) {
            return this.baseBuffer.charAt(position - this.cachedStart);
        }
        this.getRange(referenceIndex, position, Math.min(this.lengths[referenceIndex] - position, 10000), this.baseBuffer);
        return this.baseBuffer.charAt(position - this.cachedStart);
    }

    @Override
    public int getLength(int targetIndex) {
        return this.lengths[targetIndex];
    }

    @Override
    public void getRange(int referenceIndex, int position, int length, MutableString bases) {
        bases.setLength(0);
        int stop = Math.max(position + length, this.lengths[referenceIndex] - position);
        int oneBasedPosition = position + 1;
        ReferenceSequence seq = this.delegate.getSubsequenceAt(this.names[referenceIndex], (long)oneBasedPosition, (long)stop);
        assert (seq.getContigIndex() == referenceIndex) : " contig index and reference index must match.";
        boolean i = false;
        for (byte b : seq.getBases()) {
            char c = (char)b;
            if (c == '\n') continue;
            bases.append((char)b);
        }
        this.cachedStart = position;
        this.cachedStop = stop;
        this.cachedSeq = seq;
        this.cachedReferenceIndex = referenceIndex;
    }

    @Override
    public int getReferenceIndex(String referenceId) {
        return this.namesToIndices.getInt((Object)referenceId);
    }

    @Override
    public String getReferenceName(int index) {
        return this.names[index];
    }

    @Override
    public int size() {
        return this.names.length;
    }

    public void print(int referenceIndex) {
        for (int i = 0; i < this.getLength(referenceIndex); ++i) {
            if ((long)i % this.basesPerLine[referenceIndex] == 0L) {
                System.out.println(" " + i + " ");
            }
            System.out.print(this.get(referenceIndex, i));
        }
    }
}

