/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.cram.IGVReferenceSource;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.URLUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BAMReader
implements AlignmentReader<PicardAlignment> {
    static Logger log = Logger.getLogger(BAMReader.class);
    private final ResourceLocator locator;
    private final boolean requireIndex;
    SAMFileHeader header;
    List<String> sequenceNames;
    private boolean indexed = false;
    private Map<String, Long> sequenceDictionary;
    static CloseableIterator<PicardAlignment> EMPTY_ITERATOR = new CloseableIterator<PicardAlignment>(){

        public void close() {
        }

        public boolean hasNext() {
            return false;
        }

        public PicardAlignment next() {
            return null;
        }
    };

    public BAMReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        this.locator = locator;
        this.requireIndex = requireIndex;
        SamReader reader = this.getSamReader();
        this.header = reader.getFileHeader();
    }

    private SamReader getSamReader() throws IOException {
        SamInputResource resource;
        boolean isLocal = this.locator.isLocal();
        SamReaderFactory factory = SamReaderFactory.makeDefault().referenceSource((CRAMReferenceSource)new IGVReferenceSource()).validationStringency(ValidationStringency.SILENT);
        if (isLocal) {
            resource = SamInputResource.of((File)new File(this.locator.getPath()));
        } else {
            URL url = HttpUtils.createURL(this.locator.getPath());
            resource = this.requireIndex ? SamInputResource.of((SeekableStream)IGVSeekableStreamFactory.getInstance().getStreamFor(url)) : SamInputResource.of((InputStream)new BufferedInputStream(HttpUtils.getInstance().openConnectionStream(url)));
        }
        if (this.requireIndex) {
            String indexPath = this.getExplicitIndexPath(this.locator);
            if (indexPath == null || indexPath.length() == 0) {
                indexPath = this.getIndexPath(this.locator.getPath());
            }
            this.indexed = true;
            if (isLocal) {
                File indexFile = new File(indexPath);
                resource = resource.index(indexFile);
            } else {
                SeekableStream indexStream = IGVSeekableStreamFactory.getInstance().getStreamFor(HttpUtils.createURL(indexPath));
                resource = resource.index(indexStream);
            }
        }
        return factory.open(resource);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized SAMFileHeader getFileHeader() {
        if (this.header == null) {
            try {
                this.header = this.getSamReader().getFileHeader();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.header;
    }

    @Override
    public boolean hasIndex() {
        return this.indexed;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            this.loadSequenceDictionary();
        }
        return this.sequenceNames;
    }

    @Override
    public Map<String, Long> getSequenceDictionary() {
        if (this.sequenceDictionary == null) {
            this.loadSequenceDictionary();
        }
        return this.sequenceDictionary;
    }

    private void loadSequenceDictionary() {
        SAMFileHeader header = this.getFileHeader();
        this.sequenceNames = new ArrayList<String>();
        this.sequenceDictionary = new HashMap<String, Long>();
        List records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                Long size = new Long(rec.getSequenceLength());
                this.sequenceNames.add(chr);
                this.sequenceDictionary.put(chr, size);
            }
        }
    }

    @Override
    public CloseableIterator<PicardAlignment> iterator() throws IOException {
        return new WrappedIterator((CloseableIterator<SAMRecord>)this.getSamReader().iterator());
    }

    @Override
    public CloseableIterator<PicardAlignment> query(String sequence, int start, int end, boolean contained) {
        if (this.sequenceDictionary != null && !this.sequenceDictionary.containsKey(sequence)) {
            return EMPTY_ITERATOR;
        }
        Object iter = null;
        try {
            SamReader samReader = this.getSamReader();
            return new PicardIterator(samReader, sequence, start + 1, end, contained);
        }
        catch (Exception e) {
            log.error((Object)("Error querying for sequence: " + sequence), (Throwable)e);
            return new EmptyAlignmentIterator();
        }
    }

    private String getExplicitIndexPath(ResourceLocator locator) {
        String p = locator.getPath().toLowerCase();
        String idx = locator.getIndexPath();
        if (idx == null && (p.startsWith("http://") || p.startsWith("https://"))) {
            try {
                Map<String, String> parameters;
                URL url = HttpUtils.createURL(locator.getPath());
                String queryString = url.getQuery();
                if (queryString != null && (parameters = URLUtils.parseQueryString(queryString)).containsKey("index")) {
                    idx = parameters.get("index");
                }
            }
            catch (MalformedURLException e) {
                log.error((Object)("Error parsing url: " + locator.getPath()));
            }
        }
        return idx;
    }

    private String getIndexPath(String pathOrURL) throws IOException {
        String defaultValue;
        Object indexPath;
        ArrayList<Object> pathsTried = new ArrayList<Object>();
        if (URLUtils.isURL(pathOrURL)) {
            String path = URLUtils.getPath(pathOrURL);
            if (path.endsWith(".bam")) {
                indexPath = URLUtils.addExtension(pathOrURL, ".bai");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
                indexPath = URLUtils.replaceExtension(pathOrURL, ".bam", ".bai");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
                indexPath = URLUtils.addExtension(pathOrURL, ".csi");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
                indexPath = URLUtils.replaceExtension(pathOrURL, ".bam", ".csi");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
            }
            if (path.endsWith(".cram")) {
                indexPath = URLUtils.addExtension(pathOrURL, ".crai");
                if (FileUtils.resourceExists((String)indexPath)) {
                    pathsTried.add(indexPath);
                    return indexPath;
                }
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 5) + ".crai";
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
        } else {
            indexPath = pathOrURL + ".bai";
            if (FileUtils.resourceExists((String)indexPath)) {
                return indexPath;
            }
            if (((String)indexPath).contains(".bam.bai")) {
                indexPath = ((String)indexPath).replaceFirst(".bam.bai", ".bai");
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            } else {
                indexPath = ((String)indexPath).replaceFirst(".bai", ".bam.bai");
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
            indexPath = pathOrURL + ".csi";
            pathsTried.add(indexPath);
            if (FileUtils.resourceExists((String)indexPath)) {
                return indexPath;
            }
            if (pathOrURL.endsWith(".bam")) {
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 4) + ".csi";
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
            if (pathOrURL.endsWith(".cram")) {
                indexPath = pathOrURL + ".crai";
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 5) + ".crai";
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
        }
        if ((indexPath = MessageUtils.showInputDialog("Index is required, but no index found.  Please enter path to index file:", defaultValue = pathOrURL + (pathOrURL.endsWith(".cram") ? ".crai" : ".bai"))) != null && FileUtils.resourceExists((String)indexPath)) {
            return indexPath;
        }
        Object msg = "Index file not found.  Tried ";
        for (String string : pathsTried) {
            msg = (String)msg + "<br>" + string;
        }
        throw new DataLoadException((String)msg, (String)indexPath);
    }

    static class PicardIterator
    implements CloseableIterator<PicardAlignment> {
        private SamReader reader;
        CloseableIterator<SAMRecord> iterator;

        public PicardIterator(SamReader samReader, String sequence, int start, int end, boolean contained) {
            this.reader = samReader;
            this.iterator = samReader.query(sequence, start, end, contained);
        }

        public void close() {
            this.iterator.close();
            try {
                this.reader.close();
            }
            catch (IOException e) {
                log.error((Object)"Error closing SamReader", (Throwable)e);
            }
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public PicardAlignment next() {
            return new PicardAlignment((SAMRecord)this.iterator.next());
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

