/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.GenomeSummaryData;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

public class DatasetDataSource
extends AbstractDataSource {
    private Logger log = Logger.getLogger(DatasetDataSource.class);
    String trackId;
    Dataset dataset;
    GenomeSummaryData genomeSummaryData;

    public DatasetDataSource(String trackId, Dataset dataset, Genome genome) {
        super(genome);
        this.trackId = trackId;
        this.dataset = dataset;
        if (genome != null && genome.getHomeChromosome() != null && genome.getHomeChromosome().equals("All")) {
            if (dataset instanceof IGVDataset) {
                this.genomeSummaryData = ((IGVDataset)dataset).getGenomeSummary();
            } else {
                this.genomeSummaryData = new GenomeSummaryData(genome, new String[]{trackId});
                for (Chromosome chr : genome.getChromosomes()) {
                    int[] startLocations = dataset.getStartLocations(chr.getName());
                    if (chr.getName().equals("All") || startLocations == null || startLocations.length <= 0) continue;
                    HashMap<String, float[]> dMap = new HashMap<String, float[]>();
                    dMap.put(trackId, dataset.getData(trackId, chr.getName()));
                    this.genomeSummaryData.addData(chr.getName(), startLocations, dMap);
                }
            }
        }
    }

    @Override
    protected DataTile getRawData(String chr, int startLocation, int endLocation) {
        if (chr.equals("All") && this.genomeSummaryData != null && this.windowFunction != WindowFunction.none) {
            int[] startLocs = this.genomeSummaryData.getLocations();
            int[] endLocs = null;
            float[] data = this.genomeSummaryData.getData(this.trackId);
            return new DataTile(startLocs, endLocs, data, null);
        }
        if (chr.equals("All")) {
            return this.getWGRawData();
        }
        int[] startLocs = this.dataset.getStartLocations(chr);
        int[] endLocs = this.dataset.getEndLocations(chr);
        float[] data = this.dataset.getData(this.trackId, chr);
        String[] features = this.dataset.getFeatureNames(chr);
        if (startLocs == null || data == null || data.length == 0) {
            return null;
        }
        return new DataTile(startLocs, endLocs, data, features);
    }

    private DataTile getWGRawData() {
        int size = 0;
        for (String chr : this.genome.getAllChromosomeNames()) {
            int[] s = this.dataset.getStartLocations(chr);
            int[] e = this.dataset.getEndLocations(chr);
            float[] d = this.dataset.getData(this.trackId, chr);
            if (s == null || d == null) continue;
            size += s.length;
        }
        if (size == 0) {
            return null;
        }
        int[] startLocs = new int[size];
        int[] endLocs = new int[size];
        float[] data = new float[size];
        String[] features = new String[size];
        int i = 0;
        for (String chr : this.genome.getAllChromosomeNames()) {
            int[] s = this.dataset.getStartLocations(chr);
            int[] e = this.dataset.getEndLocations(chr);
            float[] d = this.dataset.getData(this.trackId, chr);
            String[] f = this.dataset.getFeatureNames(chr);
            if (s == null || d == null) continue;
            int l = s.length;
            for (int j = 0; j < l; ++j) {
                startLocs[i] = this.genome.getGenomeCoordinate(chr, s[j]);
                endLocs[i] = e == null ? startLocs[i] + 1 : this.genome.getGenomeCoordinate(chr, e[j]);
                data[i] = d[j];
                if (f != null) {
                    features[i] = f[j];
                }
                ++i;
            }
        }
        return new DataTile(startLocs, endLocs, data, features);
    }

    @Override
    protected List<LocusScore> getPrecomputedSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return null;
    }

    @Override
    public TrackType getTrackType() {
        try {
            return this.dataset.getType();
        }
        catch (Exception exception) {
            return TrackType.OTHER;
        }
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataset.isLogNormalized();
    }

    @Override
    public double getDataMax() {
        return this.dataset.getDataMax();
    }

    @Override
    public double getDataMin() {
        return this.dataset.getDataMin();
    }

    @Override
    public int getLongestFeature(String chr) {
        return this.dataset.getLongestFeature(chr);
    }
}

