/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_marker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class markerDialog
implements ActionListener,
WindowListener,
TableModel {
    private ArrayList<FCS_marker> theMarkers;
    private JButton OK_Button = new JButton("OK");
    private JButton CANCEL_Button = new JButton("Cancel");
    private boolean isOK = false;
    private JDialog theDialog = new JDialog();

    private markerDialog() {
    }

    public markerDialog(ArrayList<FCS_marker> paramMarkers) {
        this.theMarkers = paramMarkers;
        this.theDialog.setModal(true);
        this.theDialog.setTitle("Edit markers");
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.OK_Button);
        buttonPanel.add(this.CANCEL_Button);
        this.OK_Button.addActionListener(this);
        this.CANCEL_Button.addActionListener(this);
        this.theDialog.add((Component)buttonPanel, "South");
        this.theDialog.setDefaultCloseOperation(1);
        JTable theTable = new JTable(this);
        JScrollPane theScroller = new JScrollPane(theTable);
        this.theDialog.add((Component)theScroller, "Center");
        this.theDialog.setLocationByPlatform(true);
        this.theDialog.setSize(400, 200);
    }

    public boolean showDialog() {
        this.theDialog.setVisible(true);
        return this.isOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.OK_Button) {
            this.isOK = true;
        }
        this.theDialog.setVisible(false);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.isOK = false;
        this.theDialog.setVisible(false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public int getRowCount() {
        return this.theMarkers.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Lower Channel";
            }
            case 2: {
                return "Higher Channel";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.theMarkers.size() - 1) {
            return new IllegalArgumentException();
        }
        if (columnIndex < 0 || columnIndex > 3) {
            return new IllegalArgumentException();
        }
        FCS_marker currMarker = this.theMarkers.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return currMarker.getName();
            }
            case 1: {
                return currMarker.getLowerLimit();
            }
            case 2: {
                return currMarker.getUpperLimit();
            }
        }
        return 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.theMarkers.size() - 1) {
            return;
        }
        if (columnIndex < 0 || columnIndex > 3) {
            return;
        }
        FCS_marker currMarker = this.theMarkers.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                currMarker.setName(aValue.toString());
                return;
            }
            case 1: {
                if (aValue instanceof Integer) {
                    currMarker.setLowerLimit((Integer)aValue);
                }
                return;
            }
            case 2: {
                if (aValue instanceof Integer) {
                    currMarker.setUpperLimit((Integer)aValue);
                }
                return;
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

